/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils;

import java.util.Comparator;
import java.util.List;

public class MultiComparator<T>
implements Comparator<T> {
    private final Comparator<T>[] comparators;

    public MultiComparator(List<Comparator<T>> comparators) {
        this.comparators = comparators.toArray(new Comparator[comparators.size()]);
    }

    public MultiComparator(Comparator<T> ... comparators) {
        this.comparators = comparators;
    }

    @Override
    public int compare(T o1, T o2) {
        for (Comparator<T> comparator : this.comparators) {
            int cmp = comparator.compare(o1, o2);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }
}

