/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.annotation;

import htsjdk.samtools.util.Interval;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class GTFRecord
implements Comparable<GTFRecord> {
    private final Interval interval;
    private final String geneID;
    private final String geneName;
    private final String transcriptName;
    private final String transcriptID;
    private final String transcriptType;
    private final String featureType;
    private final Integer geneVersion;

    public GTFRecord(String chromsome, int start, int end, boolean negativeStrand, String geneID, String geneName, String transcriptName, String transcriptID, String transcriptType, String featureType, Integer geneVersion) {
        this.interval = new Interval(chromsome, start, end, negativeStrand, null);
        this.geneID = geneID;
        this.geneName = geneName;
        this.transcriptName = transcriptName;
        this.transcriptID = transcriptID;
        this.transcriptType = transcriptType;
        this.featureType = featureType;
        this.geneVersion = geneVersion;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public String getStrandAsString() {
        if (this.interval.isNegativeStrand()) {
            return "-";
        }
        return "+";
    }

    public String getChromosome() {
        return this.interval.getContig();
    }

    public int getStart() {
        return this.interval.getStart();
    }

    public int getEnd() {
        return this.interval.getEnd();
    }

    public boolean isNegativeStrand() {
        return this.interval.isNegativeStrand();
    }

    public String getGeneID() {
        return this.geneID;
    }

    public String getGeneName() {
        return this.geneName;
    }

    public String getTranscriptName() {
        return this.transcriptName;
    }

    public String getTranscriptID() {
        return this.transcriptID;
    }

    public String getTranscriptType() {
        return this.transcriptType;
    }

    public String getFeatureType() {
        return this.featureType;
    }

    public Integer getGeneVersion() {
        return this.geneVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GTFRecord that = (GTFRecord)o;
        if (!Objects.equals(this.interval, that.interval)) {
            return false;
        }
        if (!Objects.equals(this.geneID, that.geneID)) {
            return false;
        }
        if (!Objects.equals(this.geneName, that.geneName)) {
            return false;
        }
        if (!Objects.equals(this.transcriptName, that.transcriptName)) {
            return false;
        }
        if (!Objects.equals(this.transcriptID, that.transcriptID)) {
            return false;
        }
        if (!Objects.equals(this.transcriptType, that.transcriptType)) {
            return false;
        }
        return Objects.equals(this.featureType, that.featureType);
    }

    public int hashCode() {
        int result = this.interval.hashCode();
        result = 31 * result + this.geneID.hashCode();
        result = 31 * result + this.geneName.hashCode();
        result = 31 * result + this.hashCodeIfNotNull(this.transcriptName);
        result = 31 * result + this.hashCodeIfNotNull(this.transcriptID);
        result = 31 * result + this.hashCodeIfNotNull(this.transcriptType);
        result = 31 * result + this.featureType.hashCode();
        return result;
    }

    private int hashCodeIfNotNull(String str) {
        if (str == null) {
            return 0;
        }
        return str.hashCode();
    }

    public List<String> validate() {
        List<String> ret = null;
        ret = this.addErrorIfNull(ret, "Missing sequence name", this.interval.getContig());
        ret = this.addErrorIfNull(ret, "Missing gene_id", this.geneID);
        ret = this.addErrorIfNull(ret, "Missing gene_name", this.geneName);
        ret = this.addErrorIfNull(ret, "Missing feature type", this.featureType);
        if (this.featureType != null && !this.featureType.equals("gene")) {
            ret = this.addErrorIfNull(ret, "Missing transcript_name", this.transcriptName);
            ret = this.addErrorIfNull(ret, "Missing transcript_id", this.transcriptID);
        }
        if (this.geneName.contains(",")) {
            ret = this.addError(ret, "Reserved character ',' in gene name [" + this.geneName + "]");
        }
        return ret;
    }

    private List<String> addErrorIfNull(List<String> errorList, String message, Object value) {
        if (value == null) {
            return this.addError(errorList, message);
        }
        return errorList;
    }

    private List<String> addError(List<String> errorList, String message) {
        if (errorList == null) {
            errorList = new ArrayList<String>();
        }
        errorList.add(message);
        return errorList;
    }

    @Override
    public int compareTo(GTFRecord o) {
        return this.interval.compareTo(o.getInterval());
    }

    public String toString() {
        return this.interval.toString() + " [" + this.geneName + " " + this.featureType + "]";
    }
}

