/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.broadinstitute.dropseqrna.cmdline.DropSeq;
import org.broadinstitute.dropseqrna.utils.BaseDistributionMetric;
import org.broadinstitute.dropseqrna.utils.BaseDistributionMetricCollection;
import org.broadinstitute.dropseqrna.utils.Bases;
import org.broadinstitute.dropseqrna.utils.OutputWriterUtil;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;

@CommandLineProgramProperties(usage="Reads each base and generates a composition per-position matrix", usageShort="Reads each base and generates a composition per-position matrix", programGroup=DropSeq.class)
public class BaseDistributionAtReadPosition
extends CommandLineProgram {
    private final Log log = Log.getInstance(BaseDistributionAtReadPosition.class);
    @Option(shortName="I", doc="The input SAM or BAM file to analyze.")
    public File INPUT;
    @Option(shortName="O", doc="Output report")
    public File OUTPUT;
    @Option(doc="Read to gather statistics on [1/2].  If this is set, the tag is ignored.", optional=true)
    public Integer READ_NUMBER = null;
    @Option(doc="Tag to gather statistics on.  If this is set, the read number is ignored.", optional=true)
    public String TAG = null;

    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        BaseDistributionMetricCollection result = null;
        result = this.TAG != null ? this.gatherBaseQualities(this.INPUT, this.TAG) : this.gatherBaseQualities(this.INPUT);
        this.writeOutput(result, this.OUTPUT);
        return 0;
    }

    void writeOutput(BaseDistributionMetricCollection result, File output) {
        BufferedWriter writer = OutputWriterUtil.getWriter(output);
        Object[] header = new String[]{"position", "A", "C", "G", "T", "N"};
        String h = StringUtils.join((Object[])header, (String)"\t");
        OutputWriterUtil.writeResult(h, writer);
        List<Integer> sortedKeys = result.getPositions();
        for (Integer i : sortedKeys) {
            BaseDistributionMetric brd = result.getDistributionAtPosition(i);
            Object[] l = new String[]{i + "", brd.getCount(Bases.A.getBase()) + "", brd.getCount(Bases.C.getBase()) + "", brd.getCount(Bases.G.getBase()) + "", brd.getCount(Bases.T.getBase()) + "", brd.getCount(Bases.N.getBase()) + ""};
            String line = StringUtils.join((Object[])l, (String)"\t");
            OutputWriterUtil.writeResult(line, writer);
        }
        OutputWriterUtil.closeWriter(writer);
    }

    BaseDistributionMetricCollection gatherBaseQualities(File input) {
        ProgressLogger p = new ProgressLogger(this.log);
        SamReader inputSam = SamReaderFactory.makeDefault().open(input);
        BaseDistributionMetricCollection c = new BaseDistributionMetricCollection();
        for (SAMRecord samRecord : inputSam) {
            p.record(samRecord);
            if (samRecord.isSecondaryOrSupplementary()) continue;
            boolean readPaired = samRecord.getReadPairedFlag();
            boolean firstRead = false;
            if (!readPaired & this.READ_NUMBER == 2 || (firstRead = !readPaired & this.READ_NUMBER == 1 ? true : samRecord.getFirstOfPairFlag()) && this.READ_NUMBER != 1 || !firstRead && this.READ_NUMBER == 1) continue;
            byte[] bases = samRecord.getReadBases();
            for (int i = 0; i < bases.length; ++i) {
                char base = (char)bases[i];
                int idx = i + 1;
                c.addBase(base, idx);
            }
        }
        CloserUtil.close((Object)inputSam);
        return c;
    }

    BaseDistributionMetricCollection gatherBaseQualities(File input, String tag) {
        ProgressLogger pl = new ProgressLogger(this.log);
        SamReader inputSam = SamReaderFactory.makeDefault().open(input);
        BaseDistributionMetricCollection c = new BaseDistributionMetricCollection();
        for (SAMRecord samRecord : inputSam) {
            String b;
            pl.record(samRecord);
            if (samRecord.isSecondaryOrSupplementary() || (b = samRecord.getStringAttribute(tag)) == null) continue;
            byte[] bases = b.getBytes();
            for (int i = 0; i < bases.length; ++i) {
                char base = (char)bases[i];
                int idx = i + 1;
                c.addBase(base, idx);
            }
        }
        CloserUtil.close((Object)inputSam);
        return c;
    }

    public static void main(String[] args) {
        System.exit(new BaseDistributionAtReadPosition().instanceMain(args));
    }
}

