/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils;

import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.broadinstitute.dropseqrna.cmdline.DropSeq;
import org.broadinstitute.dropseqrna.utils.CustomBAMIterators;
import org.broadinstitute.dropseqrna.utils.modularfileparser.DelimiterParser;
import org.broadinstitute.dropseqrna.utils.modularfileparser.ModularFileParser;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;

@CommandLineProgramProperties(usage="Filters a BAM file based on a TAG and a file containing a list of values.  This is pretty similar to grepping with a file, but is faster and makes a proper BAM.", usageShort="Filters a BAM file based on a TAG and a file containing a list of values.", programGroup=DropSeq.class)
public class FilterBAMByTag
extends CommandLineProgram {
    private final Log log = Log.getInstance(FilterBAMByTag.class);
    @Option(shortName="I", doc="The input SAM or BAM file to analyze.")
    public File INPUT;
    @Option(shortName="O", doc="Output report")
    public File OUTPUT;
    @Option(doc="The BAM tag to filter on.")
    public String TAG;
    @Option(doc="A file with 1 column and 1 or more rows containing a barcode value per line.", optional=true)
    public File TAG_VALUES_FILE;
    @Option(doc="A single value for filtering reads.  Use instead of TAG_VALUES_FILE.", optional=true)
    public String TAG_VALUE;
    @Option(doc="If having a tag value matches the values in the file, accept the read.  If set to false, reject the read.")
    public Boolean ACCEPT_TAG = true;
    @Option(doc="In Paired Read Mode if the tag value is on either read the pair of reads is kept or discarded. This is slower when turned on because of the need to queryname sort the data, so only turn it on if you need it!")
    public Boolean PAIRED_MODE = false;

    protected int doWork() {
        Set<Object> values;
        if (this.TAG_VALUES_FILE == null && this.TAG == null) {
            this.log.error(new Object[]{"You must set either a file of tag values, or a single tag value."});
            System.exit(1);
        }
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (this.TAG_VALUES_FILE != null) {
            IOUtil.assertFileIsReadable((File)this.TAG_VALUES_FILE);
            values = this.readValues(this.TAG_VALUES_FILE);
        } else {
            values = new HashSet();
            if (this.TAG_VALUE != null) {
                values.add(this.TAG_VALUE);
            }
        }
        SamReader in = SamReaderFactory.makeDefault().enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.EAGERLY_DECODE}).open(this.INPUT);
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMOrBAMWriter(in.getFileHeader(), true, this.OUTPUT);
        if (!this.PAIRED_MODE.booleanValue()) {
            this.processUnpairedMode(in, out, values);
        } else {
            this.processPairedMode(in, out, values);
        }
        return 0;
    }

    void processUnpairedMode(SamReader in, SAMFileWriter out, Set<String> values) {
        ProgressLogger progLog = new ProgressLogger(this.log);
        for (SAMRecord r : in) {
            progLog.record(r);
            boolean filterFlag = this.filterRead(r, this.TAG, values, this.ACCEPT_TAG);
            if (filterFlag) continue;
            out.addAlignment(r);
        }
        CloserUtil.close((Object)in);
        out.close();
    }

    void processPairedMode(SamReader in, SAMFileWriter out, Set<String> values) {
        ProgressLogger progLog = new ProgressLogger(this.log);
        PeekableIterator iter = new PeekableIterator(CustomBAMIterators.getQuerynameSortedRecords(in));
        while (iter.hasNext()) {
            SAMRecord r1 = (SAMRecord)iter.next();
            progLog.record(r1);
            boolean filterFlag1 = this.filterRead(r1, this.TAG, values, this.ACCEPT_TAG);
            SAMRecord r2 = null;
            if (iter.hasNext()) {
                r2 = (SAMRecord)iter.peek();
            }
            if (r2 != null && r1.getReadName().equals(r2.getReadName())) {
                progLog.record(r2);
                r2 = (SAMRecord)iter.next();
                boolean filterFlag2 = this.filterRead(r2, this.TAG, values, this.ACCEPT_TAG);
                if (filterFlag1 && !(!filterFlag2 & this.ACCEPT_TAG) && (filterFlag1 || !(!filterFlag2 & this.ACCEPT_TAG == false))) continue;
                out.addAlignment(r1);
                out.addAlignment(r2);
                continue;
            }
            if (filterFlag1) continue;
            out.addAlignment(r1);
        }
        CloserUtil.close((Object)in);
        out.close();
    }

    boolean retainByReadNumber(SAMRecord r, int desiredReadNumber) {
        boolean readPaired = r.getReadPairedFlag();
        if (!readPaired) {
            return true;
        }
        boolean firstRead = r.getFirstOfPairFlag();
        return (!firstRead || desiredReadNumber == 1) && (firstRead || desiredReadNumber != 1);
    }

    boolean filterRead(SAMRecord r, String tag, Set<String> values, boolean acceptFlag) {
        Object v = r.getAttribute(tag);
        if (v == null && acceptFlag) {
            return true;
        }
        if (v == null && !acceptFlag) {
            return false;
        }
        String vv = null;
        if (v instanceof Integer) {
            Integer o = (Integer)v;
            vv = Integer.toString(o);
        } else if (v instanceof String) {
            vv = (String)v;
        } else {
            this.log.info(new Object[]{"WHAT ELSE"});
        }
        boolean hasElement = true;
        if (values != null && values.size() > 0) {
            hasElement = values.contains(vv);
        }
        if (hasElement & acceptFlag | !hasElement & !acceptFlag) {
            return false;
        }
        return !hasElement & acceptFlag | hasElement & !acceptFlag;
    }

    private Set<String> readValues(File f) {
        HashSet<String> result = new HashSet<String>();
        ModularFileParser p = new ModularFileParser(new DelimiterParser(","), f, 0);
        String[] line = null;
        while ((line = p.readNextLine()) != null) {
            result.add(line[0]);
        }
        p.close();
        return result;
    }

    public static void main(String[] args) {
        System.exit(new FilterBAMByTag().instanceMain(args));
    }
}

