/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence;

import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.compound.RNACompoundSet;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.ProxySequenceReader;
import org.biojava.nbio.core.sequence.template.SequenceView;
import org.biojava.nbio.core.sequence.transcription.TranscriptionEngine;
import org.biojava.nbio.core.sequence.views.ComplementSequenceView;
import org.biojava.nbio.core.sequence.views.ReversedSequenceView;

public class RNASequence
extends AbstractSequence<NucleotideCompound> {
    public RNASequence(String seqString) throws CompoundNotFoundException {
        super(seqString, RNACompoundSet.getRNACompoundSet());
    }

    public RNASequence(ProxySequenceReader<NucleotideCompound> proxyLoader) {
        super(proxyLoader, RNACompoundSet.getRNACompoundSet());
    }

    public RNASequence(String seqString, CompoundSet<NucleotideCompound> compoundSet) throws CompoundNotFoundException {
        super(seqString, compoundSet);
    }

    public RNASequence(ProxySequenceReader<NucleotideCompound> proxyLoader, CompoundSet<NucleotideCompound> compoundSet) {
        super(proxyLoader, compoundSet);
    }

    public SequenceView<NucleotideCompound> getReverseComplement() {
        return new ComplementSequenceView<NucleotideCompound>(this.getInverse());
    }

    @Override
    public SequenceView<NucleotideCompound> getInverse() {
        return new ReversedSequenceView<NucleotideCompound>(this);
    }

    public SequenceView<NucleotideCompound> getComplement() {
        return new ComplementSequenceView<NucleotideCompound>(this);
    }

    public ProteinSequence getProteinSequence() {
        return this.getProteinSequence(TranscriptionEngine.getDefault());
    }

    public ProteinSequence getProteinSequence(TranscriptionEngine engine) {
        return (ProteinSequence)engine.getRnaAminoAcidTranslator().createSequence(this);
    }

    public double getGC() {
        throw new UnsupportedOperationException("Not supported yet");
    }
}

