/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.editdistance;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.broadinstitute.dropseqrna.TranscriptomeException;
import org.broadinstitute.dropseqrna.utils.ObjectCounter;
import org.broadinstitute.dropseqrna.utils.editdistance.HammingDistance;
import org.broadinstitute.dropseqrna.utils.editdistance.LevenshteinDistance;

public class EDUtils {
    private static EDUtils singletonInstance;

    public static EDUtils getInstance() {
        if (null == singletonInstance) {
            singletonInstance = new EDUtils();
        }
        return singletonInstance;
    }

    private EDUtils() {
    }

    public Set<String> getStringsWithinEditDistanceWithIndel(String baseString, List<String> comparisonStrings, int editDistance) {
        HashSet<String> result = new HashSet<String>();
        for (String b : comparisonStrings) {
            int ed = LevenshteinDistance.getIndelSlidingWindowEditDistance(baseString, b);
            if (ed > editDistance) continue;
            result.add(b);
        }
        return result;
    }

    public Set<String> getStringsWithinEditDistance(String baseString, List<String> comparisonStrings, int editDistance) {
        HashSet<String> result = new HashSet<String>();
        for (String b : comparisonStrings) {
            int ed = HammingDistance.getHammingDistance(baseString, b);
            if (ed > editDistance) continue;
            result.add(b);
        }
        return result;
    }

    public Set<String> getStringsWithinHammingDistance(String baseString, List<String> comparisonStrings, int editDistance) {
        HashSet<String> result = new HashSet<String>();
        for (String b : comparisonStrings) {
            boolean flag = HammingDistance.greaterThanHammingDistance(baseString, b, editDistance);
            if (flag) continue;
            result.add(b);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectCounter<String> readBarCodeFile(File aFile) {
        ObjectCounter<String> result = new ObjectCounter<String>();
        try (BufferedReader input = new BufferedReader(new FileReader(aFile));){
            String line = null;
            while ((line = input.readLine()) != null) {
                line = line.trim();
                String[] strLine = line.split("\t");
                int count = Integer.parseInt(strLine[0]);
                String barcode = strLine[1].toUpperCase();
                result.incrementByCount(barcode, count);
            }
        }
        catch (IOException ex) {
            throw new TranscriptomeException("Could not read file: " + aFile.toString());
        }
        return result;
    }
}

