/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.readtrimming;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.Arrays;
import org.broadinstitute.dropseqrna.cmdline.DropSeq;
import org.broadinstitute.dropseqrna.readtrimming.TrimSequenceTemplate;
import org.broadinstitute.dropseqrna.utils.SamHeaderUtil;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;

@CommandLineProgramProperties(usage="Trim the given sequence from the beginning of reads", usageShort="Trim the given sequence from the beginning of reads", programGroup=DropSeq.class)
public class TrimStartingSequence
extends CommandLineProgram {
    private final Log log = Log.getInstance(TrimStartingSequence.class);
    @Option(shortName="I", doc="The input SAM or BAM file to analyze.")
    public File INPUT;
    @Option(shortName="O", doc="The output BAM file")
    public File OUTPUT;
    @Option(doc="The output summary statistics", optional=true)
    public File OUTPUT_SUMMARY;
    @Option(doc="The sequence to look for at the start of reads.")
    public String SEQUENCE;
    @Option(doc="How many mismatches are acceptable in the sequence.")
    public Integer MISMATCHES = 0;
    @Option(doc="How many bases at the begining of the sequence must match before trimming occurs.")
    public Integer NUM_BASES = 0;
    @Option(doc="The tag to set for trimmed reads.  This tags the first base to keep in the read.  6 would mean to trim the first 5 bases.")
    public String TRIM_TAG = "ZS";
    private Integer readsTrimmed = 0;
    private int numReadsTotal = 0;
    private Histogram<Integer> numBasesTrimmed = new Histogram();

    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        ProgressLogger progress = new ProgressLogger(this.log);
        SamReader bamReader = SamReaderFactory.makeDefault().open(this.INPUT);
        SAMFileHeader header = bamReader.getFileHeader();
        SamHeaderUtil.addPgRecord(header, this);
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(header, true, this.OUTPUT);
        TrimSequenceTemplate t = new TrimSequenceTemplate(this.SEQUENCE);
        for (SAMRecord r : bamReader) {
            SAMRecord rr = this.hardClipBarcodeFromRecord(r, t, this.NUM_BASES, this.MISMATCHES);
            writer.addAlignment(rr);
            progress.record(r);
            ++this.numReadsTotal;
        }
        CloserUtil.close((Object)bamReader);
        writer.close();
        this.log.info(new Object[]{"Number of reads trimmed: " + this.readsTrimmed, " total reads: " + this.numReadsTotal});
        if (this.OUTPUT_SUMMARY != null) {
            this.writeSummary(this.numBasesTrimmed);
        }
        return 0;
    }

    private void writeSummary(Histogram<Integer> h) {
        MetricsFile mf = new MetricsFile();
        mf.addHistogram(h);
        TrimMetric tm = new TrimMetric(h);
        mf.addMetric((MetricBase)tm);
        mf.write(this.OUTPUT_SUMMARY);
    }

    SAMRecord hardClipBarcodeFromRecord(SAMRecord r, TrimSequenceTemplate t, int minMatch, int mismatchesAllowed) {
        int templateLength = t.getSequence().length();
        int readLength = r.getReadLength();
        String readString = r.getReadString();
        int templatePosition = t.getPositionInTemplate(readString, minMatch, mismatchesAllowed);
        if (templatePosition == -1) {
            return r;
        }
        TrimStartingSequence trimStartingSequence = this;
        Integer n = trimStartingSequence.readsTrimmed;
        Integer n2 = trimStartingSequence.readsTrimmed = Integer.valueOf(trimStartingSequence.readsTrimmed + 1);
        int firstBaseToKeep = templateLength - templatePosition;
        this.numBasesTrimmed.increment((Comparable)Integer.valueOf(firstBaseToKeep));
        if (templateLength >= readLength) {
            byte[] value = new byte[readLength];
            Arrays.fill(value, (byte)3);
            r.setBaseQualities(value);
            return r;
        }
        byte[] read = r.getReadBases();
        read = Arrays.copyOfRange(read, firstBaseToKeep, read.length);
        r.setReadBases(read);
        readString = r.getReadString();
        byte[] quality = r.getBaseQualities();
        quality = Arrays.copyOfRange(quality, firstBaseToKeep, quality.length);
        r.setBaseQualities(quality);
        r.setAttribute(this.TRIM_TAG, (Object)firstBaseToKeep);
        return r;
    }

    public static void main(String[] args) {
        System.exit(new TrimStartingSequence().instanceMain(args));
    }

    public class TrimMetric
    extends MetricBase {
        public Double mean;
        public Double stdev;

        public TrimMetric(Histogram<Integer> h) {
            this.mean = h.getMean();
            this.stdev = h.getStandardDeviation();
        }

        public Double getMean() {
            return this.mean;
        }

        public Double getStdev() {
            return this.stdev;
        }
    }
}

