/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.readiterators;

import htsjdk.samtools.SAMRecord;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.broadinstitute.dropseqrna.utils.FilteredIterator;

public class CellBarcodeFilteringIterator
extends FilteredIterator<SAMRecord> {
    private final Set<String> cellBarcodes;
    private final String cellBarcodeTag;

    public CellBarcodeFilteringIterator(Iterator<SAMRecord> underlyingIterator, String cellBarcodeTag, Collection<String> cellBarcodes) {
        super(underlyingIterator);
        this.cellBarcodeTag = cellBarcodeTag;
        this.cellBarcodes = cellBarcodes == null ? null : new HashSet<String>(cellBarcodes);
    }

    @Override
    public boolean filterOut(SAMRecord rec) {
        if (this.cellBarcodes == null) {
            return false;
        }
        String cellBarcode = rec.getStringAttribute(this.cellBarcodeTag);
        if (cellBarcode == null) {
            return true;
        }
        return !this.cellBarcodes.contains(cellBarcode);
    }
}

