/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.readiterators;

import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMTagUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.util.ArrayList;
import java.util.List;

public class DEIteratorUtils {
    private static final Log log = Log.getInstance(DEIteratorUtils.class);
    private ProgressLogger progress = new ProgressLogger(log, 100000);
    private Integer MAX_RECORDS_IN_RAM = SAMFileWriterImpl.getDefaultMaxRecordsInRam();

    public static List<Short> getShortBAMTags(List<String> tags) {
        ArrayList<Short> result = new ArrayList<Short>(tags.size());
        for (String tag : tags) {
            short s = SAMTagUtil.getSingleton().makeBinaryTag(tag);
            result.add(s);
        }
        return result;
    }

    public static List<String> getStringBAMTags(List<Short> tags) {
        ArrayList<String> result = new ArrayList<String>(tags.size());
        for (Short tag : tags) {
            String s = SAMTagUtil.getSingleton().makeStringTag(tag.shortValue());
            result.add(s);
        }
        return result;
    }
}

