/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.annotation;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.annotation.Gene;
import picard.annotation.LocusFunction;

public class AnnotationUtils {
    private final Log log = Log.getInstance(AnnotationUtils.class);
    private static AnnotationUtils singleton = null;
    private static Map<LocusFunction, Integer> functionScores;

    private AnnotationUtils() {
        functionScores = new HashMap<LocusFunction, Integer>();
        functionScores.put(LocusFunction.CODING, new Integer(4));
        functionScores.put(LocusFunction.UTR, new Integer(3));
        functionScores.put(LocusFunction.INTRONIC, new Integer(2));
        functionScores.put(LocusFunction.INTERGENIC, new Integer(1));
    }

    public static AnnotationUtils getInstance() {
        if (singleton == null) {
            singleton = new AnnotationUtils();
        }
        return singleton;
    }

    public LocusFunction getLocusFunctionForRead(SAMRecord rec, OverlapDetector<Gene> geneOverlapDetector) {
        Interval readInterval = new Interval(rec.getReferenceName(), rec.getAlignmentStart(), rec.getAlignmentEnd());
        Set overlappingGenes = geneOverlapDetector.getOverlaps((Locatable)readInterval);
        List alignmentBlocks = rec.getAlignmentBlocks();
        LocusFunction[] blockSummaryFunction = new LocusFunction[alignmentBlocks.size()];
        for (int i = 0; i < alignmentBlocks.size(); ++i) {
            LocusFunction blockFunction;
            AlignmentBlock alignmentBlock = (AlignmentBlock)alignmentBlocks.get(i);
            LocusFunction[] blockFunctions = this.getLocusFunctionsByBlock(alignmentBlock, overlappingGenes);
            blockSummaryFunction[i] = blockFunction = this.getLocusFunction(blockFunctions);
        }
        LocusFunction readFunction = this.getLocusFunction(blockSummaryFunction);
        return readFunction;
    }

    private LocusFunction getLocusFunctionForRead(SAMRecord rec, Gene g) {
        List alignmentBlocks = rec.getAlignmentBlocks();
        LocusFunction[] blockSummaryFunction = new LocusFunction[alignmentBlocks.size()];
        HashSet<Gene> temp = new HashSet<Gene>();
        temp.add(g);
        for (int i = 0; i < alignmentBlocks.size(); ++i) {
            LocusFunction blockFunction;
            AlignmentBlock alignmentBlock = (AlignmentBlock)alignmentBlocks.get(i);
            LocusFunction[] blockFunctions = this.getLocusFunctionsByBlock(alignmentBlock, temp);
            blockSummaryFunction[i] = blockFunction = this.getLocusFunction(blockFunctions);
        }
        LocusFunction readFunction = this.getLocusFunction(blockSummaryFunction);
        return readFunction;
    }

    public Map<Gene, LocusFunction> getLocusFunctionForReadByGene(SAMRecord rec, OverlapDetector<Gene> geneOverlapDetector) {
        HashMap<Gene, LocusFunction> result = new HashMap<Gene, LocusFunction>();
        Interval readInterval = new Interval(rec.getReferenceName(), rec.getAlignmentStart(), rec.getAlignmentEnd());
        Set overlappingGenes = geneOverlapDetector.getOverlaps((Locatable)readInterval);
        for (Gene g : overlappingGenes) {
            LocusFunction f = this.getLocusFunctionForRead(rec, g);
            result.put(g, f);
        }
        return result;
    }

    public Set<Gene> getConsistentExons(SAMRecord rec, Set<Gene> genes, boolean allowMultiGeneReads) {
        Set<Gene> result = new HashSet<Gene>();
        String refName = rec.getReferenceName();
        List alignmentBlocks = rec.getAlignmentBlocks();
        for (AlignmentBlock b : alignmentBlocks) {
            Set<Gene> blockGenes = this.getAlignmentBlockonGeneExon(refName, b, genes);
            if (result.size() > 0 && blockGenes.size() > 0) {
                if (allowMultiGeneReads) {
                    result.addAll(blockGenes);
                }
                if (allowMultiGeneReads) continue;
                result.retainAll(blockGenes);
                continue;
            }
            result = blockGenes;
        }
        return result;
    }

    private Set<Gene> getAlignmentBlockonGeneExon(String refName, AlignmentBlock b, Set<Gene> genes) {
        HashSet<Gene> result = new HashSet<Gene>();
        for (Gene g : genes) {
            if (!this.getAlignmentBlockOverlapsExon(refName, b, g)) continue;
            result.add(g);
        }
        return result;
    }

    private boolean getAlignmentBlockOverlapsExon(String refName, AlignmentBlock b, Gene g) {
        Interval ib = this.getInterval(refName, b);
        for (Gene.Transcript t : g) {
            for (Gene.Transcript.Exon e : t.exons) {
                Interval ei = this.getInterval(refName, e);
                if (!ib.intersects(ei)) continue;
                return true;
            }
        }
        return false;
    }

    private Interval getInterval(String refName, Gene.Transcript.Exon e) {
        Interval i = new Interval(refName, e.start, e.end);
        return i;
    }

    private Interval getInterval(String refName, AlignmentBlock b) {
        int s = b.getReferenceStart();
        int e = s + b.getLength() - 1;
        Interval i = new Interval(refName, s, e);
        return i;
    }

    public LocusFunction getLocusFunction(Collection<LocusFunction> locusFunctions) {
        if (locusFunctions.size() == 0) {
            return LocusFunction.INTERGENIC;
        }
        LocusFunction[] array = locusFunctions.toArray(new LocusFunction[locusFunctions.size()]);
        return this.getLocusFunction(array);
    }

    public LocusFunction getLocusFunction(LocusFunction[] locusFunctions) {
        if (locusFunctions == null || locusFunctions.length == 0) {
            return null;
        }
        int bestScore = Integer.MIN_VALUE;
        LocusFunction bestFunction = LocusFunction.INTERGENIC;
        for (LocusFunction f : locusFunctions) {
            int score = functionScores.get(f);
            if (score <= bestScore) continue;
            bestScore = score;
            bestFunction = f;
        }
        return bestFunction;
    }

    public LocusFunction[] getLocusFunctionsByBlock(AlignmentBlock b, Collection<Gene> overlappingGenes) {
        Object[] locusFunctions = new LocusFunction[b.getLength()];
        Arrays.fill(locusFunctions, 0, locusFunctions.length, LocusFunction.INTERGENIC);
        for (Gene gene : overlappingGenes) {
            for (Gene.Transcript transcript : gene) {
                transcript.assignLocusFunctionForRange(b.getReferenceStart(), (LocusFunction[])locusFunctions);
            }
        }
        return locusFunctions;
    }

    public LocusFunction[] getLocusFunctionsByInterval(Interval i, Collection<Gene> genes) {
        Object[] locusFunctions = new LocusFunction[i.length()];
        Arrays.fill(locusFunctions, 0, locusFunctions.length, LocusFunction.INTERGENIC);
        for (Gene gene : genes) {
            for (Gene.Transcript transcript : gene) {
                transcript.assignLocusFunctionForRange(i.getStart(), (LocusFunction[])locusFunctions);
            }
        }
        return locusFunctions;
    }

    Map<String, String> parseOptionalFields(String optional) {
        String[] o;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String s : o = optional.split(";")) {
            s = s.replaceAll("\"", "");
            s = s.trim();
            String[] z = s.split(" ");
            String k = z[0];
            String v = z[1];
            result.put(k, v);
        }
        return result;
    }

    public static String strandToString(boolean isPositiveStrand) {
        if (isPositiveStrand) {
            return "+";
        }
        return "-";
    }
}

