/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.biojava.nbio.core.util.SoftHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatFileCache {
    private static final Logger logger = LoggerFactory.getLogger(FlatFileCache.class);
    private static FlatFileCache me;
    private static SoftHashMap<String, byte[]> cache;

    public static FlatFileCache getInstance() {
        if (me == null) {
            me = new FlatFileCache();
        }
        return me;
    }

    private FlatFileCache() {
    }

    public static void addToCache(String key, File fileToCache) {
        try {
            int offset;
            FileInputStream is = new FileInputStream(fileToCache);
            long length = fileToCache.length();
            if (length > Integer.MAX_VALUE) {
                // empty if block
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                ((InputStream)is).close();
                throw new IOException("Could not completely read file " + fileToCache.getName());
            }
            ((InputStream)is).close();
            cache.put(key, bytes);
        }
        catch (Exception e) {
            logger.error("Error adding to cache! " + e.getMessage(), (Throwable)e);
        }
    }

    public static InputStream getInputStream(String key) {
        byte[] bytes = cache.get(key);
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public int size() {
        if (cache != null) {
            return cache.size();
        }
        return -1;
    }

    public void clear() {
        cache.clear();
    }

    public static void destroy() {
        me.clear();
        me = null;
    }

    static {
        cache = new SoftHashMap(0);
    }
}

