/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.editdistance;

import htsjdk.samtools.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.broadinstitute.dropseqrna.utils.editdistance.LevenshteinDistance;

public class LevenshteinDistanceResult {
    private static final Log log = Log.getInstance(LevenshteinDistanceResult.class);
    private int[][] distance = null;
    private String stringOne;
    private String stringTwo;
    private int deletionCost;
    private int insertionCost;
    private int substitutionCost;

    LevenshteinDistanceResult(String stringOne, String stringTwo, int[][] distance, int deletionCost, int insertionCost, int substitutionCost) {
        this.stringOne = stringOne;
        this.stringTwo = stringTwo;
        this.distance = distance;
        this.deletionCost = deletionCost;
        this.insertionCost = insertionCost;
        this.substitutionCost = substitutionCost;
    }

    public int getEditDistance() {
        int l1 = this.distance.length - 1;
        int l2 = this.distance[0].length - 1;
        return this.distance[l1][l2];
    }

    public Integer getEditDistanceIndelCorrected() {
        String[] ops = null;
        if (this.substitutionCost != 2 || this.deletionCost != 1 || this.insertionCost != 1) {
            log.info(new Object[]{"Edit distances I expected were [2/1/1] for substitution,insertion,deletion.  You had [" + this.substitutionCost + "/" + this.insertionCost + "/" + this.deletionCost + ". Recalculating with expected costs."});
            LevenshteinDistanceResult r = LevenshteinDistance.computeLevenshteinDistanceResult(this.stringOne, this.stringTwo, 1, 1, 2);
            ops = this.getOperations(r.distance);
        } else {
            ops = this.getOperations();
        }
        int count = 0;
        String[] stringArray = ops;
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String o;
            switch (o = stringArray[i]) {
                case "S": {
                    count += 2;
                    continue block12;
                }
                case "I": {
                    ++count;
                    continue block12;
                }
                case "D": {
                    ++count;
                    continue block12;
                }
                case "M": {
                    count += 0;
                }
            }
        }
        return count / 2;
    }

    public String[] getOperations() {
        return this.getOperations(this.distance);
    }

    private String[] getOperations(int[][] distance) {
        int l1 = distance.length - 1;
        int l2 = distance[0].length - 1;
        ArrayList<String> operations = new ArrayList<String>();
        int rowIndex = l1;
        int colIndex = l2;
        while (rowIndex >= 0 && colIndex >= 0 && (rowIndex != 0 || colIndex != 0)) {
            int left;
            int current = AdjacentScores.getCurrentScore(rowIndex, colIndex, distance);
            int diagonal = AdjacentScores.getDiagonalScore(rowIndex, colIndex, distance);
            int up = AdjacentScores.getUpScore(rowIndex, colIndex, distance);
            if (diagonal == current & diagonal <= (left = AdjacentScores.getLeftScore(rowIndex, colIndex, distance)) & diagonal <= up) {
                operations.add("M");
                --rowIndex;
                --colIndex;
                continue;
            }
            if (up <= diagonal & up <= current & left > up) {
                operations.add("D");
                --rowIndex;
                continue;
            }
            if (diagonal <= up && diagonal <= left && diagonal < current) {
                operations.add("S");
                --rowIndex;
                --colIndex;
                continue;
            }
            if (left >= diagonal || left > current) continue;
            operations.add("I");
            --colIndex;
        }
        Collections.reverse(operations);
        String[] result = operations.toArray(new String[operations.size()]);
        return result;
    }

    private List<String[]> getAllOperationsMultiPath() {
        int l1 = this.distance.length - 1;
        int l2 = this.distance[0].length - 1;
        Operations o = new Operations(l1, l2);
        ArrayList<Operations> searchList = new ArrayList<Operations>();
        searchList.add(o);
        HashSet<Operations> finalSet = new HashSet<Operations>();
        while (!searchList.isEmpty()) {
            ArrayList<Operations> searchListNext = new ArrayList<Operations>();
            for (Operations ol : searchList) {
                if (ol.rowIndex == 0 && ol.colIndex == 0) {
                    finalSet.add(ol);
                    continue;
                }
                List<Operations> iterResult = this.getOperations(ol);
                searchListNext.addAll(iterResult);
            }
            searchList = searchListNext;
        }
        ArrayList<String[]> done = new ArrayList<String[]>();
        return done;
    }

    List<Operations> getOperations(Operations ol) {
        Operations r;
        int min;
        ArrayList<Operations> result = new ArrayList<Operations>();
        int rowIndex = ol.rowIndex;
        int colIndex = ol.colIndex;
        int l1 = this.distance.length - 1;
        int l2 = this.distance[0].length - 1;
        int diagonal = Math.max(l1, l2);
        int up = Math.max(l1, l2);
        int left = Math.max(l1, l2);
        if (rowIndex > 0 && colIndex > 0) {
            diagonal = this.distance[rowIndex - 1][colIndex - 1];
        }
        if (rowIndex > 0) {
            up = this.distance[rowIndex - 1][colIndex];
        }
        if (colIndex > 0) {
            left = this.distance[rowIndex][colIndex - 1];
        }
        if ((min = Math.min(Math.min(diagonal, up), left)) == diagonal) {
            r = ol.clone();
            r.addOperation("M");
            r.setXY(rowIndex - 1, colIndex - 1);
            result.add(r);
        }
        if (min == up) {
            r = ol.clone();
            r.addOperation("D");
            r.setXY(rowIndex - 1, colIndex);
            result.add(r);
        }
        if (min == left) {
            r = ol.clone();
            r.addOperation("I");
            r.setXY(rowIndex, colIndex - 1);
            result.add(r);
        }
        return result;
    }

    private class Operations {
        private int rowIndex;
        private int colIndex;
        private List<String> operations;

        public Operations(int rowIndex, int colIndex) {
            this.rowIndex = rowIndex;
            this.colIndex = colIndex;
            this.operations = new ArrayList<String>();
        }

        public void setXY(int rowIndex, int colIndex) {
            this.rowIndex = rowIndex;
            this.colIndex = colIndex;
        }

        public void addOperation(String op) {
            this.operations.add(op);
        }

        public Operations clone() {
            Operations r = new Operations(this.rowIndex, this.colIndex);
            for (String o : this.operations) {
                r.addOperation(new String(o));
            }
            return r;
        }

        public String[] getOperations() {
            String[] r = new String[this.operations.size()];
            int counter = r.length - 1;
            Iterator<String> iterator = this.operations.iterator();
            while (iterator.hasNext()) {
                String s;
                r[counter] = s = iterator.next();
                --counter;
            }
            return r;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("[" + this.rowIndex + "," + this.colIndex + "]");
            String h = StringUtils.join(this.operations, (String)" ");
            b.append(h);
            return b.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Operations that = (Operations)o;
            if (this.operations.size() != that.operations.size()) {
                return false;
            }
            for (int i = 0; i < this.operations.size(); ++i) {
                if (this.operations.get(i).equals(that.operations.get(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 31;
            for (String s : this.operations) {
                result = 31 * result + s.hashCode();
            }
            return result;
        }
    }

    private static class AdjacentScores {
        private AdjacentScores() {
        }

        static int getCurrentScore(int rowIndex, int colIndex, int[][] distance) {
            return distance[rowIndex][colIndex];
        }

        static int getUpScore(int rowIndex, int colIndex, int[][] distance) {
            int up = Math.max(rowIndex, colIndex);
            if (rowIndex > 0) {
                up = distance[rowIndex - 1][colIndex];
            }
            return up;
        }

        static int getLeftScore(int rowIndex, int colIndex, int[][] distance) {
            int left = Math.max(rowIndex, colIndex);
            if (colIndex > 0) {
                left = distance[rowIndex][colIndex - 1];
            }
            return left;
        }

        static int getDiagonalScore(int rowIndex, int colIndex, int[][] distance) {
            int diagonal = Math.max(rowIndex, colIndex);
            if (rowIndex > 0 && colIndex > 0) {
                diagonal = distance[rowIndex - 1][colIndex - 1];
            }
            return diagonal;
        }

        public static enum Operation {
            M("M"),
            S("S"),
            I("I"),
            D("D");

            private final String name;

            private Operation(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }
        }
    }
}

