/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.modularfileparser;

import java.util.Arrays;
import org.broadinstitute.dropseqrna.utils.modularfileparser.Parser;

public class BEDFileParser
implements Parser {
    private String delimiter;
    private boolean firstBodyLineRetrieved = false;
    int numCols = 0;
    private String[] fullHeader = new String[]{"chrom", "chromStart", "chromEnd", "name", "score", "strand", "thickStart", "thickEnd", "itemRgb", "blockCount", "blockSizes", "blockStarts"};

    public BEDFileParser(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public String[] parseLine(String nextLine) {
        String[] result = this.parse(nextLine);
        if (!this.firstBodyLineRetrieved) {
            this.firstBodyLineRetrieved = true;
            this.numCols = result.length;
        }
        return result;
    }

    public String[] getDefaultHeader() {
        String[] result = Arrays.copyOfRange(this.fullHeader, 0, this.numCols);
        return result;
    }

    private String[] parse(String nextLine) {
        String[] result = nextLine.split(this.delimiter);
        return result;
    }
}

