/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.math;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jdistlib.math.MathFunctions;
import jdistlib.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorMath {
    public static final double[] vpow(double x, double[] e) {
        double[] v = new double[e.length];
        int i = 0;
        while (i < e.length) {
            v[i] = Math.pow(x, e[i]);
            ++i;
        }
        return v;
    }

    public static final double[] vpow(double[] x, double e) {
        double[] v = new double[x.length];
        int i = 0;
        while (i < x.length) {
            v[i] = Math.pow(x[i], e);
            ++i;
        }
        return v;
    }

    public static final double[] vpow(double[] x, double[] e) {
        if (x.length != e.length) {
            throw new RuntimeException();
        }
        double[] v = new double[e.length];
        int i = 0;
        while (i < e.length) {
            v[i] = Math.pow(x[i], e[i]);
            ++i;
        }
        return v;
    }

    public static final double[] vpow(double x, int[] e) {
        double[] v = new double[e.length];
        int i = 0;
        while (i < e.length) {
            v[i] = Math.pow(x, e[i]);
            ++i;
        }
        return v;
    }

    public static final double[] vplus(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new RuntimeException();
        }
        double[] v = new double[a.length];
        int i = 0;
        while (i < a.length) {
            v[i] = a[i] + b[i];
            ++i;
        }
        return v;
    }

    public static final double[] vplus(double a, double[] b) {
        double[] v = new double[b.length];
        int i = 0;
        while (i < b.length) {
            v[i] = a + b[i];
            ++i;
        }
        return v;
    }

    public static final double[] vplus(double[] a, double b) {
        double[] v = new double[a.length];
        int i = 0;
        while (i < a.length) {
            v[i] = a[i] + b;
            ++i;
        }
        return v;
    }

    public static final double[] vmin(double[] e) {
        double[] v = new double[e.length];
        int i = 0;
        while (i < e.length) {
            v[i] = -e[i];
            ++i;
        }
        return v;
    }

    public static final double[] vmin(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new RuntimeException();
        }
        double[] v = new double[a.length];
        int i = 0;
        while (i < a.length) {
            v[i] = a[i] - b[i];
            ++i;
        }
        return v;
    }

    public static final double[] vmin(double[] a, double b) {
        double[] v = new double[a.length];
        int i = 0;
        while (i < a.length) {
            v[i] = a[i] - b;
            ++i;
        }
        return v;
    }

    public static final double[] vmin(double a, double[] b) {
        double[] v = new double[b.length];
        int i = 0;
        while (i < b.length) {
            v[i] = a - b[i];
            ++i;
        }
        return v;
    }

    public static final double[] vtimes(double a, double[] b) {
        double[] v = new double[b.length];
        int i = 0;
        while (i < b.length) {
            v[i] = a * b[i];
            ++i;
        }
        return v;
    }

    public static final double[] vtimes(double[] a, double b) {
        double[] v = new double[a.length];
        int i = 0;
        while (i < a.length) {
            v[i] = a[i] * b;
            ++i;
        }
        return v;
    }

    public static final double[] vtimes(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new RuntimeException();
        }
        double[] v = new double[a.length];
        int i = 0;
        while (i < a.length) {
            v[i] = a[i] * b[i];
            ++i;
        }
        return v;
    }

    public static final double[] vsq(double[] a) {
        double[] v = new double[a.length];
        int i = 0;
        while (i < a.length) {
            v[i] = a[i] * a[i];
            ++i;
        }
        return v;
    }

    public static final double[] vdiv(double[] a, double b) {
        double[] v = new double[a.length];
        int i = 0;
        while (i < a.length) {
            v[i] = a[i] / b;
            ++i;
        }
        return v;
    }

    public static final double[] vdiv(double a, double[] b) {
        double[] v = new double[b.length];
        int i = 0;
        while (i < b.length) {
            v[i] = a / b[i];
            ++i;
        }
        return v;
    }

    public static final double[] vdiv(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new RuntimeException();
        }
        double[] v = new double[a.length];
        int i = 0;
        while (i < a.length) {
            v[i] = a[i] / b[i];
            ++i;
        }
        return v;
    }

    public static final double[] vcomp(double[] e) {
        double[] v = new double[e.length];
        int i = 0;
        while (i < e.length) {
            v[i] = 1.0 - e[i];
            ++i;
        }
        return v;
    }

    public static final double[] vabs(double[] e) {
        double[] v = new double[e.length];
        int i = 0;
        while (i < e.length) {
            v[i] = Math.abs(e[i]);
            ++i;
        }
        return v;
    }

    public static final double[] vexp(double[] e) {
        double[] v = new double[e.length];
        int i = 0;
        while (i < e.length) {
            v[i] = Math.exp(e[i]);
            ++i;
        }
        return v;
    }

    public static final double[] vlog(double[] e) {
        double[] v = new double[e.length];
        int i = 0;
        while (i < e.length) {
            v[i] = Math.log(e[i]);
            ++i;
        }
        return v;
    }

    public static final double[] vlog1pComps(double[] e) {
        double[] v = new double[e.length];
        int i = 0;
        while (i < e.length) {
            v[i] = Math.log1p(-e[i]);
            ++i;
        }
        return v;
    }

    public static final double[] vsignif(double[] e, int digits) {
        double[] v = new double[e.length];
        int i = 0;
        while (i < e.length) {
            v[i] = MathFunctions.signif(e[i], digits);
            ++i;
        }
        return v;
    }

    public static final double[] diff(double[] e, int lag, int order) {
        double[] v = new double[e.length];
        System.arraycopy(e, 0, v, 0, e.length);
        int vlen = v.length;
        int i = 0;
        while (i < order) {
            int j = lag;
            while (j < vlen) {
                v[j - lag] = v[j] - v[j - lag];
                ++j;
            }
            ++i;
            vlen -= lag;
        }
        e = new double[e.length - lag * order];
        System.arraycopy(v, 0, e, 0, e.length);
        return e;
    }

    public static final double[] diff(double[] e, int lag) {
        return VectorMath.diff(e, lag, 1);
    }

    public static final double[] diff(double[] e) {
        return VectorMath.diff(e, 1, 1);
    }

    public static final boolean allFinite(double[] e) {
        double[] dArray = e;
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            double _e = dArray[n2];
            if (MathFunctions.isInfinite(_e)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final boolean allLt(double[] e, double v) {
        double[] dArray = e;
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            double _e = dArray[n2];
            if (_e >= v) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final boolean allGt(double[] e, double v) {
        double[] dArray = e;
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            double _e = dArray[n2];
            if (_e <= v) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final boolean allEq(double[] e, double v) {
        double[] dArray = e;
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            double _e = dArray[n2];
            if (_e != v) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final boolean allEqual(double[] e, double[] v) {
        if (e.length != v.length) {
            throw new RuntimeException();
        }
        int n = e.length;
        int i = 0;
        while (i < n) {
            if (e[i] != v[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final double quantile(double[] sortedData, double quantile) {
        double index = (double)(sortedData.length - 1) * quantile;
        int lo = (int)Math.floor(index);
        int hi = (int)Math.ceil(index);
        if (lo < 0) {
            return 0.0;
        }
        double h = index - (double)lo;
        double lowerQ = sortedData[lo];
        double result = h == 0.0 ? lowerQ : (1.0 - h) * lowerQ + h * sortedData[hi];
        return result;
    }

    public static final double[] quantile(double[] sortedData, double[] quantile) {
        double[] v = new double[quantile.length];
        int i = 0;
        while (i < quantile.length) {
            v[i] = VectorMath.quantile(sortedData, quantile[i]);
            ++i;
        }
        return v;
    }

    public static final double quantile0(double[] e, double quantile) {
        int n = e.length;
        double[] r = new double[n];
        System.arraycopy(e, 0, r, 0, n);
        Utilities.sort(r);
        return VectorMath.quantile(r, quantile);
    }

    public static final double[] quantile0(double[] e, double[] quantile) {
        int n = e.length;
        double[] r = new double[n];
        System.arraycopy(e, 0, r, 0, n);
        Utilities.sort(r);
        double[] v = new double[quantile.length];
        int i = 0;
        while (i < quantile.length) {
            v[i] = VectorMath.quantile(r, quantile[i]);
            ++i;
        }
        return v;
    }

    public static final double mean(double[] e) {
        double sum = 0.0;
        int n = e.length;
        int i = 0;
        while (i < n) {
            sum += e[i] / (double)n;
            ++i;
        }
        return sum;
    }

    public static final double[] summary(double[] e) {
        int n = e.length;
        double[] v = new double[e.length];
        System.arraycopy(e, 0, v, 0, n);
        Utilities.sort(v);
        double[] s = VectorMath.quantile(v, new double[]{0.25, 0.5, 0.75});
        return new double[]{v[0], s[0], s[1], VectorMath.mean(v), s[2], v[n - 1]};
    }

    public static final double median(double[] e) {
        int n = e.length;
        double[] v = new double[e.length];
        System.arraycopy(e, 0, v, 0, n);
        Utilities.sort(v);
        return VectorMath.quantile(v, 0.5);
    }

    public static final double sd(double[] e) {
        double sum = 0.0;
        double sumsq = 0.0;
        int n = e.length;
        int nm1 = n - 1;
        int i = 0;
        while (i < n) {
            double v = e[i];
            sum += v / (double)n;
            sumsq += v * v / (double)nm1;
            ++i;
        }
        return Math.sqrt(sumsq - sum / (double)nm1 * sum * (double)n);
    }

    public static final double var(double[] e) {
        double sum = 0.0;
        double sumsq = 0.0;
        int n = e.length;
        int nm1 = n - 1;
        int i = 0;
        while (i < n) {
            double v = e[i];
            sum += v / (double)n;
            sumsq += v * v / (double)nm1;
            ++i;
        }
        return sumsq - sum / (double)nm1 * sum * (double)n;
    }

    public static final double sum(double[] e) {
        double sum = 0.0;
        int n = e.length;
        int i = 0;
        while (i < n) {
            sum += e[i];
            ++i;
        }
        return sum;
    }

    public static final double sum_kahan(double[] e) {
        double sum = e[0];
        double c = 0.0;
        int n = e.length;
        int i = 1;
        while (i < n) {
            double y = e[i] - c;
            double t = sum + y;
            c = t - sum - y;
            sum = t;
            ++i;
        }
        return sum - c;
    }

    public static final double sum(Map<String, Integer> e) {
        double sum = 0.0;
        for (int v : e.values()) {
            sum += (double)v;
        }
        return sum;
    }

    public static final double[] standardize(double[] x) {
        double sum = 0.0;
        double sumsq = 0.0;
        int n = x.length;
        int nm1 = n - 1;
        double[] new_x = new double[n];
        int i = 0;
        while (i < n) {
            double v = x[i];
            sum += v / (double)n;
            sumsq += v * v / (double)nm1;
            ++i;
        }
        sumsq = Math.sqrt(sumsq - sum / (double)nm1 * sum * (double)n);
        i = 0;
        while (i < n) {
            new_x[i] = (x[i] - sum) / sumsq;
            ++i;
        }
        return new_x;
    }

    public static final Map<String, Integer> table(double[] e) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        double[] dArray = e;
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            String estr;
            double _e = dArray[n2];
            Integer i = (Integer)map.get(estr = String.valueOf(_e));
            map.put(estr, 1 + (i == null ? 0 : i));
            ++n2;
        }
        return map;
    }

    public static final <T> Map<String, Integer> table(T[] e) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        T[] TArray = e;
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            String estr;
            T _e = TArray[n2];
            Integer i = (Integer)map.get(estr = String.valueOf(_e));
            map.put(estr, 1 + (i == null ? 0 : i));
            ++n2;
        }
        return map;
    }

    public static final double[] as_numeric(Collection<String> ll) {
        int n = ll.size();
        int i = 0;
        double[] v = new double[n];
        for (String str : ll) {
            v[i] = Double.valueOf(str);
            ++i;
        }
        return v;
    }

    public static final double[] cumsum(double[] e) {
        int n = e.length;
        double[] r = new double[n];
        r[0] = e[0];
        int i = 1;
        while (i < n) {
            r[i] = r[i - 1] + e[i];
            ++i;
        }
        return r;
    }

    public static final int[] cumsum(int[] e) {
        int n = e.length;
        int[] r = new int[n];
        r[0] = e[0];
        int i = 1;
        while (i < n) {
            r[i] = r[i - 1] + e[i];
            ++i;
        }
        return r;
    }

    public static final double max(double[] e) {
        int n = e.length;
        double mx = e[0];
        int i = 1;
        while (i < n) {
            if (e[i] > mx) {
                mx = e[i];
            }
            ++i;
        }
        return mx;
    }

    public static final double min(double[] e) {
        int n = e.length;
        double mn = e[0];
        int i = 1;
        while (i < n) {
            if (e[i] < mn) {
                mn = e[i];
            }
            ++i;
        }
        return mn;
    }

    public static final int which_max(double[] e) {
        int n = e.length;
        int which = 0;
        double mx = e[0];
        int i = 1;
        while (i < n) {
            if (e[i] > mx) {
                mx = e[i];
                which = i;
            }
            ++i;
        }
        return which;
    }

    public static final int which_min(double[] e) {
        int n = e.length;
        int which = 0;
        double mn = e[0];
        int i = 1;
        while (i < n) {
            if (e[i] < mn) {
                mn = e[i];
                which = i;
            }
            ++i;
        }
        return which;
    }

    public static final double[] pmax(double[] a, double[] b) {
        int n = a.length;
        if (n != b.length) {
            throw new RuntimeException();
        }
        double[] mx = new double[n];
        int i = 0;
        while (i < n) {
            mx[i] = a[i] > b[i] ? a[i] : b[i];
            ++i;
        }
        return mx;
    }

    public static final double[] pmin(double[] a, double[] b) {
        int n = a.length;
        if (n != b.length) {
            throw new RuntimeException();
        }
        double[] mx = new double[n];
        int i = 0;
        while (i < n) {
            mx[i] = a[i] < b[i] ? a[i] : b[i];
            ++i;
        }
        return mx;
    }

    public static final double[] range(double[] e) {
        int n = e.length;
        double mx = e[0];
        double mn = e[0];
        int i = 1;
        while (i < n) {
            if (e[i] > mx) {
                mx = e[i];
            } else if (e[i] < mn) {
                mn = e[i];
            }
            ++i;
        }
        return new double[]{mn, mx};
    }

    public static final double iqr(double[] e) {
        double[] v = VectorMath.quantile0(e, new double[]{0.75, 0.25});
        return v[0] - v[1];
    }

    public static final boolean isEqual(double a, double b, double tol) {
        return Double.isNaN(a) && Double.isNaN(b) || a == b || Math.abs(a - b) <= tol;
    }

    public static final boolean isEqualScaled(double a, double b, double tol) {
        return Double.isNaN(a) && Double.isNaN(b) || a == b || Math.abs(a - b) / (Double.isNaN(a) ? 0.0 : a) <= tol;
    }

    public static final boolean allEqual(double[] a, double[] b, double tol) {
        int n = a.length;
        if (n != b.length) {
            throw new RuntimeException();
        }
        int i = 0;
        while (i < n) {
            if (!VectorMath.isEqual(a[i], b[i], tol)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean allEqualScaled(double[] a, double[] b, double tol) {
        int n = a.length;
        if (n != b.length) {
            throw new RuntimeException();
        }
        int i = 0;
        while (i < n) {
            if (!VectorMath.isEqualScaled(a[i], b[i], tol)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isSorted(double[] a, boolean ascending) {
        int n = a.length;
        if (ascending) {
            int i = 1;
            while (i < n) {
                if (a[i - 1] > a[i]) {
                    return false;
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i < n) {
                if (a[i - 1] < a[i]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

