/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.metrics;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.broadinstitute.dropseqrna.cmdline.DropSeq;
import org.broadinstitute.dropseqrna.utils.SamHeaderUtil;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;

@CommandLineProgramProperties(usage="", usageShort="", programGroup=DropSeq.class)
public class TagReadWithInterval
extends CommandLineProgram {
    private final Log log = Log.getInstance(TagReadWithInterval.class);
    @Option(shortName="I", doc="The input SAM or BAM file to analyze.  Must be coordinate sorted.")
    public File INPUT;
    @Option(doc="The list of Loci to gather start/end read positons for.  This file is in Interval format - tab seperated with fields: chr start end strand name")
    public File LOCI;
    @Option(shortName="O", doc="The output BAM, written with new interval tag")
    public File OUTPUT;
    @Option(doc="The tag name to use.  Defaults to ZI.  If a read previously had a tag and now does not, the tag is removed.", optional=true)
    public String TAG = "ZI";

    public static void main(String[] args) {
        System.exit(new TagReadWithInterval().instanceMain(args));
    }

    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SamReader inputSam = SamReaderFactory.makeDefault().open(this.INPUT);
        SAMFileHeader header = inputSam.getFileHeader();
        header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        SamHeaderUtil.addPgRecord(header, this);
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(header, true, this.OUTPUT);
        IntervalList loci = IntervalList.fromFile((File)this.LOCI);
        OverlapDetector<Interval> od = this.getOverlapDetector(loci);
        ProgressLogger processLogger = new ProgressLogger(this.log);
        for (SAMRecord record : inputSam) {
            processLogger.record(record);
            if (!record.getReadUnmappedFlag()) {
                record = this.tagRead(record, od);
            } else {
                record.setAttribute(this.TAG, null);
            }
            writer.addAlignment(record);
        }
        CloserUtil.close((Object)inputSam);
        writer.close();
        return 0;
    }

    private SAMRecord tagRead(SAMRecord r, OverlapDetector<Interval> od) {
        HashSet<Interval> intervals = new HashSet<Interval>();
        List blocks = r.getAlignmentBlocks();
        for (AlignmentBlock b : blocks) {
            int refStart = b.getReferenceStart();
            int refEnd = refStart + b.getLength() - 1;
            Interval v = new Interval(r.getReferenceName(), refStart, refEnd);
            Set blockResult = od.getOverlaps((Locatable)v);
            intervals.addAll(blockResult);
        }
        String tagName = this.getIntervalName(intervals);
        if (tagName != null) {
            r.setAttribute(this.TAG, (Object)tagName);
        } else {
            r.setAttribute(this.TAG, null);
        }
        return r;
    }

    private String getIntervalName(Collection<Interval> intervals) {
        if (intervals.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        Iterator<Interval> iter = intervals.iterator();
        result.append(iter.next().getName());
        while (iter.hasNext()) {
            result.append(",");
            result.append(iter.next().getName());
        }
        return result.toString();
    }

    OverlapDetector<Interval> getOverlapDetector(IntervalList loci) {
        OverlapDetector od = new OverlapDetector(0, 0);
        for (Interval i : loci.getIntervals()) {
            od.addLhs((Object)i, (Locatable)i);
        }
        return od;
    }
}

