/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.readtrimming;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import org.broadinstitute.dropseqrna.cmdline.DropSeq;
import org.broadinstitute.dropseqrna.readtrimming.AdapterDescriptor;
import org.broadinstitute.dropseqrna.readtrimming.PolyAFinder;
import org.broadinstitute.dropseqrna.readtrimming.PolyAWithAdapterFinder;
import org.broadinstitute.dropseqrna.readtrimming.SimplePolyAFinder;
import org.broadinstitute.dropseqrna.utils.SamHeaderUtil;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;

@CommandLineProgramProperties(usage="", usageShort="", programGroup=DropSeq.class)
public class PolyATrimmer
extends CommandLineProgram {
    private final Log log = Log.getInstance(PolyATrimmer.class);
    private static final int NO_POLY_A_ADAPTER_DEBUG_THRESHOLD = 6;
    @Option(shortName="I", doc="The input SAM or BAM file to analyze.")
    public File INPUT;
    @Option(shortName="O", doc="The output BAM file")
    public File OUTPUT;
    @Option(doc="The output summary statistics", optional=true)
    public File OUTPUT_SUMMARY;
    @Option(shortName="NEW")
    public boolean USE_NEW_TRIMMER = false;
    @Option(doc="How many mismatches are acceptable in the sequence (old trim algo).")
    public Integer MISMATCHES = 0;
    @Option(doc="How many bases of polyA qualifies as a run of A's (old trim algo).")
    public Integer NUM_BASES = 6;
    @Option(doc="The tag to set for trimmed reads.  This tags the first base to exclude in the read.  37 would mean to retain the first 36 bases.")
    public String TRIM_TAG = "ZP";
    @Option(doc="Symbolic & literal specification of adapter sequence.  This is a combination of fixed bases to match,  and references to SAMRecord tag values.  E.g. '~XM^XCACGT' means 'RCed value of XM tag' + 'value of XC tag' + 'ACGT'. Ideally this is at least as long as the read (new trim algo)")
    public AdapterDescriptor ADAPTER = new AdapterDescriptor(AdapterDescriptor.DEFAULT_ADAPTER);
    @Option(doc="Fraction of bases that can mismatch when looking for adapter match  (new trim algo)")
    public double MAX_ADAPTER_ERROR_RATE = 0.1;
    @Option(doc="Minimum number of bases for adapter match (new trim algo)")
    public int MIN_ADAPTER_MATCH = 4;
    @Option(doc="Minimum length of a poly A run, except when start of end of read intervenes (new trim algo)")
    public int MIN_POLY_A_LENGTH = 20;
    @Option(doc="Minimum length of poly A run at end of read, if there is no adapter match (new trim algo)")
    public int MIN_POLY_A_LENGTH_NO_ADAPTER_MATCH = 6;
    @Option(doc="If adapter match is at end of read, with fewer than this many bases matching the read, and not enough poly A is found preceding it, then ignore the adapter match and try again from the end of the read (new trim algo)")
    public int DUBIOUS_ADAPTER_MATCH_LENGTH = 6;
    @Option(doc="When looking for poly A, allow this fraction of bases not to be A (new trim algo)")
    public double MAX_POLY_A_ERROR_RATE = 0.1;
    private Integer readsTrimmed = 0;
    private int readsCompletelyTrimmed = 0;
    private final Histogram<Integer> numBasesTrimmed = new Histogram();
    int numDiffs = 0;
    int numOldDidntClip = 0;
    int numNewDidntClip = 0;

    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        ProgressLogger progress = new ProgressLogger(this.log);
        SamReader bamReader = SamReaderFactory.makeDefault().open(this.INPUT);
        SAMFileHeader header = bamReader.getFileHeader();
        SamHeaderUtil.addPgRecord(header, this);
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(header, true, this.OUTPUT);
        SimplePolyAFinder simplePolyAFinder = new SimplePolyAFinder(this.NUM_BASES, this.MISMATCHES);
        PolyAWithAdapterFinder polyAWithAdapterFinder = new PolyAWithAdapterFinder(this.ADAPTER, this.MIN_ADAPTER_MATCH, this.MAX_ADAPTER_ERROR_RATE, this.MIN_POLY_A_LENGTH, this.MIN_POLY_A_LENGTH_NO_ADAPTER_MATCH, this.MAX_POLY_A_ERROR_RATE, this.DUBIOUS_ADAPTER_MATCH_LENGTH);
        PolyAFinder polyAFinder = this.USE_NEW_TRIMMER ? polyAWithAdapterFinder : simplePolyAFinder;
        for (SAMRecord r : bamReader) {
            PolyAFinder.PolyARun polyARun = polyAFinder.getPolyAStart(r);
            int polyAStart = polyARun.startPos;
            if (Log.isEnabled((Log.LogLevel)Log.LogLevel.DEBUG)) {
                PolyAFinder.PolyARun simple;
                PolyAFinder.PolyARun withAdapter;
                if (this.USE_NEW_TRIMMER) {
                    withAdapter = polyARun;
                    simple = simplePolyAFinder.getPolyAStart(r);
                } else {
                    simple = polyARun;
                    withAdapter = polyAWithAdapterFinder.getPolyAStart(r);
                }
                this.logTrimDifference(simple, withAdapter, r);
            }
            this.hardClipPolyAFromRecord(r, polyAStart);
            writer.addAlignment(r);
            progress.record(r);
        }
        CloserUtil.close((Object)bamReader);
        writer.close();
        this.log.info(new Object[]{"Number of reads trimmed: ", this.readsTrimmed});
        this.log.info(new Object[]{"Number of reads completely trimmed: ", this.readsCompletelyTrimmed});
        this.log.debug(new Object[]{String.format("differences: %d; old didn't clip: %d; new didn't clip: %d", this.numDiffs, this.numOldDidntClip, this.numNewDidntClip)});
        if (this.OUTPUT_SUMMARY != null) {
            this.writeSummary(this.numBasesTrimmed);
        }
        return 0;
    }

    private void logTrimDifference(PolyAFinder.PolyARun simpleRun, PolyAFinder.PolyARun withAdapterRun, SAMRecord r) {
        String newAdapter = this.ADAPTER.getAdapterSequence(r);
        if (simpleRun.startPos != withAdapterRun.startPos) {
            ++this.numDiffs;
            if (withAdapterRun.isNoMatch()) {
                ++this.numNewDidntClip;
            } else if (simpleRun.isNoMatch()) {
                ++this.numOldDidntClip;
            }
            System.out.println("\nREADNAME: " + r.getReadName());
            String readString = r.getReadString();
            System.out.println("READ:" + readString);
            System.out.print("OLD: ");
            if (simpleRun.isNoMatch()) {
                System.out.println("NOCLIP");
            } else {
                this.indent(System.out, simpleRun.startPos);
                System.out.print("^");
                this.indent(System.out, simpleRun.length - 1);
                System.out.println(readString.substring(simpleRun.endPos() + 1));
            }
            if (withAdapterRun.isNoMatch()) {
                System.out.print("XEW: ");
                this.indent(System.out, simpleRun.startPos + simpleRun.length);
                System.out.println(newAdapter);
                if (withAdapterRun.adapterStartPos != -1 && readString.length() - withAdapterRun.adapterStartPos >= 6) {
                    System.out.print("NPA: ");
                    this.indent(System.out, withAdapterRun.adapterStartPos);
                    System.out.println(newAdapter);
                }
            } else {
                System.out.print("NEW:");
                if (withAdapterRun.length > 0) {
                    System.out.print(" ");
                }
                this.indent(System.out, withAdapterRun.startPos);
                System.out.print("^");
                this.indent(System.out, withAdapterRun.length - 1);
                System.out.println(newAdapter);
                int positionAfterNewAdapter = withAdapterRun.endPos() + 1 + newAdapter.length();
                if (positionAfterNewAdapter < r.getReadLength()) {
                    System.out.print("ANA: ");
                    this.indent(System.out, positionAfterNewAdapter);
                    System.out.println(readString.substring(positionAfterNewAdapter));
                }
            }
        }
    }

    private void indent(PrintStream out, int amount) {
        for (int i = 0; i < amount; ++i) {
            out.print(" ");
        }
    }

    void hardClipPolyAFromRecord(SAMRecord r, int polyAStart) {
        int readLength = r.getReadLength();
        if (polyAStart == -1) {
            return;
        }
        PolyATrimmer polyATrimmer = this;
        Integer n = polyATrimmer.readsTrimmed;
        Integer n2 = polyATrimmer.readsTrimmed = Integer.valueOf(polyATrimmer.readsTrimmed + 1);
        this.numBasesTrimmed.increment((Comparable)Integer.valueOf(polyAStart));
        if (polyAStart == 0) {
            byte[] value = new byte[readLength];
            Arrays.fill(value, (byte)3);
            r.setBaseQualities(value);
            ++this.readsCompletelyTrimmed;
            return;
        }
        byte[] read = r.getReadBases();
        read = Arrays.copyOfRange(read, 0, polyAStart);
        r.setReadBases(read);
        byte[] quality = r.getBaseQualities();
        quality = Arrays.copyOfRange(quality, 0, polyAStart);
        r.setBaseQualities(quality);
        r.setAttribute(this.TRIM_TAG, (Object)(polyAStart + 1));
    }

    private void writeSummary(Histogram<Integer> h) {
        MetricsFile mf = new MetricsFile();
        mf.addHistogram(h);
        TrimMetric tm = new TrimMetric(h);
        mf.addMetric((MetricBase)tm);
        mf.write(this.OUTPUT_SUMMARY);
    }

    public static void main(String[] args) {
        System.exit(new PolyATrimmer().instanceMain(args));
    }

    public class TrimMetric
    extends MetricBase {
        public Double mean;
        public Double stdev;

        public TrimMetric(Histogram<Integer> h) {
            this.mean = h.getMean();
            this.stdev = h.getStandardDeviation();
        }

        public Double getMean() {
            return this.mean;
        }

        public Double getStdev() {
            return this.stdev;
        }
    }
}

