/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.dropseqrna.utils.StringTagComparator;
import org.broadinstitute.dropseqrna.utils.readiterators.SamRecordSortingIteratorFactory;

public class CustomBAMIterators {
    private static final Log log = Log.getInstance(CustomBAMIterators.class);
    public static final int MAX_RECORDS_IN_RAM = 500000;

    public static CloseableIterator<SAMRecord> getReadsInTagOrder(SamReader reader, String primaryTag) {
        SAMSequenceDictionary dict = reader.getFileHeader().getSequenceDictionary();
        List programs = reader.getFileHeader().getProgramRecords();
        SAMFileHeader writerHeader = new SAMFileHeader();
        writerHeader.setSortOrder(SAMFileHeader.SortOrder.queryname);
        writerHeader.setSequenceDictionary(dict);
        for (SAMProgramRecord spr : programs) {
            writerHeader.addProgramRecord(spr);
        }
        ProgressLogger progressLogger = new ProgressLogger(log, 1000000);
        log.info(new Object[]{"Reading in records for TAG name sorting"});
        CloseableIterator<SAMRecord> result = SamRecordSortingIteratorFactory.create(writerHeader, (Iterator<SAMRecord>)reader.iterator(), new StringTagComparator(primaryTag), progressLogger);
        log.info(new Object[]{"Sorting finished."});
        return result;
    }

    public static CloseableIterator<SAMRecord> getQuerynameSortedRecords(SamReader reader) {
        if (reader.getFileHeader().getSortOrder().equals((Object)SAMFileHeader.SortOrder.queryname)) {
            return reader.iterator();
        }
        log.info(new Object[]{"Input SAM/BAM not in queryname order, sorting..."});
        SAMSequenceDictionary dict = reader.getFileHeader().getSequenceDictionary();
        List programs = reader.getFileHeader().getProgramRecords();
        SAMFileHeader writerHeader = new SAMFileHeader();
        writerHeader.setSortOrder(SAMFileHeader.SortOrder.queryname);
        writerHeader.setSequenceDictionary(dict);
        for (SAMProgramRecord spr : programs) {
            writerHeader.addProgramRecord(spr);
        }
        log.info(new Object[]{"Reading in records for query name sorting"});
        ProgressLogger progressLogger = new ProgressLogger(log, 1000000, "Sorting reads in query name order");
        CloseableIterator<SAMRecord> result = SamRecordSortingIteratorFactory.create(writerHeader, (Iterator<SAMRecord>)reader.iterator(), (Comparator<SAMRecord>)new SAMRecordQueryNameComparator(), progressLogger);
        log.info(new Object[]{"Sorting finished."});
        return result;
    }
}

