/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ObjectCounter<T extends Comparable<T>> {
    private Map<T, Integer> countMap = new HashMap<T, Integer>();

    public ObjectCounter() {
    }

    public ObjectCounter(ObjectCounter<T> counter) {
        this();
        for (Comparable key : counter.getKeys()) {
            this.countMap.put(key, counter.getCountForKey(key));
        }
    }

    public boolean hasKey(T object) {
        return this.countMap.containsKey(object);
    }

    public void increment(T object) {
        this.incrementByCount(object, 1);
    }

    public void increment(ObjectCounter<T> object) {
        for (Comparable key : object.getKeys()) {
            Integer count = object.getCountForKey(key);
            this.incrementByCount(key, count);
        }
    }

    public void clear() {
        this.countMap.clear();
    }

    public void incrementByCount(T object, int size) {
        Integer count = this.countMap.get(object);
        if (count == null) {
            this.countMap.put(object, size);
        } else {
            count = count + size;
            this.countMap.put(object, count);
        }
    }

    public void setCount(T object, int count) {
        this.countMap.put(object, count);
    }

    public void remove(T object) {
        this.countMap.remove(object);
    }

    public Collection<T> getKeys() {
        return this.countMap.keySet();
    }

    public int getSize() {
        return this.countMap.size();
    }

    public int getCountForKey(T key) {
        Integer count = this.countMap.get(key);
        if (count == null) {
            return 0;
        }
        return count;
    }

    public Collection<Integer> getCounts() {
        return this.countMap.values();
    }

    public int getTotalCount() {
        int result = 0;
        for (Comparable key : this.countMap.keySet()) {
            int t = this.getCountForKey(key);
            result += t;
        }
        return result;
    }

    public int getNumberOfSize(int size) {
        int result = 0;
        for (Comparable key : this.countMap.keySet()) {
            int t = this.getCountForKey(key);
            if (t != size) continue;
            ++result;
        }
        return result;
    }

    public T getMode() {
        Comparable max = null;
        int maxCount = 0;
        for (Comparable key : this.getKeys()) {
            int count = this.getCountForKey(key);
            if (count <= maxCount) continue;
            max = key;
            maxCount = count;
        }
        return (T)max;
    }

    public List<T> getKeysOrderedByCount(boolean decreasing) {
        Map<Integer, List<T>> reversed = this.getReverseMapping();
        ArrayList<Integer> counts = new ArrayList<Integer>(reversed.keySet());
        Collections.sort(counts);
        if (decreasing) {
            Collections.reverse(counts);
        }
        ArrayList<T> keys = new ArrayList<T>();
        Iterator iterator = counts.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            List<T> t = reversed.get(i);
            Collections.sort(t);
            keys.addAll(t);
        }
        return keys;
    }

    public Map<Integer, List<T>> getReverseMapping() {
        HashMap<Integer, List<T>> result = new HashMap<Integer, List<T>>(this.countMap.size());
        for (Comparable key : this.countMap.keySet()) {
            Integer v = this.getCountForKey(key);
            ArrayList<Comparable> l = (ArrayList<Comparable>)result.get(v);
            if (l == null) {
                l = new ArrayList<Comparable>();
            }
            l.add(key);
            result.put(v, l);
        }
        return result;
    }

    public void filterByMinCount(int count) {
        HashMap<T, Integer> result = new HashMap<T, Integer>();
        for (Comparable key : this.countMap.keySet()) {
            Integer value = this.countMap.get(key);
            if (value < count) continue;
            result.put(key, value);
        }
        this.countMap = result;
    }

    public String toString() {
        return this.countMap.toString();
    }
}

