/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.readiterators;

import htsjdk.samtools.SAMRecord;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.broadinstitute.dropseqrna.barnyard.Utils;
import org.broadinstitute.dropseqrna.utils.CountChangingIteratorWrapper;

public class UmiIteratorWrapper
extends CountChangingIteratorWrapper<SAMRecord> {
    private String cellBarcodeTag;
    private Set<String> cellBarcodeList;
    private String geneExonTag;
    private String strandTag;
    private int readMQ;
    private boolean assignReadsToAllGenes;
    private boolean useStrandInfo;
    private Random rand = new Random();

    public UmiIteratorWrapper(Iterator<SAMRecord> underlyingIterator, String cellBarcodeTag, Collection<String> cellBarcodeList, String geneExonTag, String strandTag, int readMQ, boolean assignReadsToAllGenes, boolean useStrandInfo) {
        super(underlyingIterator);
        this.cellBarcodeTag = cellBarcodeTag;
        this.cellBarcodeList = new HashSet<String>(cellBarcodeList);
        this.geneExonTag = geneExonTag;
        this.strandTag = strandTag;
        this.readMQ = readMQ;
        this.assignReadsToAllGenes = assignReadsToAllGenes;
        this.useStrandInfo = useStrandInfo;
    }

    @Override
    protected void processRecord(SAMRecord r) {
        String cellBC = r.getStringAttribute(this.cellBarcodeTag);
        String geneList = r.getStringAttribute(this.geneExonTag);
        if (this.cellBarcodeList != null && !this.cellBarcodeList.contains(cellBC)) {
            return;
        }
        if (r.isSecondaryOrSupplementary() || r.getMappingQuality() < this.readMQ || geneList == null) {
            return;
        }
        String[] genes = geneList.split(",");
        String[] strands = null;
        if (this.useStrandInfo) {
            strands = r.getStringAttribute(this.strandTag).split(",");
            if (strands == null) {
                throw new IllegalStateException("For read [" + r.getReadName() + "] gene tags found [" + geneList + " but no strand info set when strand use was requested.");
            }
            if (genes.length != strands.length) {
                throw new IllegalStateException("For read [" + r.getReadName() + "] gene tags found [" + geneList + "] but a different number of strand tags were set [" + r.getStringAttribute(this.strandTag) + "]");
            }
        }
        if (this.assignReadsToAllGenes) {
            for (int i = 0; i < genes.length; ++i) {
                String g = genes[i];
                SAMRecord rr = Utils.getClone(r);
                rr.setAttribute(this.geneExonTag, (Object)g);
                if (this.useStrandInfo) {
                    String geneStrand = strands[i];
                    String readStrandString = Utils.strandToString(!r.getReadNegativeStrandFlag());
                    if (!geneStrand.equals(readStrandString)) continue;
                    this.queueRecordForOutput(rr);
                    continue;
                }
                this.queueRecordForOutput(rr);
            }
        } else {
            int randomNum = this.rand.nextInt(genes.length - 1 + 1);
            String g = genes[randomNum];
            r.setAttribute(this.geneExonTag, (Object)g);
            this.queueRecordForOutput(r);
        }
    }
}

