/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.barnyard;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.dropseqrna.barnyard.GatherMolecularBarcodeDistributionByGene;
import org.broadinstitute.dropseqrna.barnyard.ParseBarcodeFile;
import org.broadinstitute.dropseqrna.metrics.BAMTagHistogram;
import org.broadinstitute.dropseqrna.metrics.BAMTagofTagCounts;
import org.broadinstitute.dropseqrna.metrics.TagOfTagResults;
import org.broadinstitute.dropseqrna.utils.ObjectCounter;

public class BarcodeListRetrieval {
    private static Log log = Log.getInstance(BarcodeListRetrieval.class);
    private ProgressLogger progress = new ProgressLogger(log, 1000000);

    public List<String> getCellBarcodes(File bamFile, String cellBarcodeTag, String molecularBarcodeTag, String geneExonBarcodeTag, String strandTag, File cellBCFile, Integer readQuality, Integer minNumTranscriptsPerCell, Integer minNumNumGenesPerCell, Integer minNumReadsPerCell, Integer numCoreBarcodes, Integer editDistance, Integer minNumReadsMolBarcode, boolean useStrandInfo) {
        List<Object> cellBarcodes = new ArrayList();
        if (cellBCFile != null) {
            cellBarcodes = ParseBarcodeFile.readCellBarcodeFile(cellBCFile);
            log.info(new Object[]{"Found " + cellBarcodes.size() + " cell barcodes in file"});
            return cellBarcodes;
        }
        if (minNumNumGenesPerCell != null) {
            log.info(new Object[]{"Looking for cell barcodes that have at least " + minNumNumGenesPerCell + " genes"});
            cellBarcodes = this.getListCellBarcodesByGeneCount(bamFile, cellBarcodeTag, geneExonBarcodeTag, readQuality, minNumNumGenesPerCell);
            return cellBarcodes;
        }
        if (minNumTranscriptsPerCell != null) {
            log.info(new Object[]{"Looking for cell barcodes that have at least " + minNumTranscriptsPerCell + " transcripts"});
            cellBarcodes = this.getListCellBarcodesByTranscriptCount(bamFile, cellBarcodeTag, molecularBarcodeTag, geneExonBarcodeTag, strandTag, readQuality, minNumTranscriptsPerCell, editDistance, minNumReadsMolBarcode, useStrandInfo);
        }
        if (minNumReadsPerCell != null || numCoreBarcodes != null) {
            cellBarcodes = this.getListCellBarcodesByReadCount(bamFile, cellBarcodeTag, (int)readQuality, minNumReadsPerCell, numCoreBarcodes);
            return cellBarcodes;
        }
        return cellBarcodes;
    }

    public boolean validateGetCellBarcodeListParams(File bamFile, String cellBarcodeTag, String molecularBarcodeTag, String geneBarcodeTag, String exonTag, File cellBCFile, Integer readQuality, Integer minNumTranscriptsPerCell, Integer minNumNumGenesPerCell, Integer minNumReadsPerCell, Integer numCoreBarcodes) {
        IOUtil.assertFileIsReadable((File)bamFile);
        if (cellBarcodeTag == null) {
            log.error(new Object[]{"cell barcode argument must be set"});
            return false;
        }
        if (molecularBarcodeTag == null) {
            log.error(new Object[]{"moleclar barcode argument must be set"});
            return false;
        }
        if (cellBCFile != null) {
            IOUtil.assertFileIsReadable((File)bamFile);
            return true;
        }
        if (readQuality == null) {
            log.error(new Object[]{"Read Quality must be set"});
            return false;
        }
        if (minNumNumGenesPerCell != null && geneBarcodeTag == null) {
            log.error(new Object[]{"Gene barcode tag argument must be set to filter by #genes"});
            return false;
        }
        if (minNumTranscriptsPerCell != null) {
            if (geneBarcodeTag == null) {
                log.error(new Object[]{"Gene barcode tag argument must be set to filter by #transcripts"});
                return false;
            }
            if (exonTag == null) {
                log.error(new Object[]{"Exon barcode tag argument must be set to filter by #transcripts"});
                return false;
            }
        }
        return true;
    }

    public List<String> getListCellBarcodesByReadCount(File input, String cellBarcodeTag, int readQuality, Integer minNumReads, Integer numReadsCore) {
        return this.getListCellBarcodesByReadCount((CloseableIterator<SAMRecord>)SamReaderFactory.makeDefault().enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.EAGERLY_DECODE}).open(input).iterator(), cellBarcodeTag, readQuality, minNumReads, numReadsCore);
    }

    public List<String> getListCellBarcodesByReadCount(CloseableIterator<SAMRecord> input, String cellBarcodeTag, int readQuality, Integer minNumReads, Integer numReadsCore) {
        BAMTagHistogram bth = new BAMTagHistogram();
        ObjectCounter<String> cellBarcodes = bth.getBamTagCounts((Iterator<SAMRecord>)input, cellBarcodeTag, readQuality, false);
        List<String> result = null;
        if (minNumReads != null) {
            result = this.getCoreBarcodesByReadCount(cellBarcodes, minNumReads);
        }
        if (numReadsCore != null) {
            result = this.getTopCoreBarcodesByReadCount(cellBarcodes, numReadsCore);
        }
        CloserUtil.close(input);
        return result;
    }

    public List<String> getListCellBarcodesByGeneCount(File input, String cellBarcodeTag, String geneExonTag, int readQuality, int minNumGenes) {
        ArrayList<String> result = new ArrayList<String>();
        BAMTagofTagCounts tot = new BAMTagofTagCounts();
        TagOfTagResults<String, String> results = tot.getResults(input, cellBarcodeTag, geneExonTag, false, readQuality);
        for (String key : results.getKeys()) {
            int count = results.getCount(key);
            if (count < minNumGenes) continue;
            result.add(key);
        }
        return result;
    }

    public List<String> getListCellBarcodesByTranscriptCount(File input, String cellBarcodeTag, String molecularBarcodeTag, String geneExonTag, String strandTag, int readQuality, int editDistance, int minNumReadsMolBarcode, int minNumTranscripts, boolean useStrandInfo) {
        ArrayList<String> result = new ArrayList<String>();
        GatherMolecularBarcodeDistributionByGene g = new GatherMolecularBarcodeDistributionByGene();
        ObjectCounter<String> numTranscripts = g.getNumTranscriptsPerCell(input, cellBarcodeTag, molecularBarcodeTag, geneExonTag, strandTag, readQuality, editDistance, minNumReadsMolBarcode, useStrandInfo);
        for (String key : numTranscripts.getKeys()) {
            int count = numTranscripts.getCountForKey(key);
            if (count < minNumTranscripts) continue;
            result.add(key);
        }
        return result;
    }

    public List<String> getCoreBarcodesByReadCount(ObjectCounter<String> barcodes, Integer numReadsCore) {
        String bc;
        int count;
        ArrayList<String> result = new ArrayList<String>();
        log.info(new Object[]{"Looking for cell barcodes that have at least " + numReadsCore + " reads"});
        Iterator<String> iterator = barcodes.getKeysOrderedByCount(true).iterator();
        while (iterator.hasNext() && (count = barcodes.getCountForKey(bc = iterator.next())) >= numReadsCore) {
            result.add(bc);
        }
        log.info(new Object[]{"Selected " + result.size() + " core barcodes"});
        return result;
    }

    public List<String> getTopCoreBarcodesByReadCount(ObjectCounter<String> barcodes, Integer numCells) {
        ArrayList<String> result = new ArrayList<String>();
        log.info(new Object[]{"Looking for the top " + numCells + " cell barcodes"});
        int numCellsAdded = 0;
        for (String bc : barcodes.getKeysOrderedByCount(true)) {
            if (numCellsAdded >= numCells) break;
            result.add(bc);
            ++numCellsAdded;
        }
        log.info(new Object[]{"Selected " + result.size() + " core barcodes"});
        return result;
    }
}

