/*
 * MIT License
 *
 * Copyright 2017 Broad Institute
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.broadinstitute.dropseqrna.annotation;

import java.util.ArrayList;
import java.util.List;

import org.broadinstitute.dropseqrna.annotation.GatherGeneGCLength.GCIsoformSummary;
import org.broadinstitute.dropseqrna.annotation.GatherGeneGCLength.GCResult;
import org.testng.Assert;
import org.testng.annotations.Test;



public class GatherGeneGCLengthTest {

	// tested in Jim Nemesh's notebook by hand.  Sequences BLAT'd against hg19 to verify location/orientation.
	@Test
	public void testPositiveStrandGene () {
		GatherGeneGCLength d = new GatherGeneGCLength();
		/**
		 * RAB42-001
		 *   C   G   GC  ALL
		 * 518 522 1040 1950
		 */
		String t1= "AAGAAATGAGTGAGGTGGATGCTTCAGCGCTGTTAGTCTCCTCCCCATGCCCCTCCTCACTTCATCTAGTTTAGTCCCTTTATCCTGTGAAGTAGGGGTCATCATTAGCCCCCTTTTACAGAGGAGAGAATTGAGGCTTCGAGAGAGAGAAACTTGGCCAGGAGTTTCCACTCGGTCCGACGCCCTCGGTGCCCCGCCGGGTGCATCACCAGGTCCTTTTACCGGAATGTGGTGGGTGTCCTGCTGGTCTTTGATGTGACAAACAGGAAGTCCTTTGAACACATCCAAGACTGGCACCAGGAGGTCATGGCCACTCAGGGCCCGGACAAGGTCATCTTCCTGCTGGTTGGCCACAAGAGTGACCTGCAGAGCACCCGCTGTGTCTCAGCCCAGGAGGCCGAGGAGCTAGCTGCCTCCCTGGGCATGGCCTTCGTGGAGACCTCGGTTAAAAACAACTGCAATGTGGACCTGGCCTTTGACACCCTCGCTGATGCTATCCAGCAGGCCCTGCAGCAGGGGGACATCAAGCTAGAAGAGGGCTGGGGGGGTGTCCGGCTCATCCACAAGACCCAAATCCCCAGGTCCCCCAGCAGGAAGCAGCACTCAGGCCCATGCCAGTGTTGACTCTAGGAGAGAAAGGGTTAAAGCAGTCCCAGCCTTAGCCCACCTGGTGGGATGGGGAGTGTTAATATCTCTCTGGAGGACAAATGACAGAAGGGTTCATATAAACAGTATCCTGACACAGTCATGCTTCCTGGATTTTGGAGTCGAGGCTTTCTACAGAAAAGAAAGTTCTGATGGCCAGGCATGGTGGCTCACGCCTGTAATCCTAGCATTTTTGGAGGCCAAGGACAGTGGATCACCTGAGGTCAGGGGTTCGAGACCAGCCTGGCCAACATGGTGAAACCCTGTCTCTACTAAAAATACAAAAATTAGCCAGGCGTGGTGGTGCATGCCTGTAATCCCAGTTACTCCAGAGGCTAAGGCAGGAGAATTGCTTGAACCTGGGAGGCAGAGATTGCAGTGAGCCAAGACTGCGCCACTGCACTCCAGCCTGGGCAACAGAGTGAGACTCTGTTTCAAAAAAAAAAAAGAAAAGAAAAGAAAGGCCTGAGAGACCAGATGTGCAACTTCCTGTCCTTGAGCCTCAGTGTCCCTATCTATCGATGGGGCTCATAAAAGATCCCACCTTGAAGGGAGGTGGTGACCACAAATGAGACAGTGGACAGGATGTGCTCACCCAGAGCCTGCCGCGCTGTGAATTGAATGACAAAAGCTCTCATTCCCACTCCCTTTTTCTTGGCTGCGATGTGGCCACTCTGGCAGCATTCCTGGGCTCAGACACTGAGAAGCCAGCGTCAGGAAGCTGATGCATGGGCAAAGGCAGGTGCGGGGAATTCCAGGGGGAGCTTGGCTTGGAGGCTTCTTATGTCCTCAGGCTAAAATGATTCTGGGCATGGGATTAATATGTGACGTCAAACCCAGGGTTGCTGGCCAATGCCCCCCCGACCAGGCCCAGGGGCTGAAAAATGGATGTTGGAGGCTGGGATGAACATGAATGTGTAGCAACTATGTTGGGCACACAGTGGCCACTGTGATGAGCCACCAAGATCCCCCTTTCTGGCTGGGGAACCCATCAACCCTCTCCCCAGCTGCTGGAGTGCCACTGGATGATGGACTTCAGCTTGCCCCACTCTCTGGGAAAGGCCCTCCCTTCAGGGCAGCTTGTATCCAAAGTTCATCTCCTGGGGGGCCTTAAAGGACTCCCTCTTGCCCCAGCTCTGGACAACTCTGAAAGTCAAAACCAACTTTATCAGTCTCTGTGGGCTTCATTGAGGACACTGTTGTGACATCATAGCCAAGTTATCCCCTTGCCCAATCCTGCTTCCTTTTCTTCCCCAAACAGGTATCCATTTCAAGAATATCCCCTAATAAACATCTGCACACTCA";
		GCResult gc1 = d.new GCResult(t1);
		Assert.assertEquals(26.5641, gc1.getCPercent(), 0.1);
		Assert.assertEquals(26.76923, gc1.getGPercent(), 0.1);
		Assert.assertEquals(53.33333, gc1.getGCPercent(), 0.1);
		Assert.assertEquals(1950, gc1.getRegionLength());
		/**
		 * RAB42-002
		*   C   G  GC ALL
		* 241 271 512 837
		*/
		String t2 = "GAGGCCGAGGGCTGCCGCTACCAATTTCGGGTCGCGCTGCTGGGGGACGCGGCGGTGGGCAAGACGTCGCTGCTGCGGAGCTACGTGGCAGGCGCGCCTGGCGCCCCGGAGCCGGAGCCCGAGCCCGAGCCCACGGTGGGCGCCGAGTGCTACCGCCGCGCGCTGCAGCTGCGGGCCGGGCCGCGGGTCAAGCTGCAACTCTGGGACACCGCGGGCCACGAGCGCTTCAGGTGCATCACCAGGTCCTTTTACCGGAATGTGGTGGGTGTCCTGCTGGTCTTTGATGTGACAAACAGGAAGTCCTTTGAACACATCCAAGACTGGCACCAGGAGGTCATGGCCACTCAGGGCCCGGACAAGGTCATCTTCCTGCTGGTTGGCCACAAGAGTGACCTGCAGAGCACCCGCTGTGTCTCAGCCCAGGAGGCCGAGGAGCTAGCTGCCTCCCTGGGCATGGCCTTCGTGGAGACCTCGGTTAAAAACAACTGCAATGTGGACCTGGCCTTTGACACCCTCGCTGATGCTATCCAGCAGGCCCTGCAGCAGGGGGACATCAAGCTAGAAGAGGGCTGGGGGGGTGTCCGGCTCATCCACAAGACCCAAATCCCCAGGTCCCCCAGCAGGAAGCAGCACTCAGGCCCATGCCAGTGTTGACTCTAGGAGAGAAAGGGTTAAAGCAGTCCCAGCCTTAGCCCACCTGGTGGGATGGGGAGTGTTAATATCTCTCTGGAGGACAAATGACAGAAGGGTTCATATAAACAGTATCCTGACACAGTCATGCTTCCTGGATTTTGGAGTCGAGGCTTTCTACAGAAAAGAAAGTTCTGATGGCCAGGC";

		GCResult gc2 = d.new GCResult(t2);
		Assert.assertEquals(28.79331, gc2.getCPercent(), 0.1);
		Assert.assertEquals(32.37754, gc2.getGPercent(), 0.1);
		Assert.assertEquals(61.17085, gc2.getGCPercent(), 0.1);
		Assert.assertEquals(837, gc2.getRegionLength());

		List<GCResult> list = new ArrayList<GCResult>();
		list.add(gc1);
		list.add(gc2);

		GCIsoformSummary s = d.new GCIsoformSummary(null, list);
		Assert.assertEquals(s.getMedianC(), 27.67871, 0.1);
		Assert.assertEquals(s.getMedianG(), 29.57339, 0.1);
		Assert.assertEquals(s.getMedianGC(), 57.25209, 0.1);
		Assert.assertEquals(s.getMedianTranscriptLength(), 1394);

	}

	@Test
	public void testNegativeStrandGene () {
		GatherGeneGCLength d = new GatherGeneGCLength();

		//SNIP1-001
		String t1="GTTAAACTCGTCATTTCCTCCAGCTAGAGGAGCTCAACTGATCTGTTTTCTTTCGCCCAGCCAAAATCACAGAATGAAGGCGGTGAAGAGCGAACGGGAGCGAGGGAGCCGGCGAAGACACCGGGACGGGGACGTGGTGCTGCCGGCGGGGGTGGTGGTGAAGCAGGAGCGTCTCAGCCCAGAAGTCGCACCTCCCGCCCACCGCCGTCCGGACCACTCCGGTGGTAGCCCGTCTCCGCCGACCAGCGAGCCGGCCCGCTCGGGCCACCGCGGGAACCGAGCCCGAGGAGTTAGCCGGTCCCCACCCAAAAAGAAAAACAAGGCCTCAGGGAGAAGAAGCAAGTCTCCTCGCAGTAAGAGAAACCGAAGTCCTCACCACTCAACAGTCAAAGTGAAGCAGGAGCGTGAGGATCATCCCCGGAGAGGACGGGAGGATCGGCAGCACAGGGAACCATCAGAACAGGAACACAGGAGAGCTAGGAACAGTGACCGGGACAGACACCGGGGCCATTCCCACCAAAGGAGAACGTCTAACGAGAGGCCTGGGAGTGGGCAGGGTCAGGGACGGGATCGAGACACTCAGAACCTGCAGGCTCAGGAAGAAGAGCGGGAGTTTTATAATGCCAGGCGACGGGAGCATCGCCAGAGGAATGACGTTGGTGGTGGCGGCAGTGAGTCTCAGGAGTTGGTTCCTCGGCCTGGTGGCAACAACAAAGAAAAAGAGGTGCCCGCTAAAGAAAAACCAAGCTTTGAACTTTCTGGGGCACTTCTTGAGGACACCAACACTTTCCGGGGTGTAGTCATTAAATATAGTGAGCCCCCAGAAGCACGTATCCCCAAAAAACGGTGGCGTCTCTACCCATTTAAAAATGATGAGGTGCTTCCAGTCATGTACATACATCGACAGAGTGCGTACCTACTGGGTCGACACCGCCGCATTGCAGACATTCCAATTGATCACCCGTCTTGTTCAAAGCAGCATGCGGTCTTTCAATATCGGCTTGTGGAATATACCCGTGCTGATGGCACAGTTGGCCGAAGAGTGAAGCCCTACATCATTGACCTTGGCTCAGGCAATGGAACCTTCTTAAACAACAAACGTATTGAGCCACAGAGATACTATGAACTAAAAGAAAAGGATGTACTCAAATTTGGATTCAGTAGCAGAGAATACGTCTTGCTCCATGAGTCGTCGGACACTTCTGAAATAGACAGGAAAGATGACGAGGATGAGGAGGAGGAGGAAGAAGTGTCTGACAGCTAGCAAACTAAGAACCCAAACTATTGATACACGGTTTCCTTCTTGGAAGTCTTTGATTGACTCAGAGAGCACTATGGTGGTGGGTCCAGCACTATGGTGCTCTCTGTAATGCCTCTTACTGCCTTAAGTCTTTCCTCTGTTGCTGACCAGATTGTGTTACCATTTGAATACACTGACTAATGTTTGTTAAACTTTTTCTGTGGCACCTTGGCCACATGCCTGCAGGCATTTGTTTTCAGAACAGTCTCACCAATTACAACACACCGTGTTTTAGTAGAAGTGTTGTGGTTTTAGTTGGTGCTTTCAGAACTGCTGCCTAGGAAACTATAAACCCTTGGTTAAGGGGAAATCATGGCTTGTTCTCTTTGTACAGTTACTTTATTTATATAGGTGTTAAGCTTTGTGGACCAGGTGTTTTTCTTTTGGGGCGAACCCCTGAGCAGAGAATCTTACTAGGCTTTGGTTATCACCAAAACAACCTCCAGTATATACCAAAGCTTTGACTTGTTTGAGCTCTTGAGCTTAGAAGTTGATTTTGCACTTATTTTTTTGGGGGGTGGGAATGTACTGCAGTCAGTAAACATTATTGACTGTTTAACTTAAACAGATGCTTTATGGCACCTGCTCAAGCCCGTGACTGTACAGAAGGATCCTGGTTGCTACCAGTGGGTGCTGATTCAGCATCACAAGTGACTGAAATTGGCTGTGGATCTGTTCTTTGTGAAAGAATTCCTGATTTCTCCATGGAGCATGTACACAACAATTTTGATCATATTAACTGTACTTCAGTTTTGCATTTTTATTCAAATGTTATCTCTTTTTTTCTTTGAGAAATAAACTGTCACTGATGTGACAGCGTTCTTTCTTTATTCTAATAACATGTATAGATCTAAAGCAGGTTGTGTTGTTTACATGTTTCTACACATTTCATCCTTTAAAAAGTTGTTGAGAGAGGTTGTATTTACCTTCCCAAGGTTGGAAAGCAGGGGAATTTCCCAGTGTCCTAGTTTTCCACCAGAGGAATATGTGTAAGTAGCAAAGTATTTGCTGCTTACATATAGTGTGTATGTATGTATATATGTAAATTGTGTGTTAAAGAGCTGATACTGATTTTCATATGACAATGTTAGGCAAAGGCCTCCCTGCATTTGAAGAGCAGGTTTTCATTTATATGTATTTTTGGGATAAAAAAATAAAATTTGTAAATATAGCCCCATTTCAAAGAGTAATGCTTTCCTAGCGTAGAGGACCTTGTGTTCATAGGTCTGTTTGCTGCTAATGGAGCCTTCTGTCAGTACTTTTGAGATAAAAGTAGGTAGCTGTTTTAGAGTGTTGTGGGGCAGGTTATATCGTTGGCCTCCAAGTCAGTGGAATAGCAGATGGTGACATGGAGGTGGGTTGTGGGGAAAGGTGGTGAAGCAGCTCAATCAGTGTTACTACTAATTGTTCCTCTTGGGTTGAGACTTAGGATACTATTAAATTTGATTGTTTTCCATTGTTTTTATACCCATGTGTGCTCAGGGCTAAAGATTGGCTAGTGGGAGGGGCAGCTGACTAATGTTCATTCAGAAGAAGTTAAAAGATCCTTTGAAAAGTGAACACTTAATAAGGTCATTAGATGAAACGTAAGTTGGGCCGGGCATGGGCACAGTGGCTCATGCCTGTAATCCCAACACTTTCGGAGGCTGAGGTGGGCAGATCATCTGAGGTCAGGAGTTCAAGACCAACCTGGCCAACATGGTGAAACCCCATCTCTACTAAAAATACAAAAATTAGCTGGGCGTGGTGGCACATGCCTGTTTTAATCCCAGCTACTCGGGAGGCTGAGGCAGGAGAATCGCTTGAACCCGGGAGGTGGAGGTTGCAGCGAGCTGAGATTGTGCCACTGCACTCCAGCCTGGGTGACAGCGAGACTCTGTCTCAGAAAAAAAAAAAAAAGGTAAGTTGAAGAATGTGTTCTACATTGGCCACTGTAACTGCTATTTTCTTCATTTTGGTATGTGCCATAGATCATATATATGTGCTTGTCTGAAAAGTAGGTTTGTTTGGATGAACTTTTCTCTTGATCCAGACTGACGGTTTTCTCTTGAGGGTTTAAGCACTAATCTGGTATCTTACTCTAGGATCTCCTTGTTCAGTCTGTGCTGCAGTAGCACTACTTTGTGGTAGCCTTGAGTTTTGCTACAAACTTCATCCTGGTGGGCACTGTGATAGATGACCACTTTGCCTACATTTTTCAGTAAGAAGTCCTAATTGTTTAGTCAGTTTTTATTTTAGTAGAGGAATAACGTCCTGGATTAAGAAATTCTTTATGCCACATATCTGAGAAGGTGGGTTTTTTTGTTGGTTTGTTTGTTTTGAGATGGCGTCTCACTCTGTCGCCCAGGCTGGAGTGCAGTGGCACCATCTTGGCTCACTGCAACCTCCGCCTCCCAGTTTCAAGCGATTCTCCTGCCTCAGCCTCCCAAGTAGCTGGGACTACAGGCACCTGTCACCAAGCCTGGCTAATTTATATATATAATTTTTATTTTTTATTTTTTTTTAGTAGAGATGGGGTTTCACCATATTGGCCAGGCTGGTCTCGAACTCCTGACCTTGTGATCCGCCCCTCTCAGCCTCCCAAAGTGCTGGGATTACAGGTGTTAGCCACCAGGCCTGGCCTGAGAAGGTGTTTTTTTTTTTTTTTGGTCTTGTTTTCCCTTACCCCTTTCTTTGAAGAAAGGGTGTCAAAAGACATTACCTGCCTCTAAAGCCAGATATCACCAGCAGACTTCTTAAAGTGGACATAATCCTAGAGCTTTCATTCTGTTTAGAAGTTCATGTTCATCTTAGCCATTTGGAACTTCTTCATTCTCTATCTTTTCTCCACGGTGGCTGGGCTTGTCTGCAAATCATTGTGTCAAAATCAAACTATTTTCAAAACAGCCCTTTGCTTCTGAGCCCCTCCCCTAAGTCCTCTGTGGGGGTCCATGATTCTGCAGAGGTATGGGACAGAATCTTCAGATTTTACCCCTTGAGTCTCTTCCTAGTCATATCCTGGTTCCCTCATTCTAATATTGACAAAGGATGACTCATTAAGTGCAACTGGTTATGTAACTTTCAAATACTTTCATTGTGTATGTCAGGATCTGAGGAACAAAATGATGTCATTTAATCGGAATCTAAACGTGACACAAACAACGTGCCAGCAATACCTGCTTGTGAAATAATGTTCTGAGCCCACAGTGTTCCTGGGTATGTGAGTTTATATCAAGTGAAAAGGCTGCTTAATTGACATTAAAGTTTTGGAATGTAAAGCTTCA";
		GCResult gc1 = d.new GCResult(t1);
		Assert.assertEquals(20.8, gc1.getCPercent(), 0.1);
		Assert.assertEquals(24.2, gc1.getGPercent(), 0.1);
		Assert.assertEquals(45.1, gc1.getGCPercent(), 0.1);
		Assert.assertEquals(4563, gc1.getRegionLength());

		//SNIP1-002
		String t2 = "ATTTCCTCCAGCTAGAGGAGCTCAACTGATCTGTTTTCTTTCGCCCAGCCAAAATCACAGAATGAAGGCGGTGAAGAGCGAACGGGAGCGAGGGAGCCGGCGAAGACACCGGGACGGGGACGTGGTGCTGCCGGCGGGGGTGGTGGTGAAGCAGGAGCGTCTCAGCCCAGAAGTCGCACCTCCCGCCCACCGCCGTCCGGACCACTCCGGTGGTAGCCCGTCTCCGCCGACCAGCGAGCCGGCCCGCTCGGGCCACCGCGGGAACCGAGCCCGAGGAGTTAGCCGGTCCCCACCCAAAAAGAAAAACAAGGCCTCAGGGAGAAGAAGCAAGTCTCCTCGCAGTAAGAGAAACCGAAGTCCTCACCACTCAACAGTCAAAGTGAAGCAGGTAAGTGGATTGGGGTGTTTTGATGGGTCCAAATTGAGAGCCTTTTCCTATCACAGCTAAAGAGGAATGTGTGTGTGTGTTGTGTGTGTGCACACATGTGCACGTACGCTCGCCTACATCTCTACTTGTACCTCCGATGGGCTTTTCTGAAAACTGGC";
		GCResult gc2 = d.new GCResult(t2);
		Assert.assertEquals(27.8, gc2.getCPercent(), 0.1);
		Assert.assertEquals(30.2, gc2.getGPercent(), 0.1);
		Assert.assertEquals(58.1, gc2.getGCPercent(), 0.1);
		Assert.assertEquals(546, gc2.getRegionLength());

		//SNIP1-003
		String t3 = "GCCCAGCCAAAATCACAGAATGAAGGCGGTGAAGAGCGAACGGGAGCGAGGGAGCCGGTCCCCACCCAAAAAGAAAAACAAGGCCTCAGGGAGAAGAAGCAAGTCTCCTCGCAGTAAGAGAAACCGAAGTCCTCACCACTCAACAGTCAAAGTGAAGCAGTCCGTTTTCATGCTGTTGATAAAGACATACCCGAGACCCGGCGATTTACAAAAGAAAGAGGTTTAATGGACTTACAGTTCCACATGGCTGGAGAGGCCTCACAATCATGGTGGGAAGCAAGGAGGAGCAAATCACACGGATGGCGTCAGGCAAGGAGAGATAAAAGAGAGCGTGAGGATCATCCCCGGAGAGGACGGGAGGATCGGCAGCACAGGGAACCATCAGAACAGGAACACAGGAGAGCTAGGAACAGTGACCGGGACAGACACCGGGGCCATTCCCACCAAAGGAGAACGTCTAACGAGAGGCCTGGGAGTGGGCAGGGTCAGGGACGGGATCGAGACACTCAGAACCTGCAGGCTCAGGAAGAAGAGCGGGAGTTTTATAATGCCAGGCGACGGGAGCATCGCCAGAGGAATGACG";
		GCResult gc3 = d.new GCResult(t3);
		Assert.assertEquals(22.8, gc3.getCPercent(), 0.1);
		Assert.assertEquals(31.7, gc3.getGPercent(), 0.1);
		Assert.assertEquals(54.5, gc3.getGCPercent(), 0.1);
		Assert.assertEquals(583, gc3.getRegionLength());

		List<GCResult> list = new ArrayList<GCResult>();
		list.add(gc1);
		list.add(gc2);
		list.add(gc3);

		GCIsoformSummary s = d.new GCIsoformSummary(null, list);
		Assert.assertEquals(s.getMedianC(), 22.8, 0.1);
		Assert.assertEquals(s.getMedianG(), 30.2, 0.1);
		Assert.assertEquals(s.getMedianGC(), 54.5, 0.1);
		Assert.assertEquals(s.getMedianTranscriptLength(), 583);

	}
}
