/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.metrics;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IterableAdapter;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.broadinstitute.dropseqrna.cmdline.DropSeq;
import org.broadinstitute.dropseqrna.utils.ObjectCounter;
import org.broadinstitute.dropseqrna.utils.io.ErrorCheckingPrintStream;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;

@CommandLineProgramProperties(usage="Create a histogram of values for the given tag", usageShort="Create a histogram of values for the given tag", programGroup=DropSeq.class)
public class BAMTagHistogram
extends CommandLineProgram {
    private static final Log log = Log.getInstance(BAMTagHistogram.class);
    @Option(shortName="I", doc="The input SAM or BAM file to analyze.  Must be coordinate sorted. (???)")
    public File INPUT;
    @Option(shortName="O", doc="Output file of histogram of tag value frequencies. This supports zipped formats like gz and bz2.")
    public File OUTPUT;
    @Option(doc="Tag to extract")
    public String TAG;
    @Option(doc="Filter PCR Duplicates.")
    public boolean FILTER_PCR_DUPLICATES = false;
    @Option(doc="Read quality filter.  Filters all reads lower than this mapping quality.  Defaults to 10.  Set to 0 to not filter reads by map quality.")
    public Integer READ_QUALITY = 10;

    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        ObjectCounter<String> counter = this.getBamTagCounts(this.INPUT, this.TAG, (int)this.READ_QUALITY, this.FILTER_PCR_DUPLICATES);
        List<String> tagsByCount = counter.getKeysOrderedByCount(true);
        ErrorCheckingPrintStream writer = new ErrorCheckingPrintStream(IOUtil.openFileForWriting((File)this.OUTPUT));
        this.writeHeader(writer);
        for (String s : tagsByCount) {
            int count = counter.getCountForKey(s);
            Object[] h = new String[]{count + "", s};
            String result = StringUtils.join((Object[])h, (String)"\t");
            writer.println(result);
            ((PrintStream)writer).flush();
        }
        ((PrintStream)writer).close();
        return 0;
    }

    public void writeHeader(PrintStream writer) {
        ArrayList<String> header = new ArrayList<String>();
        header.add("INPUT=" + this.INPUT.getAbsolutePath());
        header.add("TAG=" + this.TAG);
        header.add("FILTER_PCR_DUPLICATES=" + this.FILTER_PCR_DUPLICATES);
        header.add("READ_QUALITY=" + this.READ_QUALITY);
        String h = StringUtils.join(header, (String)"\t");
        writer.print("#");
        writer.println(h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectCounter<String> getBamTagCounts(File bamFile, String tag, int readQuality, boolean filterPCRDuplicates) {
        SamReader inputSam = SamReaderFactory.makeDefault().enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.EAGERLY_DECODE}).open(bamFile);
        try {
            ObjectCounter<String> objectCounter = this.getBamTagCounts((Iterator<SAMRecord>)inputSam.iterator(), tag, readQuality, filterPCRDuplicates);
            return objectCounter;
        }
        finally {
            CloserUtil.close((Object)inputSam);
        }
    }

    public ObjectCounter<String> getBamTagCounts(Iterator<SAMRecord> iterator, String tag, int readQuality, boolean filterPCRDuplicates) {
        ProgressLogger pl = new ProgressLogger(log, 10000000);
        ObjectCounter<String> counter = new ObjectCounter<String>();
        for (SAMRecord r : new IterableAdapter(iterator)) {
            String s1;
            pl.record(r);
            if (filterPCRDuplicates && r.getDuplicateReadFlag() || r.getMappingQuality() < readQuality || r.isSecondaryOrSupplementary() || (s1 = this.getAnyTagAsString(r, tag)) == null || s1 == "") continue;
            counter.increment(s1);
        }
        return counter;
    }

    public String getAnyTagAsString(SAMRecord r, String tag) {
        String s = null;
        Object o = r.getAttribute(tag);
        if (o == null) {
            return s;
        }
        if (o instanceof String) {
            s = (String)o;
            return s;
        }
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            s = i.toString();
            return s;
        }
        return s;
    }

    public static void main(String[] args) {
        System.exit(new BAMTagHistogram().instanceMain(args));
    }
}

