/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.readiterators;

import htsjdk.samtools.SAMRecord;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.broadinstitute.dropseqrna.utils.FilteredIterator;

public class ChromosomeFilteringIterator
extends FilteredIterator<SAMRecord> {
    private final Set<String> contigsToFilter;
    private final boolean excludeContig;

    public ChromosomeFilteringIterator(Iterator<SAMRecord> underlyingIterator, Collection<String> contigsToFilter) {
        this(underlyingIterator, contigsToFilter, true);
    }

    public ChromosomeFilteringIterator(Iterator<SAMRecord> underlyingIterator, Collection<String> contigsToFilter, boolean excludeContig) {
        super(underlyingIterator);
        this.contigsToFilter = contigsToFilter != null ? new HashSet<String>(contigsToFilter) : null;
        this.excludeContig = excludeContig;
    }

    @Override
    public boolean filterOut(SAMRecord rec) {
        if (this.contigsToFilter == null) {
            return false;
        }
        if (this.excludeContig) {
            return this.contigsToFilter.contains(rec.getContig());
        }
        return !this.contigsToFilter.contains(rec.getContig());
    }
}

