/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.annotation;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.broadinstitute.dropseqrna.annotation.GTFParser;
import org.broadinstitute.dropseqrna.annotation.GTFRecord;
import org.broadinstitute.dropseqrna.annotation.GeneFromGTF;
import org.broadinstitute.dropseqrna.utils.FilteredIterator;
import picard.annotation.AnnotationException;

public class GeneFromGTFBuilder
implements Iterator<GeneFromGTF> {
    private final Log LOG = Log.getInstance(GeneFromGTFBuilder.class);
    final Iterator<Collection<GTFRecord>> gtfRecordsByGeneIterator;

    public GeneFromGTFBuilder(Iterator<GTFRecord> gtfRecords) {
        Map<String, Collection<GTFRecord>> gatheredByGene = this.gatherByGeneName(gtfRecords);
        this.gtfRecordsByGeneIterator = gatheredByGene.values().iterator();
    }

    @Override
    public boolean hasNext() {
        return this.gtfRecordsByGeneIterator.hasNext();
    }

    @Override
    public GeneFromGTF next() {
        Collection<GTFRecord> recordsForGene = this.gtfRecordsByGeneIterator.next();
        return this.makeGeneFromMultiVersionGTFRecords(recordsForGene);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private GeneFromGTF makeGeneFromMultiVersionGTFRecords(Collection<GTFRecord> gtfRecords) {
        Map<Integer, Collection<GTFRecord>> gtfRecordsByGeneVersion = this.gatherByGeneVersion(gtfRecords);
        ArrayList<Integer> versions = new ArrayList<Integer>(gtfRecordsByGeneVersion.keySet());
        Collections.sort(versions);
        int highestVersion = (Integer)versions.get(versions.size() - 1);
        return this.makeGeneWithTranscriptsFromGTFRecords(gtfRecordsByGeneVersion.get(highestVersion));
    }

    private GeneFromGTF makeGeneWithTranscriptsFromGTFRecords(Collection<GTFRecord> gtfRecords) {
        GeneFromGTF gene = this.makeGeneFromGTFRecords(gtfRecords);
        Collection nonGeneGTFRecords = CollectionUtil.makeCollection((Iterator)((Object)new GeneAnnotationFilter(gtfRecords.iterator())));
        Map<String, Collection<GTFRecord>> gtfLinesByTranscript = this.gatherByTranscriptId(nonGeneGTFRecords);
        for (Map.Entry<String, Collection<GTFRecord>> entry : gtfLinesByTranscript.entrySet()) {
            if (entry.getKey() == null) continue;
            this.addTranscriptToGeneFromGTFRecords(gene, entry.getValue());
        }
        if (!gene.iterator().hasNext()) {
            throw new AnnotationException("No transcript in GTF for gene " + gene.getName());
        }
        return gene;
    }

    private GeneFromGTF makeGeneFromGTFRecords(Collection<GTFRecord> gtfRecords) {
        GTFRecord lineOne = gtfRecords.iterator().next();
        String geneName = lineOne.getGeneName();
        boolean transcriptNegStrand = lineOne.isNegativeStrand();
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        HashSet<String> geneIds = new HashSet<String>();
        HashSet<String> chromosomes = new HashSet<String>();
        for (GTFRecord r : gtfRecords) {
            start = Math.min(start, r.getStart());
            end = Math.max(end, r.getEnd());
            geneIds.add(r.getGeneID());
            chromosomes.add(r.getChromosome());
        }
        if (chromosomes.size() > 1) {
            throw new AnnotationException("Chromosome disagreement(" + CollectionUtil.join(chromosomes, (String)", ") + ") in GTF file for gene " + geneName);
        }
        GeneFromGTF gene = new GeneFromGTF(lineOne.getChromosome(), start, end, transcriptNegStrand, geneName, lineOne.getFeatureType(), lineOne.getGeneID(), lineOne.getTranscriptType(), lineOne.getGeneVersion());
        for (GTFRecord gtfRecord : gtfRecords) {
            this.validateGTFRecord(gtfRecord, gene);
        }
        if (geneIds.size() > 1) {
            throw new AnnotationException(String.format("Multiple gene IDs for gene %s: %s", geneName, CollectionUtil.join(geneIds, (String)", ")));
        }
        return gene;
    }

    private GeneFromGTF.TranscriptFromGTF addTranscriptToGeneFromGTFRecords(GeneFromGTF gene, Collection<GTFRecord> transcriptLines) {
        String geneName = gene.getName();
        GTFRecord lineOne = transcriptLines.iterator().next();
        String transcriptName = lineOne.getTranscriptName();
        String transcriptID = lineOne.getTranscriptID();
        String transcriptDescription = geneName + ":" + transcriptName;
        String transcriptType = lineOne.getTranscriptType();
        ArrayList<Exon> exons = new ArrayList<Exon>();
        int transcriptionStart = Integer.MAX_VALUE;
        int transcriptionEnd = Integer.MIN_VALUE;
        int codingStart = Integer.MAX_VALUE;
        int codingEnd = Integer.MIN_VALUE;
        for (GTFRecord r : transcriptLines) {
            String featureType = r.getFeatureType();
            int start = r.getStart();
            int end = r.getEnd();
            if (featureType.equals("exon")) {
                Exon e = new Exon(start, end);
                exons.add(e);
                transcriptionStart = Math.min(transcriptionStart, start);
                transcriptionEnd = Math.max(transcriptionEnd, end);
            }
            if (!featureType.equals("CDS")) continue;
            codingStart = Math.min(codingStart, start);
            codingEnd = Math.max(codingEnd, end);
        }
        Collections.sort(exons);
        if (codingStart == Integer.MAX_VALUE) {
            codingStart = transcriptionStart;
        }
        if (codingEnd == Integer.MIN_VALUE) {
            codingEnd = transcriptionEnd;
        }
        GeneFromGTF.TranscriptFromGTF tx = gene.addTranscript(transcriptName, transcriptionStart, transcriptionEnd, codingStart, codingEnd, exons.size(), transcriptName, transcriptID, transcriptType);
        for (int i = 0; i < exons.size(); ++i) {
            Exon e = (Exon)exons.get(i);
            if (e.start > e.end) {
                throw new AnnotationException("Exon has 0 or negative extent for " + transcriptDescription);
            }
            if (i > 0 && ((Exon)exons.get((int)(i - 1))).end >= ((Exon)exons.get((int)i)).start) {
                throw new AnnotationException("Exons overlap for " + transcriptDescription);
            }
            tx.addExon(e.start, e.end);
        }
        return tx;
    }

    private void validateGTFRecord(GTFRecord gtfRecord, GeneFromGTF gene) {
        if (gene.isPositiveStrand() == gtfRecord.isNegativeStrand()) {
            throw new AnnotationException("Strand disagreement in GTF file for gene " + gene.getName());
        }
        if (!gene.getContig().equals(gtfRecord.getChromosome())) {
            throw new AnnotationException("Chromosome disagreement(" + gene.getContig() + " != " + gtfRecord.getChromosome() + ") in GTF file for gene " + gene.getName());
        }
        if (gtfRecord.getFeatureType().equals(GTFParser.GTFFeature.gene.name()) && (gtfRecord.getStart() != gene.getStart() || gtfRecord.getEnd() != gene.getEnd())) {
            throw new AnnotationException(String.format("gene GTFRecord(%s) != GeneFromGTF(%s)", gtfRecord.toString(), gene.toString()));
        }
    }

    private Map<String, Collection<GTFRecord>> gatherByGeneName(Iterator<GTFRecord> gtfRecords) {
        return CollectionUtil.partition((Collection)CollectionUtil.makeCollection(gtfRecords), (CollectionUtil.Partitioner)new CollectionUtil.Partitioner<GTFRecord, String>(){

            public String getPartition(GTFRecord gtfRecord) {
                return gtfRecord.getGeneName();
            }
        });
    }

    private Map<Integer, Collection<GTFRecord>> gatherByGeneVersion(Collection<GTFRecord> gtfRecords) {
        return CollectionUtil.partition(gtfRecords, (CollectionUtil.Partitioner)new CollectionUtil.Partitioner<GTFRecord, Integer>(){

            public Integer getPartition(GTFRecord gtfRecord) {
                if (gtfRecord.getGeneVersion() != null) {
                    return gtfRecord.getGeneVersion();
                }
                return Integer.MIN_VALUE;
            }
        });
    }

    private Map<String, Collection<GTFRecord>> gatherByTranscriptId(Collection<GTFRecord> gtfRecords) {
        return CollectionUtil.partition(gtfRecords, (CollectionUtil.Partitioner)new CollectionUtil.Partitioner<GTFRecord, String>(){

            public String getPartition(GTFRecord gtfRecord) {
                if (gtfRecord.getTranscriptID() == null) {
                    throw new RuntimeException("GTFRecord does not have transcriptID: " + gtfRecord);
                }
                return gtfRecord.getTranscriptID();
            }
        });
    }

    private static class GeneAnnotationFilter
    extends FilteredIterator<GTFRecord> {
        private GeneAnnotationFilter(Iterator<GTFRecord> underlyingIterator) {
            super(underlyingIterator);
        }

        @Override
        public boolean filterOut(GTFRecord rec) {
            return GTFParser.GTFFeature.gene.name().equals(rec.getFeatureType());
        }
    }

    private static class Exon
    implements Comparable<Exon> {
        public final int start;
        public final int end;

        public Exon(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public int compareTo(Exon o) {
            int ret = Integer.compare(this.start, o.start);
            if (ret != 0) {
                return ret;
            }
            return Integer.compare(this.end, o.end);
        }
    }
}

