/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.modularfileparser;

import htsjdk.samtools.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.broadinstitute.dropseqrna.utils.modularfileparser.ModularFileParserException;
import org.broadinstitute.dropseqrna.utils.modularfileparser.Parser;

public class ModularFileParser {
    private final Log log = Log.getInstance(ModularFileParser.class);
    private Parser parser;
    private BufferedReader in;
    private boolean hasNext = true;
    private int linesToSkip;
    private boolean linesSkiped;

    public ModularFileParser(Parser parser, File inFile, int linesToSkip) {
        this.parser = parser;
        try {
            this.in = new BufferedReader(new FileReader(inFile));
        }
        catch (FileNotFoundException e) {
            throw new ModularFileParserException("File not found: " + inFile.getAbsolutePath());
        }
        this.linesToSkip = linesToSkip;
    }

    public String[] readNextLine() {
        String rawLine = this.getNextRawLine();
        if (rawLine == null) {
            return null;
        }
        String[] result = this.parser.parseLine(rawLine);
        return result;
    }

    private String getNextRawLine() {
        if (!this.hasNext) {
            return null;
        }
        String nextLine = null;
        try {
            if (!this.linesSkiped) {
                for (int i = 0; i < this.linesToSkip; ++i) {
                    this.in.readLine();
                }
                this.linesSkiped = true;
                this.log.info(new Object[]{"line skipping complete"});
            }
            if ((nextLine = this.in.readLine()) == null) {
                this.hasNext = false;
                this.in.close();
                this.log.info(new Object[]{"End of file reached, closing buffered reader."});
            }
        }
        catch (IOException e) {
            throw new ModularFileParserException("Can't read from file: ");
        }
        return nextLine;
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new ModularFileParserException("Can't close file after reading finished");
        }
    }
}

