/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.readiterators;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTagUtil;
import java.util.Iterator;
import org.broadinstitute.dropseqrna.utils.FilteredIterator;

public class MissingTagFilteringIterator
extends FilteredIterator<SAMRecord> {
    final short[] requiredTags;

    public MissingTagFilteringIterator(Iterator<SAMRecord> underlyingIterator, String ... requiredTags) {
        super(underlyingIterator);
        this.requiredTags = new short[requiredTags.length];
        for (int i = 0; i < requiredTags.length; ++i) {
            this.requiredTags[i] = SAMTagUtil.getSingleton().makeBinaryTag(requiredTags[i]);
        }
    }

    @Override
    public boolean filterOut(SAMRecord rec) {
        for (short tag : this.requiredTags) {
            if (rec.getAttribute(tag) != null) continue;
            return true;
        }
        return false;
    }
}

