/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.readiterators;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import htsjdk.samtools.MergingSamRecordIterator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.dropseqrna.utils.readiterators.SamHeaderAndIterator;
import picard.PicardException;

public class SamFileMergeUtil {
    public static SamHeaderAndIterator mergeInputs(List<File> inputs, boolean maintainSort, SamReaderFactory samReaderFactory) {
        if (inputs.isEmpty()) {
            throw new IllegalArgumentException("At least one input must be provided");
        }
        ArrayList<SamReader> readers = new ArrayList<SamReader>(inputs.size());
        ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>(inputs.size());
        Interner sequenceDictionaryInterner = Interners.newStrongInterner();
        SAMFileHeader.SortOrder inputSortOrder = null;
        for (File inFile : inputs) {
            IOUtil.assertFileIsReadable((File)inFile);
            SamReader in = samReaderFactory.open(inFile);
            readers.add(in);
            SAMFileHeader header = in.getFileHeader();
            header.setSequenceDictionary((SAMSequenceDictionary)sequenceDictionaryInterner.intern((Object)header.getSequenceDictionary()));
            if (maintainSort) {
                if (inputSortOrder == null) {
                    inputSortOrder = header.getSortOrder();
                } else if (header.getSortOrder() != inputSortOrder) {
                    throw new PicardException(String.format("Sort order(%s) of %s does not agree with sort order(%s) of %s", header.getSortOrder(), inFile.getAbsolutePath(), inputSortOrder, inputs.get(0).getAbsolutePath()));
                }
            }
            headers.add(header);
        }
        if (inputs.size() == 1) {
            return new SamHeaderAndIterator((SAMFileHeader)headers.get(0), (CloseableIterator<SAMRecord>)((SamReader)readers.get(0)).iterator());
        }
        SAMFileHeader.SortOrder outputSortOrder = maintainSort ? inputSortOrder : SAMFileHeader.SortOrder.unsorted;
        SamFileHeaderMerger headerMerger = new SamFileHeaderMerger(outputSortOrder, headers, false);
        MergingSamRecordIterator iterator = new MergingSamRecordIterator(headerMerger, readers, true);
        return new SamHeaderAndIterator(headerMerger.getMergedHeader(), (CloseableIterator<SAMRecord>)iterator);
    }

    public static SamHeaderAndIterator mergeInputs(List<File> inputs, boolean maintainSort) {
        return SamFileMergeUtil.mergeInputs(inputs, maintainSort, SamReaderFactory.makeDefault());
    }
}

