/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.alignment;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.Future;
import javax.swing.tree.TreeNode;
import org.biojava.nbio.alignment.SimpleProfile;
import org.biojava.nbio.alignment.template.GuideTreeNode;
import org.biojava.nbio.alignment.template.PairwiseSequenceScorer;
import org.biojava.nbio.alignment.template.Profile;
import org.biojava.nbio.alignment.template.ProfilePair;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.forester.evoinference.distance.NeighborJoining;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;

public class GuideTree<S extends Sequence<C>, C extends Compound>
implements Iterable<GuideTreeNode<S, C>> {
    private List<S> sequences;
    private List<PairwiseSequenceScorer<S, C>> scorers;
    private BasicSymmetricalDistanceMatrix distances;
    private String newick;
    private Node root;

    public GuideTree(List<S> sequences, List<PairwiseSequenceScorer<S, C>> scorers) {
        this.sequences = Collections.unmodifiableList(sequences);
        this.scorers = Collections.unmodifiableList(scorers);
        this.distances = new BasicSymmetricalDistanceMatrix(sequences.size());
        BasicSymmetricalDistanceMatrix distclone = new BasicSymmetricalDistanceMatrix(sequences.size());
        int n = 0;
        for (int i = 0; i < sequences.size(); ++i) {
            AccessionID id = ((Sequence)sequences.get(i)).getAccession();
            String str = id == null ? Integer.toString(i + 1) : id.getID();
            this.distances.setIdentifier(i, str);
            distclone.setIdentifier(i, str);
            for (int j = i + 1; j < sequences.size(); ++j) {
                double dist = scorers.get(n++).getDistance();
                this.distances.setValue(i, j, dist);
                distclone.setValue(i, j, dist);
            }
        }
        Phylogeny phylogeny = NeighborJoining.createInstance().execute(distclone);
        this.newick = phylogeny.toString();
        this.root = new Node(phylogeny.getRoot(), null);
    }

    public double[] getAllPairsScores() {
        double[] scores = new double[this.scorers.size()];
        int n = 0;
        for (PairwiseSequenceScorer<S, C> scorer : this.scorers) {
            scores[n++] = scorer.getScore();
        }
        return scores;
    }

    public double[][] getDistanceMatrix() {
        double[][] matrix = new double[this.distances.getSize()][this.distances.getSize()];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = i + 1; j < matrix.length; ++j) {
                double d = this.distances.getValue(i, j);
                matrix[j][i] = d;
                matrix[i][j] = d;
            }
        }
        return matrix;
    }

    public Node getRoot() {
        return this.root;
    }

    public double[][] getScoreMatrix() {
        double[][] matrix = new double[this.sequences.size()][this.sequences.size()];
        int n = 0;
        for (int i = 0; i < matrix.length; ++i) {
            matrix[i][i] = this.scorers.get(i).getMaxScore();
            for (int j = i + 1; j < matrix.length; ++j) {
                double d = this.scorers.get(n++).getScore();
                matrix[j][i] = d;
                matrix[i][j] = d;
            }
        }
        return matrix;
    }

    public List<S> getSequences() {
        return this.sequences;
    }

    @Override
    public Iterator<GuideTreeNode<S, C>> iterator() {
        return new PostOrderIterator();
    }

    public String toString() {
        return this.newick;
    }

    private class PostOrderIterator
    implements Iterator<GuideTreeNode<S, C>> {
        private Stack<Node> nodes;

        private PostOrderIterator() {
            GuideTree.this.getRoot().clearVisited();
            this.nodes = new Stack();
            this.nodes.push(GuideTree.this.getRoot());
        }

        @Override
        public boolean hasNext() {
            return !this.nodes.isEmpty();
        }

        @Override
        public GuideTreeNode<S, C> next() {
            while (this.hasNext()) {
                Node next = this.nodes.peek();
                Node child1 = (Node)next.getChild1();
                Node child2 = (Node)next.getChild2();
                if (child1 != null && !child1.isVisited()) {
                    this.nodes.push(child1);
                    continue;
                }
                if (child2 != null && !child2.isVisited()) {
                    this.nodes.push(child2);
                    continue;
                }
                next.visit();
                return this.nodes.pop();
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class Node
    implements GuideTreeNode<S, C> {
        private GuideTreeNode<S, C> parent;
        private GuideTreeNode<S, C> child1;
        private GuideTreeNode<S, C> child2;
        private double distance;
        private String name;
        private boolean isLeaf;
        private boolean isVisited;
        private Profile<S, C> profile;
        private Future<ProfilePair<S, C>> profileFuture;

        private Node(PhylogenyNode node, Node parent) {
            this.parent = parent;
            this.distance = node.getDistanceToParent();
            this.name = node.getName();
            this.isLeaf = node.isExternal();
            if (this.isLeaf) {
                this.profile = new SimpleProfile((Sequence)GuideTree.this.sequences.get(GuideTree.this.distances.getIndex(this.name)));
            } else {
                this.child1 = new Node(node.getChildNode1(), this);
                this.child2 = new Node(node.getChildNode2(), this);
            }
        }

        @Override
        public GuideTreeNode<S, C> getChild1() {
            return this.child1;
        }

        @Override
        public GuideTreeNode<S, C> getChild2() {
            return this.child2;
        }

        @Override
        public double getDistanceToParent() {
            return this.distance;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Profile<S, C> getProfile() {
            return this.profile;
        }

        @Override
        public Future<ProfilePair<S, C>> getProfileFuture() {
            return this.profileFuture;
        }

        @Override
        public void setProfile(Profile<S, C> profile) {
            this.profile = profile;
            this.profileFuture = null;
        }

        @Override
        public void setProfileFuture(Future<ProfilePair<S, C>> profileFuture) {
            this.profileFuture = profileFuture;
            this.profile = null;
        }

        public Enumeration<GuideTreeNode<S, C>> children() {
            Vector children = new Vector();
            children.add(this.getChild1());
            children.add(this.getChild2());
            return children.elements();
        }

        @Override
        public boolean getAllowsChildren() {
            return !this.isLeaf();
        }

        @Override
        public GuideTreeNode<S, C> getChildAt(int childIndex) {
            if (childIndex == 1) {
                return this.getChild1();
            }
            if (childIndex == 2) {
                return this.getChild2();
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getChildCount() {
            return 2;
        }

        @Override
        public int getIndex(TreeNode child) {
            return this.getChildAt(1) == child ? 1 : (this.getChildAt(2) == child ? 2 : -1);
        }

        @Override
        public GuideTreeNode<S, C> getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return this.isLeaf;
        }

        private void clearVisited() {
            this.isVisited = false;
            if (!this.isLeaf()) {
                ((Node)this.getChild1()).clearVisited();
                ((Node)this.getChild2()).clearVisited();
            }
        }

        private boolean isVisited() {
            return this.isVisited;
        }

        private void visit() {
            this.isVisited = true;
        }
    }
}

