/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Binomial;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class HyperGeometric
extends GenericDistribution {
    protected double r;
    protected double b;
    protected double n;
    protected RandomState state;

    public static final RandomState create_random_state() {
        return new RandomState();
    }

    public static final double density(double x, double r, double b, double n, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(r) || Double.isNaN(b) || Double.isNaN(n)) {
            return x + r + b + n;
        }
        if (r < 0.0 || MathFunctions.isNonInt(r) || b < 0.0 || MathFunctions.isNonInt(b) || n < 0.0 || MathFunctions.isNonInt(n) || n > r + b) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (MathFunctions.isNonInt(x)) {
            System.err.println("WARNING: Non-integer x in HyperGeometric.density");
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        x = Math.rint(x);
        r = Math.rint(r);
        b = Math.rint(b);
        if ((n = Math.rint(n)) < x || r < x || n - x > b) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (n == 0.0) {
            return x == 0.0 ? (give_log ? 0.0 : 1.0) : (give_log ? Double.NEGATIVE_INFINITY : 0.0);
        }
        double p = n / (r + b);
        double q = (r + b - n) / (r + b);
        double p1 = Binomial.density_raw(x, r, p, q, give_log);
        double p2 = Binomial.density_raw(n - x, b, p, q, give_log);
        double p3 = Binomial.density_raw(n, r + b, p, q, give_log);
        return give_log ? p1 + p2 - p3 : p1 * p2 / p3;
    }

    public static final double pdhyper(double x, double NR, double NB, double n, boolean log_p) {
        double sum = 0.0;
        double term = 1.0;
        while (x > 0.0 && term >= 2.220446049250313E-16 * sum) {
            sum += (term *= x * (NB - n + x) / (n + 1.0 - x) / (NR + 1.0 - x));
            x -= 1.0;
        }
        return log_p ? Math.log1p(sum) : 1.0 + sum;
    }

    public static final double cumulative(double x, double NR, double NB, double n, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(NR) || Double.isNaN(NB) || Double.isNaN(n)) {
            return x + NR + NB + n;
        }
        x = Math.floor(x + 1.0E-7);
        NR = Math.rint(NR);
        NB = Math.rint(NB);
        n = Math.rint(n);
        if (NR < 0.0 || NB < 0.0 || MathFunctions.isInfinite(NR + NB) || n < 0.0 || n > NR + NB) {
            return Double.NaN;
        }
        if (x * (NR + NB) > n * NR) {
            double oldNB = NB;
            NB = NR;
            NR = oldNB;
            x = n - x - 1.0;
            boolean bl = lower_tail = !lower_tail;
        }
        if (x < 0.0) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        if (x >= NR || x >= n) {
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        double d = HyperGeometric.density(x, NR, NB, n, log_p);
        double pd = HyperGeometric.pdhyper(x, NR, NB, n, log_p);
        return log_p ? (lower_tail ? (log_p ? d + pd : Math.log(d + pd)) : (log_p ? (d + pd > -0.6931471805599453 ? Math.log(-Math.expm1(d + pd)) : Math.log1p(-Math.exp(d + pd))) : Math.log1p(-(d + pd)))) : (lower_tail ? d * pd : 0.5 - d * pd + 0.5);
    }

    static final double lfastchoose(double n, double k) {
        return -Math.log(n + 1.0) - MathFunctions.lbeta(n - k + 1.0, k + 1.0);
    }

    public static final double quantile(double p, double NR, double NB, double n, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(p) || Double.isNaN(NR) || Double.isNaN(NB) || Double.isNaN(n)) {
            return p + NR + NB + n;
        }
        if (MathFunctions.isInfinite(p) || MathFunctions.isInfinite(NR) || MathFunctions.isInfinite(NB) || MathFunctions.isInfinite(n)) {
            return Double.NaN;
        }
        NR = Math.rint(NR);
        NB = Math.rint(NB);
        double N = NR + NB;
        n = Math.rint(n);
        if (NR < 0.0 || NB < 0.0 || n < 0.0 || n > N) {
            return Double.NaN;
        }
        double xstart = Math.max(0.0, n - NB);
        double xend = Math.min(n, NR);
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? xend : xstart;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? xstart : xend;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? xstart : xend;
            }
            if (p == 1.0) {
                return lower_tail ? xend : xstart;
            }
        }
        double xr = xstart;
        double xb = n - xr;
        boolean small_N = N < 1000.0;
        double term = HyperGeometric.lfastchoose(NR, xr) + HyperGeometric.lfastchoose(NB, xb) - HyperGeometric.lfastchoose(N, n);
        if (small_N) {
            term = Math.exp(term);
        }
        NR -= xr;
        NB -= xb;
        if (!lower_tail || log_p) {
            p = log_p ? (lower_tail ? Math.exp(p) : -Math.expm1(p)) : (lower_tail ? p : 0.5 - p + 0.5);
        }
        p *= 0.999999999999778;
        double sum = small_N ? term : Math.exp(term);
        while (sum < p && xr < xend) {
            term = small_N ? (term *= NR / xr * (xb / NB)) : (term += Math.log(NR / (xr += 1.0) * (xb / (NB += 1.0))));
            sum += small_N ? term : Math.exp(term);
            xb -= 1.0;
            NR -= 1.0;
        }
        return xr;
    }

    static final double afc(int i) {
        double[] al = new double[]{0.0, 0.0, 0.6931471805599453, 1.791759469228055, 3.1780538303479458, 4.787491742782046, 6.579251212010101, 8.525161361065415};
        if (i < 0) {
            return -1.0;
        }
        if (i <= 7) {
            return al[i];
        }
        double di = i;
        double i2 = di * di;
        return (di + 0.5) * Math.log(di) - di + 0.9189385332046728 + (0.0833333333333333 - 0.00277777777777778 / i2) / di;
    }

    public static final double random(double nn1in, double nn2in, double kkin, RandomEngine random) {
        return HyperGeometric.random(nn1in, nn2in, kkin, random, null);
    }

    /*
     * Exception decompiling
     */
    public static final double random(double nn1in, double nn2in, double kkin, RandomEngine random, RandomState state) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 1[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final double[] random(int n, double nn1in, double nn2in, double kkin, RandomEngine random, RandomState state) {
        if (state == null) {
            state = HyperGeometric.create_random_state();
        }
        double[] rand = new double[n];
        int i = 0;
        while (i < n) {
            rand[i] = HyperGeometric.random(nn1in, nn2in, kkin, random, state);
            ++i;
        }
        return rand;
    }

    public static final double[] random(int n, double nn1in, double nn2in, double kkin, RandomEngine random) {
        return HyperGeometric.random(n, nn1in, nn2in, kkin, random, HyperGeometric.create_random_state());
    }

    public HyperGeometric(double r, double b, double n) {
        this.r = r;
        this.b = b;
        this.n = n;
        this.state = HyperGeometric.create_random_state();
    }

    public double density(double x, boolean log) {
        return HyperGeometric.density(x, this.r, this.b, this.n, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return HyperGeometric.cumulative(p, this.r, this.b, this.n, lower_tail, log_p);
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return HyperGeometric.quantile(q, this.r, this.b, this.n, lower_tail, log_p);
    }

    public double random() {
        return HyperGeometric.random(this.r, this.b, this.n, this.random, this.state);
    }

    public double[] random(int ct) {
        return HyperGeometric.random(ct, this.r, this.b, this.n, this.random, this.state);
    }

    public static class RandomState {
        public int ks = -1;
        public int n1s = -1;
        public int n2s = -1;
        public int k;
        public int m;
        public int minjx;
        public int maxjx;
        public int n1;
        public int n2;
        public double tn;
        public double w;
        public double a;
        public double d;
        public double s;
        public double xl;
        public double xr;
        public double kl;
        public double kr;
        public double lamdl;
        public double lamdr;
        public double p1;
        public double p2;
        public double p3;
    }
}

