/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.SortingCollection;
import java.util.Comparator;
import java.util.Iterator;

public class SortingIteratorFactory {
    public static <T> CloseableIterator<T> create(Class<T> componentType, Iterator<T> underlyingIterator, Comparator<T> comparator, SortingCollection.Codec<T> codec, int maxRecordsInRam, ProgressCallback progressLogger) {
        SortingCollection sortingCollection = SortingCollection.newInstance(componentType, codec, comparator, (int)maxRecordsInRam);
        while (underlyingIterator.hasNext()) {
            T rec = underlyingIterator.next();
            if (progressLogger != null) {
                progressLogger.logProgress(rec);
            }
            sortingCollection.add(rec);
        }
        CloseableIterator ret = sortingCollection.iterator();
        CloserUtil.close(underlyingIterator);
        return ret;
    }

    public static interface ProgressCallback<T> {
        public void logProgress(T var1);
    }
}

