/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.iterator;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import org.la4j.iterator.JoinFunction;

abstract class CursorIterator
implements Iterator<Double> {
    private static final Collection<IteratorState> TAKEN_FROM_BOTH = Arrays.asList(IteratorState.TAKEN_FROM_THESE, IteratorState.TAKEN_FROM_THOSE);

    CursorIterator() {
    }

    public abstract double get();

    public abstract void set(double var1);

    protected abstract int cursor();

    protected CursorIterator orElse(final CursorIterator those, final JoinFunction function) {
        final CursorIterator these = this;
        return new CursorIterator(){
            private final EnumSet<IteratorState> state = EnumSet.copyOf(CursorIterator.access$000());

            @Override
            public int cursor() {
                if (this.state.contains((Object)IteratorState.TAKEN_FROM_THESE)) {
                    return these.cursor();
                }
                return those.cursor();
            }

            @Override
            public double get() {
                if (this.state.contains((Object)IteratorState.TAKEN_FROM_THESE) && this.state.contains((Object)IteratorState.TAKEN_FROM_THOSE)) {
                    return function.apply(these.get(), those.get());
                }
                if (this.state.contains((Object)IteratorState.TAKEN_FROM_THESE)) {
                    return function.apply(these.get(), 0.0);
                }
                return function.apply(0.0, those.get());
            }

            @Override
            public void set(double value) {
                throw new UnsupportedOperationException("Composed iterators are read-only for now.");
            }

            @Override
            public boolean hasNext() {
                if (these.hasNext() || those.hasNext()) {
                    return true;
                }
                if (this.state.contains((Object)IteratorState.TAKEN_FROM_THESE) && this.state.contains((Object)IteratorState.THOSE_ARE_EMPTY)) {
                    return false;
                }
                if (this.state.contains((Object)IteratorState.TAKEN_FROM_THOSE) && this.state.contains((Object)IteratorState.THESE_ARE_EMPTY)) {
                    return false;
                }
                return !this.state.containsAll(TAKEN_FROM_BOTH);
            }

            @Override
            public Double next() {
                if (this.state.contains((Object)IteratorState.TAKEN_FROM_THESE)) {
                    if (these.hasNext()) {
                        these.next();
                    } else {
                        this.state.add(IteratorState.THESE_ARE_EMPTY);
                    }
                }
                if (this.state.contains((Object)IteratorState.TAKEN_FROM_THOSE)) {
                    if (those.hasNext()) {
                        those.next();
                    } else {
                        this.state.add(IteratorState.THOSE_ARE_EMPTY);
                    }
                }
                this.state.remove((Object)IteratorState.TAKEN_FROM_THESE);
                this.state.remove((Object)IteratorState.TAKEN_FROM_THOSE);
                if (!this.state.contains((Object)IteratorState.THESE_ARE_EMPTY) && !this.state.contains((Object)IteratorState.THOSE_ARE_EMPTY)) {
                    if (these.cursor() < those.cursor()) {
                        this.state.add(IteratorState.TAKEN_FROM_THESE);
                    } else if (these.cursor() > those.cursor()) {
                        this.state.add(IteratorState.TAKEN_FROM_THOSE);
                    } else {
                        this.state.add(IteratorState.TAKEN_FROM_THESE);
                        this.state.add(IteratorState.TAKEN_FROM_THOSE);
                    }
                } else if (this.state.contains((Object)IteratorState.THESE_ARE_EMPTY)) {
                    this.state.add(IteratorState.TAKEN_FROM_THOSE);
                } else if (this.state.contains((Object)IteratorState.THOSE_ARE_EMPTY)) {
                    this.state.add(IteratorState.TAKEN_FROM_THESE);
                }
                return this.get();
            }
        };
    }

    protected CursorIterator andAlso(final CursorIterator those, final JoinFunction function) {
        final CursorIterator these = this;
        return new CursorIterator(){
            private boolean hasNext;
            private double prevValue;
            private double currValue;
            private int prevCursor;
            private int currCursor;
            {
                this.doNext();
            }

            @Override
            public int cursor() {
                return this.prevCursor;
            }

            private void doNext() {
                this.hasNext = false;
                this.prevValue = this.currValue;
                this.prevCursor = this.currCursor;
                if (these.hasNext() && those.hasNext()) {
                    these.next();
                    those.next();
                    while (these.cursor() != those.cursor()) {
                        if (these.cursor() < those.cursor() && these.hasNext()) {
                            these.next();
                            continue;
                        }
                        if (these.cursor() > those.cursor() && those.hasNext()) {
                            those.next();
                            continue;
                        }
                        return;
                    }
                    this.hasNext = true;
                    this.currValue = function.apply(these.get(), those.get());
                    this.currCursor = these.cursor();
                }
            }

            @Override
            public double get() {
                return this.prevValue;
            }

            @Override
            public void set(double value) {
                throw new UnsupportedOperationException("Composed iterators are read-only for now.");
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Double next() {
                this.doNext();
                return this.get();
            }
        };
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This will be supported in 0.6.0.");
    }

    private static enum IteratorState {
        TAKEN_FROM_THESE,
        TAKEN_FROM_THOSE,
        THESE_ARE_EMPTY,
        THOSE_ARE_EMPTY;

    }
}

