/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.beadsynthesis;

import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.List;
import org.broadinstitute.dropseqrna.barnyard.BarcodeListRetrieval;
import org.broadinstitute.dropseqrna.barnyard.ParseBarcodeFile;
import org.broadinstitute.dropseqrna.utils.readiterators.SamFileMergeUtil;
import org.broadinstitute.dropseqrna.utils.readiterators.UMIIterator;

public class BiasedBarcodeCollectionFactory {
    private static final Log log = Log.getInstance(BiasedBarcodeCollectionFactory.class);
    private SamReaderFactory samReaderFactory = SamReaderFactory.makeDefault().enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.EAGERLY_DECODE});

    public UMIIterator prepareUMIIterator(List<File> inputFiles, String geneExonTag, String cellBarcodeTag, String molBCTag, String strandTag, int readMQ, List<String> cellBarcodes) {
        return new UMIIterator(SamFileMergeUtil.mergeInputs(inputFiles, false, this.samReaderFactory), geneExonTag, cellBarcodeTag, molBCTag, strandTag, readMQ, false, false, cellBarcodes, true);
    }

    public List<String> getCellBarcodes(List<File> inputFiles, File cellBarcodeFile, int numBarcodes, String cellBarcodeTag, int readMQ) {
        if (cellBarcodeFile != null) {
            IOUtil.assertFileIsReadable((File)cellBarcodeFile);
            List<String> cellBarcodes = ParseBarcodeFile.readCellBarcodeFile(cellBarcodeFile);
            log.info(new Object[]{"Found " + cellBarcodes.size() + " cell barcodes in file"});
            return cellBarcodes;
        }
        log.info(new Object[]{"Gathering barcodes for the top [" + numBarcodes + "] cells"});
        return new BarcodeListRetrieval().getListCellBarcodesByReadCount(SamFileMergeUtil.mergeInputs(inputFiles, (boolean)false, (SamReaderFactory)this.samReaderFactory).iterator, cellBarcodeTag, readMQ, null, (Integer)numBarcodes);
    }
}

