/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.alignment.routines;

import org.biojava.nbio.alignment.routines.AnchoredPairwiseSequenceAligner;
import org.biojava.nbio.alignment.template.GapPenalty;
import org.biojava.nbio.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.Sequence;

public class GuanUberbacher<S extends Sequence<C>, C extends Compound>
extends AnchoredPairwiseSequenceAligner<S, C> {
    private static int defaultCutsPerSection = 10;

    public static void setDefaultCutsPerSection(int defaultCutsPerSection) {
        defaultCutsPerSection = Math.max(1, defaultCutsPerSection);
    }

    public GuanUberbacher() {
        GuanUberbacher.setDefaultCutsPerSection(defaultCutsPerSection);
    }

    public GuanUberbacher(S query, S target, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        super(query, target, gapPenalty, subMatrix);
        GuanUberbacher.setDefaultCutsPerSection(defaultCutsPerSection);
    }

    public GuanUberbacher(S query, S target, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix, int cutsPerSection) {
        super(query, target, gapPenalty, subMatrix);
        this.setCutsPerSection(cutsPerSection);
    }

    public int getCutsPerSection() {
        return this.cutsPerSection;
    }

    public void setCutsPerSection(int cutsPerSection) {
        this.cutsPerSection = Math.max(1, cutsPerSection);
    }
}

