/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.math.opt;

import jdistlib.math.MultivariableFunction;
import jdistlib.math.opt.BobyqaConfig;
import jdistlib.math.opt.MultivariateOptimization;
import jdistlib.math.opt.OptimizationConfig;
import jdistlib.math.opt.OptimizationResult;

public class Bobyqa
extends MultivariateOptimization {
    public OptimizationResult optimize(OptimizationConfig cfg) {
        BobyqaConfig bcfg = null;
        bcfg = cfg instanceof BobyqaConfig ? (BobyqaConfig)cfg : new BobyqaConfig(cfg);
        return Bobyqa.bobyqa(bcfg.initialGuess, bcfg.lowerBound, bcfg.upperBound, bcfg.objectiveFunction, bcfg.maxNumFunctionCall, bcfg.initialTrustRegionRadius, bcfg.stoppingTrustRegionRadius, bcfg.numInterpolationPoints, bcfg.isMinimize);
    }

    public static final OptimizationResult bobyqa(double[] x, double[] xl, double[] xu, MultivariableFunction calfun, int npt, double rhobeg, double rhoend, int maxfun, boolean isMinimize) {
        double rho;
        int n = x.length;
        int np = n + 1;
        int ndim = npt + n;
        int toRescue = 190;
        if (xl.length != n || xu.length != n) {
            throw new RuntimeException();
        }
        if (npt < n + 2 || npt > (n + 2) * np / 2) {
            throw new RuntimeException("Return from BOBYQA because NPT is not in the required interval");
        }
        double[] origx = x;
        double[] xbase = new double[n];
        double[][] xpt = new double[npt][n];
        double[] fval = new double[npt];
        double[] xopt = new double[n];
        double[] gopt = new double[n];
        double[] hq = new double[n * np / 2];
        double[] pq = new double[npt];
        double[][] bmat = new double[ndim][n];
        double[][] zmat = new double[npt][npt - np];
        double[] sl = new double[n];
        double[] su = new double[n];
        double[] xnew = new double[n];
        double[] xalt = new double[n];
        double[] d = new double[n];
        double[] vlag = new double[ndim];
        double[] work1 = new double[n];
        double[] work2 = new double[npt];
        double[] work3 = new double[npt];
        x = new double[n];
        System.arraycopy(origx, 0, x, 0, n);
        double two_rhobeg = 2.0 * rhobeg;
        int j = 0;
        while (j < n) {
            double temp = xu[j] - xl[j];
            if (temp < two_rhobeg) {
                throw new RuntimeException("Return from BOBYQA because one of the differences xu[i]-xl[i] is less than 2*RHOBEG");
            }
            sl[j] = xl[j] - x[j];
            su[j] = xu[j] - x[j];
            if (sl[j] >= -rhobeg) {
                if (sl[j] >= 0.0) {
                    x[j] = xl[j];
                    sl[j] = 0.0;
                    su[j] = temp;
                } else {
                    x[j] = xl[j] + rhobeg;
                    sl[j] = -rhobeg;
                    su[j] = Math.max(xu[j] - x[j], rhobeg);
                }
            } else if (su[j] <= rhobeg) {
                if (su[j] <= 0.0) {
                    x[j] = xu[j];
                    sl[j] = -temp;
                    su[j] = 0.0;
                } else {
                    x[j] = xu[j] - rhobeg;
                    sl[j] = Math.min(xl[j] - x[j], -rhobeg);
                    su[j] = rhobeg;
                }
            }
            ++j;
        }
        double[] gnew = new double[n];
        int nf = 0;
        int kopt = 0;
        int nptm = npt - np;
        int nh = n * np / 2;
        int[] temp = Bobyqa.prelim(x, xl, xu, calfun, rhobeg, maxfun, xbase, xpt, fval, gopt, hq, pq, bmat, zmat, sl, su, isMinimize);
        nf = temp[0];
        kopt = temp[1];
        double xoptsq = 0.0;
        double fsave = fval[0];
        double alpha = 0.0;
        double cauchy = 0.0;
        double adelt = 0.0;
        double beta = 0.0;
        double f = 0.0;
        double denom = 0.0;
        double den = 0.0;
        double ratio = 0.0;
        boolean loop = true;
        int i = 0;
        while (i < n) {
            double val = xopt[i] = xpt[kopt][i];
            xoptsq += val * val;
            ++i;
        }
        if (nf < npt) {
            loop = false;
        }
        int kbase = 0;
        int knew = -1;
        double delta = rho = rhobeg;
        double diffa = 0.0;
        double diffb = 0.0;
        double diffc = 0.0;
        int nresc = nf;
        int ntrits = 0;
        int nfsav = nf;
        int itest = 0;
        int label = 20;
        double dsq = 0.0;
        double crvmin = 0.0;
        double dnorm = 0.0;
        double distsq = 0.0;
        while (loop) {
            switch (label) {
                case 20: {
                    if (kopt != kbase) {
                        int ih = 0;
                        int j2 = 0;
                        while (j2 < n) {
                            int i2 = 0;
                            while (i2 <= j2) {
                                if (i2 < j2) {
                                    gopt[j2] = gopt[j2] + hq[ih] * xopt[i2];
                                }
                                gopt[i2] = gopt[i2] + hq[ih] * xopt[j2];
                                ++ih;
                                ++i2;
                            }
                            ++j2;
                        }
                        if (nf > npt) {
                            int k = 0;
                            while (k < npt) {
                                double temp2 = 0.0;
                                int j3 = 0;
                                while (j3 < n) {
                                    temp2 += xpt[k][j3] * xopt[j3];
                                    ++j3;
                                }
                                temp2 = pq[k] * temp2;
                                int i3 = 0;
                                while (i3 < n) {
                                    gopt[i3] = gopt[i3] + temp2 * xpt[k][i3];
                                    ++i3;
                                }
                                ++k;
                            }
                        }
                    }
                    label = 60;
                    break;
                }
                case 60: {
                    double[] temp3 = Bobyqa.trsbox(xpt, xopt, gopt, hq, pq, sl, su, delta, xnew, d, gnew, dsq, crvmin);
                    dsq = temp3[0];
                    crvmin = temp3[1];
                    dnorm = Math.min(delta, Math.sqrt(dsq));
                    if (dnorm < 0.5 * rho) {
                        ntrits = -1;
                        distsq = 100.0 * rho * rho;
                        if (nf <= nfsav + 2) {
                            label = 650;
                            break;
                        }
                        double errbig = Math.max(Math.max(diffa, diffb), diffc);
                        if (crvmin > 0.0 && errbig > 0.125 * rho * rho * crvmin) {
                            label = 650;
                            break;
                        }
                        double bdtol = errbig / rho;
                        int j4 = 0;
                        while (j4 < n) {
                            double bdtest = bdtol;
                            if (xnew[j4] == sl[j4]) {
                                bdtest = work1[j4];
                            }
                            if (xnew[j4] == su[j4]) {
                                bdtest = -work1[j4];
                            }
                            if (bdtest < bdtol) {
                                int jp1 = j4 + 1;
                                double curv = hq[(jp1 + jp1 * jp1) / 2 - 1];
                                int k = 0;
                                while (k < npt) {
                                    double val = xpt[k][j4];
                                    curv += pq[k] * val * val;
                                    ++k;
                                }
                                if ((bdtest += 0.5 * curv * rho) < bdtol) {
                                    label = 650;
                                    break;
                                }
                            }
                            ++j4;
                        }
                        label = 680;
                        break;
                    }
                    ++ntrits;
                    label = 90;
                    break;
                }
                case 90: {
                    if (dsq <= 0.001 * xoptsq) {
                        int i4;
                        double fracsq = 0.25 * xoptsq;
                        double sumpq = 0.0;
                        int k = 0;
                        while (k < npt) {
                            sumpq += pq[k];
                            double sum = -0.5 * xoptsq;
                            int i5 = 0;
                            while (i5 < n) {
                                sum += xpt[k][i5] * xopt[i5];
                                ++i5;
                            }
                            work2[k] = sum;
                            double temp4 = fracsq - 0.5 * sum;
                            i4 = 0;
                            while (i4 < n) {
                                work1[i4] = bmat[k][i4];
                                vlag[i4] = sum * xpt[k][i4] + temp4 * xopt[i4];
                                int ip = npt + i4;
                                int j5 = 0;
                                while (j5 <= i4) {
                                    bmat[ip][j5] = bmat[ip][j5] + work1[i4] * vlag[j5] + vlag[i4] * work1[j5];
                                    ++j5;
                                }
                                ++i4;
                            }
                            ++k;
                        }
                        int jj = 0;
                        while (jj < nptm) {
                            double sumz = 0.0;
                            double sumw = 0.0;
                            int k2 = 0;
                            while (k2 < npt) {
                                sumz += zmat[k2][jj];
                                vlag[k2] = work2[k2] * zmat[k2][jj];
                                sumw += vlag[k2];
                                ++k2;
                            }
                            int j6 = 0;
                            while (j6 < n) {
                                double sum = (fracsq * sumz - 0.5 * sumw) * xopt[j6];
                                int k3 = 0;
                                while (k3 < npt) {
                                    sum += vlag[k3] * xpt[k3][j6];
                                    ++k3;
                                }
                                work1[j6] = sum;
                                k3 = 0;
                                while (k3 < npt) {
                                    bmat[k3][j6] = bmat[k3][j6] + sum * zmat[k3][jj];
                                    ++k3;
                                }
                                ++j6;
                            }
                            i4 = 0;
                            while (i4 < n) {
                                int ip = i4 + npt;
                                double temp5 = work1[i4];
                                int j7 = 0;
                                while (j7 <= i4) {
                                    bmat[ip][j7] = bmat[ip][j7] + temp5 * work1[j7];
                                    ++j7;
                                }
                                ++i4;
                            }
                            ++jj;
                        }
                        int ih = 0;
                        int j8 = 0;
                        while (j8 < n) {
                            work1[j8] = -0.5 * sumpq * xopt[j8];
                            int k4 = 0;
                            while (k4 < npt) {
                                work1[j8] = work1[j8] + pq[k4] * xpt[k4][j8];
                                xpt[k4][j8] = xpt[k4][j8] - xopt[j8];
                                ++k4;
                            }
                            int i6 = 0;
                            while (i6 <= j8) {
                                hq[ih] = hq[ih] + work1[i6] * xopt[j8] + xopt[i6] * work1[j8];
                                bmat[npt + i6][j8] = bmat[npt + j8][i6];
                                ++ih;
                                ++i6;
                            }
                            ++j8;
                        }
                        int i7 = 0;
                        while (i7 < n) {
                            double xopti = xopt[i7];
                            xbase[i7] = xbase[i7] + xopti;
                            xnew[i7] = xnew[i7] - xopti;
                            sl[i7] = sl[i7] - xopti;
                            su[i7] = su[i7] - xopti;
                            xopt[i7] = 0.0;
                            ++i7;
                        }
                        xoptsq = 0.0;
                    }
                    label = ntrits == 0 ? 210 : 230;
                    break;
                }
                case 190: {
                    nfsav = nf;
                    kbase = kopt;
                    int[] temp6 = Bobyqa.rescue(xl, xu, calfun, maxfun, xbase, xpt, fval, xopt, gopt, hq, pq, bmat, zmat, sl, su, nf, delta, kopt, vlag, isMinimize);
                    nf = temp6[0];
                    kopt = temp6[1];
                    xoptsq = 0.0;
                    if (kopt != kbase) {
                        int i8 = 0;
                        while (i8 < n) {
                            double val = xopt[i8] = xpt[kopt][i8];
                            xoptsq += val * val;
                            ++i8;
                        }
                    }
                    if (nf < 0) {
                        nf = maxfun;
                        loop = false;
                        label = 720;
                        break;
                    }
                    nresc = nf;
                    if (nfsav < nf) {
                        nfsav = nf;
                        label = 20;
                        break;
                    }
                    if (ntrits > 0) {
                        label = 60;
                        break;
                    }
                    label = 210;
                    break;
                }
                case 210: {
                    double[] temp7 = Bobyqa.altmov(xpt, xopt, bmat, zmat, sl, su, kopt, knew, adelt, xnew, xalt);
                    alpha = temp7[0];
                    cauchy = temp7[1];
                    int i9 = 0;
                    while (i9 < n) {
                        d[i9] = xnew[i9] - xopt[i9];
                        ++i9;
                    }
                    label = 230;
                    break;
                }
                case 230: {
                    int k = 0;
                    while (k < npt) {
                        double suma = 0.0;
                        double sumb = 0.0;
                        double sum = 0.0;
                        int j9 = 0;
                        while (j9 < n) {
                            suma += xpt[k][j9] * d[j9];
                            sumb += xpt[k][j9] * xopt[j9];
                            sum += bmat[k][j9] * d[j9];
                            ++j9;
                        }
                        work3[k] = suma * (0.5 * suma + sumb);
                        vlag[k] = sum;
                        work2[k] = suma;
                        ++k;
                    }
                    beta = 0.0;
                    int jj = 0;
                    while (jj < nptm) {
                        double sum = 0.0;
                        int k5 = 0;
                        while (k5 < npt) {
                            sum += zmat[k5][jj] * work3[k5];
                            ++k5;
                        }
                        beta -= sum * sum;
                        k5 = 0;
                        while (k5 < npt) {
                            vlag[k5] = vlag[k5] + sum * zmat[k5][jj];
                            ++k5;
                        }
                        ++jj;
                    }
                    dsq = 0.0;
                    double bsum = 0.0;
                    double dx = 0.0;
                    int j10 = 0;
                    while (j10 < n) {
                        double val = d[j10];
                        dsq += val * val;
                        double sum = 0.0;
                        int k6 = 0;
                        while (k6 < npt) {
                            sum += work3[k6] * bmat[k6][j10];
                            ++k6;
                        }
                        bsum += sum * d[j10];
                        int jp = npt + j10;
                        int i10 = 0;
                        while (i10 < n) {
                            sum += bmat[jp][i10] * d[i10];
                            ++i10;
                        }
                        vlag[jp] = sum;
                        bsum += sum * d[j10];
                        dx += d[j10] * xopt[j10];
                        ++j10;
                    }
                    beta = dx * dx + dsq * (xoptsq + dx + dx + 0.5 * dsq) + beta - bsum;
                    vlag[kopt] = vlag[kopt] + 1.0;
                    if (ntrits == 0) {
                        double val = vlag[knew];
                        denom = val * val + alpha * beta;
                        if (denom < cauchy && cauchy > 0.0) {
                            int i11 = 0;
                            while (i11 < n) {
                                xnew[i11] = xalt[i11];
                                d[i11] = xnew[i11] - xopt[i11];
                                ++i11;
                            }
                            cauchy = 0.0;
                            label = 230;
                            break;
                        }
                        if (denom <= 0.5 * val * val) {
                            if (nf > nresc) {
                                label = 190;
                                break;
                            }
                            loop = false;
                            label = 720;
                            break;
                        }
                    } else {
                        double delsq = delta * delta;
                        double scaden = 0.0;
                        double biglsq = 0.0;
                        knew = -1;
                        int k7 = 0;
                        while (k7 < npt) {
                            if (k7 != kopt) {
                                double val;
                                double hdiag = 0.0;
                                int jj2 = 0;
                                while (jj2 < nptm) {
                                    val = zmat[k7][jj2];
                                    hdiag += val * val;
                                    ++jj2;
                                }
                                val = vlag[k7];
                                den = beta * hdiag + val * val;
                                distsq = 0.0;
                                int j11 = 0;
                                while (j11 < n) {
                                    val = xpt[k7][j11] - xopt[j11];
                                    distsq += val * val;
                                    ++j11;
                                }
                                val = distsq / delsq;
                                double temp8 = Math.max(1.0, val * val);
                                if (temp8 * den > scaden) {
                                    scaden = temp8 * den;
                                    knew = k7;
                                    denom = den;
                                }
                                val = vlag[k7];
                                biglsq = Math.max(biglsq, temp8 * val * val);
                            }
                            ++k7;
                        }
                        if (scaden <= 0.5 * biglsq) {
                            if (nf > nresc) {
                                label = 190;
                                break;
                            }
                            loop = false;
                            label = 720;
                            break;
                        }
                    }
                    label = 360;
                    break;
                }
                case 360: {
                    int j12;
                    double temp9;
                    int k;
                    int i12 = 0;
                    while (i12 < n) {
                        x[i12] = Math.min(Math.max(xl[i12], xbase[i12] + xnew[i12]), xu[i12]);
                        if (xnew[i12] == sl[i12]) {
                            x[i12] = xl[i12];
                        }
                        if (xnew[i12] == su[i12]) {
                            x[i12] = xu[i12];
                        }
                        ++i12;
                    }
                    if (nf >= maxfun) {
                        loop = false;
                        label = 720;
                        break;
                    }
                    ++nf;
                    double d2 = f = isMinimize ? calfun.eval(x) : -calfun.eval(x);
                    if (ntrits == -1) {
                        fsave = f;
                        loop = false;
                        label = 720;
                        break;
                    }
                    double fopt = fval[kopt];
                    double vquad = 0.0;
                    int ih = 0;
                    int j13 = 0;
                    while (j13 < n) {
                        vquad += d[j13] * gopt[j13];
                        int i13 = 0;
                        while (i13 <= j13) {
                            double temp10 = d[i13] * d[j13];
                            if (i13 == j13) {
                                temp10 *= 0.5;
                            }
                            vquad += hq[ih] * temp10;
                            ++ih;
                            ++i13;
                        }
                        ++j13;
                    }
                    int k8 = 0;
                    while (k8 < npt) {
                        double val = work2[k8];
                        vquad += 0.5 * pq[k8] * val * val;
                        ++k8;
                    }
                    double diff = f - fopt - vquad;
                    diffc = diffb;
                    diffb = diffa;
                    diffa = Math.abs(diff);
                    if (dnorm > rho) {
                        nfsav = nf;
                    }
                    if (ntrits > 0) {
                        if (vquad >= 0.0) {
                            loop = false;
                            label = 720;
                            break;
                        }
                        ratio = (f - fopt) / vquad;
                        double d3 = ratio <= 0.1 ? Math.min(0.5 * delta, dnorm) : (delta = Math.max(0.5 * delta, ratio <= 0.7 ? dnorm : 2.0 * dnorm));
                        if (delta <= 1.5 * rho) {
                            delta = rho;
                        }
                        if (f < fopt) {
                            int ksav = knew;
                            double densav = denom;
                            double delsq = delta * delta;
                            double scaden = 0.0;
                            double biglsq = 0.0;
                            knew = -1;
                            k = 0;
                            while (k < npt) {
                                double val;
                                double hdiag = 0.0;
                                int jj = 0;
                                while (jj < nptm) {
                                    val = zmat[k][jj];
                                    hdiag += val * val;
                                    ++jj;
                                }
                                val = vlag[k];
                                den = beta * hdiag + val * val;
                                distsq = 0.0;
                                int j14 = 0;
                                while (j14 < n) {
                                    val = xpt[k][j14] - xnew[j14];
                                    distsq += val * val;
                                    ++j14;
                                }
                                val = distsq / delsq;
                                double temp11 = Math.max(1.0, val * val);
                                if (temp11 * den > scaden) {
                                    scaden = temp11 * den;
                                    knew = k;
                                    denom = den;
                                }
                                val = vlag[k];
                                biglsq = Math.max(biglsq, temp11 * val * val);
                                ++k;
                            }
                            if (scaden <= 0.5 * biglsq) {
                                knew = ksav;
                                denom = densav;
                            }
                        }
                    }
                    Bobyqa.update(bmat, zmat, vlag, beta, denom, knew);
                    ih = 0;
                    double pqold = pq[knew];
                    pq[knew] = 0.0;
                    int i14 = 0;
                    while (i14 < n) {
                        temp9 = pqold * xpt[knew][i14];
                        int j15 = 0;
                        while (j15 <= i14) {
                            hq[ih] = hq[ih] + temp9 * xpt[knew][j15];
                            ++ih;
                            ++j15;
                        }
                        ++i14;
                    }
                    int jj = 0;
                    while (jj < nptm) {
                        temp9 = diff * zmat[knew][jj];
                        int k9 = 0;
                        while (k9 < npt) {
                            pq[k9] = pq[k9] + temp9 * zmat[k9][jj];
                            ++k9;
                        }
                        ++jj;
                    }
                    fval[knew] = f;
                    i14 = 0;
                    while (i14 < n) {
                        xpt[knew][i14] = xnew[i14];
                        work1[i14] = bmat[knew][i14];
                        ++i14;
                    }
                    int k10 = 0;
                    while (k10 < npt) {
                        double suma = 0.0;
                        double sumb = 0.0;
                        int jj3 = 0;
                        while (jj3 < nptm) {
                            suma += zmat[knew][jj3] * zmat[k10][jj3];
                            ++jj3;
                        }
                        int j16 = 0;
                        while (j16 < n) {
                            sumb += xpt[k10][j16] * xopt[j16];
                            ++j16;
                        }
                        double temp12 = suma * sumb;
                        int i15 = 0;
                        while (i15 < n) {
                            work1[i15] = work1[i15] + temp12 * xpt[k10][i15];
                            ++i15;
                        }
                        ++k10;
                    }
                    i14 = 0;
                    while (i14 < n) {
                        gopt[i14] = gopt[i14] + diff * work1[i14];
                        ++i14;
                    }
                    if (f < fopt) {
                        kopt = knew;
                        xoptsq = 0.0;
                        ih = 0;
                        j12 = 0;
                        while (j12 < n) {
                            xopt[j12] = xnew[j12];
                            double val = xopt[j12];
                            xoptsq += val * val;
                            int i16 = 0;
                            while (i16 <= j12) {
                                if (i16 < j12) {
                                    gopt[j12] = gopt[j12] + hq[ih] * d[i16];
                                }
                                gopt[i16] = gopt[i16] + hq[ih] * d[j12];
                                ++ih;
                                ++i16;
                            }
                            ++j12;
                        }
                        k10 = 0;
                        while (k10 < npt) {
                            temp9 = 0.0;
                            int j17 = 0;
                            while (j17 < n) {
                                temp9 += xpt[k10][j17] * d[j17];
                                ++j17;
                            }
                            temp9 *= pq[k10];
                            int i17 = 0;
                            while (i17 < n) {
                                gopt[i17] = gopt[i17] + temp9 * xpt[k10][i17];
                                ++i17;
                            }
                            ++k10;
                        }
                    }
                    if (ntrits > 0) {
                        double sum;
                        k10 = 0;
                        while (k10 < npt) {
                            vlag[k10] = fval[k10] - fval[kopt];
                            work3[k10] = 0.0;
                            ++k10;
                        }
                        j12 = 0;
                        while (j12 < nptm) {
                            sum = 0.0;
                            int k11 = 0;
                            while (k11 < npt) {
                                sum += zmat[k11][j12] * vlag[k11];
                                ++k11;
                            }
                            k11 = 0;
                            while (k11 < npt) {
                                work3[k11] = work3[k11] + sum * zmat[k11][j12];
                                ++k11;
                            }
                            ++j12;
                        }
                        k10 = 0;
                        while (k10 < npt) {
                            sum = 0.0;
                            int j18 = 0;
                            while (j18 < n) {
                                sum += xpt[k10][j18] * xopt[j18];
                                ++j18;
                            }
                            work2[k10] = work3[k10];
                            work3[k10] = work3[k10] * sum;
                            ++k10;
                        }
                        double gqsq = 0.0;
                        double gisq = 0.0;
                        int i18 = 0;
                        while (i18 < n) {
                            double val;
                            double sum2 = 0.0;
                            k = 0;
                            while (k < npt) {
                                sum2 += bmat[k][i18] * vlag[k] + xpt[k][i18] * work3[k];
                                ++k;
                            }
                            if (xopt[i18] == sl[i18]) {
                                val = Math.min(0.0, gopt[i18]);
                                gqsq += val * val;
                                val = Math.min(0.0, sum2);
                                gisq += val * val;
                            } else if (xopt[i18] == su[i18]) {
                                val = Math.max(0.0, gopt[i18]);
                                gqsq += val * val;
                                val = Math.max(0.0, sum2);
                                gisq += val * val;
                            } else {
                                val = gopt[i18];
                                gqsq += val * val;
                                gisq += sum2 * sum2;
                            }
                            vlag[npt + i18] = sum2;
                            ++i18;
                        }
                        ++itest;
                        if (gqsq < 10.0 * gisq) {
                            itest = 0;
                        }
                        if (itest >= 3) {
                            int val = Math.max(npt, nh);
                            int i19 = 0;
                            while (i19 < val) {
                                if (i19 < n) {
                                    gopt[i19] = vlag[npt + i19];
                                }
                                if (i19 < npt) {
                                    pq[i19] = work2[i19];
                                }
                                if (i19 < nh) {
                                    hq[i19] = 0.0;
                                }
                                ++i19;
                            }
                            itest = 0;
                        }
                    }
                    if (ntrits == 0 || f <= fopt + 0.1 * vquad) {
                        label = 60;
                        break;
                    }
                    double v1 = 2.0 * delta;
                    double v2 = 10.0 * rho;
                    distsq = Math.max(v1 * v1, v2 * v2);
                    label = 650;
                    break;
                }
                case 650: {
                    knew = -1;
                    int k = 0;
                    while (k < npt) {
                        double sum = 0.0;
                        int j19 = 0;
                        while (j19 < n) {
                            double val = xpt[k][j19] - xopt[j19];
                            sum += val * val;
                            ++j19;
                        }
                        if (sum > distsq) {
                            knew = k;
                            distsq = sum;
                        }
                        ++k;
                    }
                    if (knew >= 0) {
                        double dist = Math.sqrt(distsq);
                        if (ntrits == -1 && (delta = Math.min(0.1 * delta, 0.5 * dist)) <= 1.5 * rho) {
                            delta = rho;
                        }
                        ntrits = 0;
                        adelt = Math.max(Math.min(0.1 * dist, delta), rho);
                        dsq = adelt * adelt;
                        label = 90;
                        break;
                    }
                    if (ntrits != -1 && (ratio > 0.0 || Math.max(delta, dnorm) > 0.0)) {
                        label = 60;
                        break;
                    }
                    label = 680;
                    break;
                }
                case 680: {
                    if (rho > rhoend) {
                        delta = 0.5 * rho;
                        ratio = rho / rhoend;
                        rho = ratio <= 16.0 ? rhoend : (ratio <= 250.0 ? Math.sqrt(ratio) * rhoend : 0.1 * rho);
                        delta = Math.max(delta, rho);
                        ntrits = 0;
                        nfsav = nf;
                        label = 60;
                        break;
                    }
                    if (ntrits == -1) {
                        label = 360;
                        break;
                    }
                    loop = false;
                    label = 720;
                }
            }
        }
        if (fval[kopt] <= fsave) {
            int i20 = 0;
            while (i20 < n) {
                x[i20] = Math.min(Math.max(xl[i20], xbase[i20] + xopt[i20]), xu[i20]);
                if (xopt[i20] == sl[i20]) {
                    x[i20] = xl[i20];
                }
                if (xopt[i20] == su[i20]) {
                    x[i20] = xu[i20];
                }
                ++i20;
            }
            f = fval[kopt];
        }
        return new OptimizationResult(x, f, nf, isMinimize);
    }

    private static final int[] prelim(double[] x, double[] xl, double[] xu, MultivariableFunction calfun, double rhobeg, int maxfun, double[] xbase, double[][] xpt, double[] fval, double[] gopt, double[] hq, double[] pq, double[][] bmat, double[][] zmat, double[] sl, double[] su, boolean isMinimize) {
        int kopt = 0;
        int n = x.length;
        int ndim = bmat.length;
        int npt = zmat.length;
        int mult = isMinimize ? 1 : -1;
        double rhosq = rhobeg * rhobeg;
        double recip = 1.0 / rhosq;
        double fbeg = 0.0;
        int np = n + 1;
        int nnpdiv2 = n * np / 2;
        int nptminnp = npt - np;
        int j = 0;
        while (j < n) {
            xbase[j] = x[j];
            int k = 0;
            while (k < npt) {
                xpt[k][j] = 0.0;
                ++k;
            }
            int i = 0;
            while (i < ndim) {
                bmat[i][j] = 0.0;
                ++i;
            }
            ++j;
        }
        int ih = 0;
        while (ih < nnpdiv2) {
            hq[ih] = 0.0;
            ++ih;
        }
        int k = 0;
        while (k < npt) {
            pq[k] = 0.0;
            int j2 = 0;
            while (j2 < nptminnp) {
                zmat[k][j2] = 0.0;
                ++j2;
            }
            ++k;
        }
        int nf = 0;
        int ipt = 0;
        int jpt = 0;
        double stepa = 0.0;
        double stepb = 0.0;
        do {
            double temp;
            int ih2;
            double f;
            int nfm = nf;
            int nfx = nf - n;
            ++nf;
            if (nfm <= 2 * n) {
                if (nfm >= 1 && nfm <= n) {
                    xpt[nf - 1][nfm - 1] = stepa = su[nfm - 1] == 0.0 ? -rhobeg : rhobeg;
                } else if (nfm > n) {
                    stepa = xpt[nf - n - 1][nfx - 1];
                    stepb = -rhobeg;
                    if (sl[nfx - 1] == 0.0) {
                        stepb = Math.min(2.0 * rhobeg, su[nfx - 1]);
                    }
                    if (su[nfx - 1] == 0.0) {
                        stepb = Math.max(-2.0 * rhobeg, sl[nfx - 1]);
                    }
                    xpt[nf - 1][nfx - 1] = stepb;
                }
            } else {
                int itemp = (nfm - np) / n;
                jpt = nfm - itemp * n - n;
                ipt = jpt + itemp;
                if (ipt > n) {
                    itemp = jpt;
                    jpt = ipt - n;
                    ipt = itemp;
                }
                xpt[nf - 1][ipt - 1] = xpt[ipt][ipt - 1];
                xpt[nf - 1][jpt - 1] = xpt[jpt][jpt - 1];
            }
            int j3 = 0;
            while (j3 < n) {
                x[j3] = Math.min(Math.max(xl[j3], xbase[j3] + xpt[nf - 1][j3]), xu[j3]);
                if (xpt[nf - 1][j3] == sl[j3]) {
                    x[j3] = xl[j3];
                }
                if (xpt[nf - 1][j3] == su[j3]) {
                    x[j3] = xu[j3];
                }
                ++j3;
            }
            fval[nf - 1] = f = calfun.eval(x) * (double)mult;
            if (nf == 1) {
                fbeg = f;
                kopt = 1;
            } else if (f < fval[kopt - 1]) {
                kopt = nf;
            }
            if (nf <= 2 * n + 1) {
                if (nf >= 2 && nf <= n + 1) {
                    gopt[nfm - 1] = (f - fbeg) / stepa;
                    if (npt >= nf + n) continue;
                    bmat[0][nfm - 1] = -1.0 / stepa;
                    bmat[nf - 1][nfm - 1] = 1.0 / stepa;
                    bmat[npt + nfm - 1][nfm - 1] = -0.5 * rhosq;
                    continue;
                }
                if (nf < n + 2) continue;
                ih2 = nfx * (nfx + 1) / 2;
                temp = (f - fbeg) / stepb;
                double diff = stepb - stepa;
                hq[ih2 - 1] = 2.0 * (temp - gopt[nfx - 1]) / diff;
                gopt[nfx - 1] = (gopt[nfx - 1] * stepb - temp * stepa) / diff;
                if (stepa * stepb < 0.0 && f < fval[nf - n - 1]) {
                    fval[nf - 1] = fval[nf - n - 1];
                    fval[nf - n - 1] = f;
                    if (kopt == nf) {
                        kopt = nf - n;
                    }
                    xpt[nf - n - 1][nfx - 1] = stepb;
                    xpt[nf - 1][nfx - 1] = stepa;
                }
                bmat[0][nfx - 1] = -(stepa + stepb) / (stepa * stepb);
                bmat[nf - 1][nfx - 1] = -0.5 / xpt[nf - n - 1][nfx - 1];
                bmat[nf - n - 1][nfx - 1] = -bmat[0][nfx - 1] - bmat[nf - 1][nfx - 1];
                zmat[0][nfx - 1] = Math.sqrt(2.0) / (stepa * stepb);
                zmat[nf - 1][nfx - 1] = Math.sqrt(0.5) / rhosq;
                zmat[nf - n - 1][nfx - 1] = -zmat[0][nfx - 1] - zmat[nf - 1][nfx - 1];
                continue;
            }
            ih2 = ipt * (ipt - 1) / 2 + jpt;
            double d = recip;
            zmat[nf - 1][nfx - 1] = d;
            zmat[0][nfx - 1] = d;
            double d2 = -recip;
            zmat[jpt][nfx - 1] = d2;
            zmat[ipt][nfx - 1] = d2;
            temp = xpt[nf - 1][ipt - 1] * xpt[nf - 1][jpt - 1];
            hq[ih2 - 1] = (fbeg - fval[ipt] - fval[jpt] + f) / temp;
        } while (nf < npt && nf < maxfun);
        return new int[]{nf, kopt - 1};
    }

    private static final void update(double[][] bmat, double[][] zmat, double[] vlag, double beta, double denom, int knew) {
        int ndim = bmat.length;
        int n = bmat[0].length;
        int npt = zmat.length;
        int nptm = npt - n - 1;
        double ztest = 0.0;
        double[] w = new double[ndim];
        int k = 0;
        while (k < npt) {
            int j = 0;
            while (j < nptm) {
                ztest = Math.max(ztest, Math.abs(zmat[k][j]));
                ++j;
            }
            ++k;
        }
        ztest *= 1.0E-20;
        int j = 1;
        while (j < nptm) {
            if (Math.abs(zmat[knew][j]) > ztest) {
                double tempa = zmat[knew][0];
                double tempb = zmat[knew][j];
                double temp = Math.sqrt(tempa * tempa + tempb * tempb);
                tempa /= temp;
                tempb /= temp;
                int i = 0;
                while (i < npt) {
                    temp = tempa * zmat[i][0] + tempb * zmat[i][j];
                    zmat[i][j] = tempa * zmat[i][j] - tempb * zmat[i][0];
                    zmat[i][0] = temp;
                    ++i;
                }
            }
            zmat[knew][j] = 0.0;
            ++j;
        }
        int i = 0;
        while (i < npt) {
            w[i] = zmat[knew][0] * zmat[i][0];
            ++i;
        }
        double alpha = w[knew];
        double tau = vlag[knew];
        double temp = Math.sqrt(denom);
        double tempb = zmat[knew][0] / temp;
        double tempa = tau / temp;
        vlag[knew] = vlag[knew] - 1.0;
        int i2 = 0;
        while (i2 < npt) {
            zmat[i2][0] = tempa * zmat[i2][0] - tempb * vlag[i2];
            ++i2;
        }
        int j2 = 0;
        while (j2 < n) {
            int jp = npt + j2;
            w[jp] = bmat[knew][j2];
            tempa = (alpha * vlag[jp] - tau * w[jp]) / denom;
            tempb = (-beta * w[jp] - tau * vlag[jp]) / denom;
            int i3 = 0;
            while (i3 <= jp) {
                bmat[i3][j2] = bmat[i3][j2] + tempa * vlag[i3] + tempb * w[i3];
                if (i3 >= npt) {
                    bmat[jp][i3 - npt] = bmat[i3][j2];
                }
                ++i3;
            }
            ++j2;
        }
    }

    private static final int[] rescue(double[] xl, double[] xu, MultivariableFunction calfun, int maxfun, double[] xbase, double[][] xpt, double[] fval, double[] xopt, double[] gopt, double[] hq, double[] pq, double[][] bmat, double[][] zmat, double[] sl, double[] su, int nf, double delta, int kopt, double[] vlag, boolean isMinimize) {
        int ip;
        int j;
        double temp;
        int i;
        int j2;
        int n = xl.length;
        int ndim = bmat.length;
        int npt = xpt.length;
        int np = n + 1;
        int mult = isMinimize ? 1 : -1;
        int nptm = npt - np;
        assert (npt == zmat.length);
        double sfrac = 0.5 / (double)np;
        double beta = 0.0;
        double denom = 0.0;
        double[][] ptsaux = new double[2][n];
        double[] ptsid = new double[npt];
        double[] w = new double[ndim + npt];
        double sumpq = 0.0;
        double winc = 0.0;
        int k = 0;
        while (k < npt) {
            double distsq = 0.0;
            j2 = 0;
            while (j2 < n) {
                xpt[k][j2] = xpt[k][j2] - xopt[j2];
                double temp2 = xpt[k][j2];
                distsq += temp2 * temp2;
                ++j2;
            }
            sumpq += pq[k];
            w[ndim + k] = distsq;
            winc = Math.max(winc, distsq);
            j2 = 0;
            while (j2 < nptm) {
                zmat[k][j2] = 0.0;
                ++j2;
            }
            ++k;
        }
        int ih = 0;
        int j3 = 0;
        while (j3 < n) {
            w[j3] = 0.5 * sumpq * xopt[j3];
            int k2 = 0;
            while (k2 < npt) {
                w[j3] = w[j3] + pq[k2] * xpt[k2][j3];
                ++k2;
            }
            i = 0;
            while (i <= j3) {
                hq[ih] = hq[ih] + w[i] * xopt[j3] + w[j3] * xopt[i];
                ++ih;
                ++i;
            }
            ++j3;
        }
        j3 = 0;
        while (j3 < n) {
            xbase[j3] = xbase[j3] + xopt[j3];
            sl[j3] = sl[j3] - xopt[j3];
            su[j3] = su[j3] - xopt[j3];
            xopt[j3] = 0.0;
            ptsaux[0][j3] = Math.min(delta, su[j3]);
            ptsaux[1][j3] = Math.max(-delta, sl[j3]);
            if (ptsaux[0][j3] + ptsaux[1][j3] < 0.0) {
                double temp3 = ptsaux[0][j3];
                ptsaux[0][j3] = ptsaux[1][j3];
                ptsaux[1][j3] = temp3;
            }
            if (Math.abs(ptsaux[1][j3]) < 0.5 * Math.abs(ptsaux[0][j3])) {
                ptsaux[1][j3] = 0.5 * ptsaux[0][j3];
            }
            i = 0;
            while (i < ndim) {
                bmat[i][j3] = 0.0;
                ++i;
            }
            ++j3;
        }
        double fbase = fval[kopt];
        ptsid[0] = sfrac;
        j2 = 0;
        while (j2 < n) {
            int jp = j2 + 1;
            int jpn = jp + n;
            double ptsaux1j = ptsaux[0][j2];
            double ptsaux2j = ptsaux[1][j2];
            ptsid[jp] = (double)j2 + sfrac;
            if (jpn < npt) {
                ptsid[jpn] = (double)j2 * 1.0 / (double)np + sfrac;
                double temp4 = 1.0 / (ptsaux1j - ptsaux2j);
                bmat[jp][j2] = -temp4 + 1.0 / ptsaux1j;
                bmat[jpn][j2] = temp4 + 1.0 / ptsaux2j;
                bmat[0][j2] = -bmat[jp][j2] - bmat[jpn][j2];
                zmat[0][j2] = Math.sqrt(2.0) / Math.abs(ptsaux1j * ptsaux2j);
                zmat[jp][j2] = zmat[0][j2] * ptsaux2j * temp4;
                zmat[jpn][j2] = -zmat[0][j2] * ptsaux1j * temp4;
            } else {
                bmat[0][j2] = -1.0 / ptsaux1j;
                bmat[jp][j2] = 1.0 / ptsaux1j;
                bmat[j2 + npt][j2] = -0.5 * ptsaux1j * ptsaux1j;
            }
            ++j2;
        }
        if (npt >= n + np) {
            int k3 = 2 * np - 1;
            while (k3 < npt) {
                int iw = (int)(((double)(k3 - np) - 0.5) / (double)n);
                int ip2 = k3 - np - iw * n;
                int iq = ip2 + iw;
                int knpm1 = k3 - np;
                if (iq >= n) {
                    iq -= n;
                }
                ptsid[k3] = (double)ip2 + (double)iq * 1.0 / (double)np + sfrac;
                zmat[0][knpm1] = temp = 1.0 / (ptsaux[0][ip2] * ptsaux[1][iq]);
                zmat[ip2][knpm1] = -temp;
                zmat[iq][knpm1] = -temp;
                zmat[k3][knpm1] = temp;
                ++k3;
            }
        }
        int nrem = npt;
        int kold = 0;
        int knew = kopt;
        boolean gotoL120 = false;
        while (true) {
            double sum;
            int k4;
            if (!gotoL120) {
                int j4 = 0;
                while (j4 < n) {
                    temp = bmat[kold][j4];
                    bmat[kold][j4] = bmat[knew][j4];
                    bmat[knew][j4] = temp;
                    ++j4;
                }
                j4 = 0;
                while (j4 < nptm) {
                    temp = zmat[kold][j4];
                    zmat[kold][j4] = zmat[knew][j4];
                    zmat[knew][j4] = temp;
                    ++j4;
                }
                ptsid[kold] = ptsid[knew];
                ptsid[knew] = 0.0;
                w[ndim + knew] = 0.0;
                --nrem;
                if (knew != kopt) {
                    double temp5 = vlag[kold];
                    vlag[kold] = vlag[knew];
                    vlag[knew] = temp5;
                    Bobyqa.update(bmat, zmat, vlag, beta, denom, knew);
                    if (nrem == 0) {
                        return new int[]{nf, kopt};
                    }
                    k4 = 0;
                    while (k4 < npt) {
                        w[ndim + k4] = Math.abs(w[ndim + k4]);
                        ++k4;
                    }
                }
            }
            gotoL120 = false;
            double dsqmin = 0.0;
            k4 = 0;
            while (k4 < npt) {
                double wndimk = w[ndim + k4];
                if (wndimk > 0.0 && (dsqmin == 0.0 || wndimk < dsqmin)) {
                    knew = k4;
                    dsqmin = wndimk;
                }
                ++k4;
            }
            if (dsqmin == 0.0) break;
            int j5 = 0;
            while (j5 < n) {
                w[npt + j5] = xpt[knew][j5];
                ++j5;
            }
            k4 = 0;
            while (k4 < npt) {
                sum = 0.0;
                if (k4 != kopt) {
                    if (ptsid[k4] == 0.0) {
                        j = 0;
                        while (j < n) {
                            sum += w[npt + j] * xpt[k4][j];
                            ++j;
                        }
                    } else {
                        int iq;
                        ip = (int)ptsid[k4];
                        if (ip > 0) {
                            sum = w[npt + ip] * ptsaux[0][ip];
                        }
                        if ((iq = (int)((double)np * ptsid[k4] - (double)(ip * np))) > 0) {
                            int iw = 0;
                            if (ip == 0) {
                                iw = 1;
                            }
                            sum += w[npt + iq] * ptsaux[iw][iq];
                        }
                    }
                }
                w[k4] = 0.5 * sum * sum;
                ++k4;
            }
            k4 = 0;
            while (k4 < npt) {
                sum = 0.0;
                j = 0;
                while (j < n) {
                    sum += bmat[k4][j] * w[npt + j];
                    ++j;
                }
                vlag[k4] = sum;
                ++k4;
            }
            beta = 0.0;
            j5 = 0;
            while (j5 < nptm) {
                sum = 0.0;
                int k5 = 0;
                while (k5 < npt) {
                    sum += zmat[k5][j5] * w[k5];
                    ++k5;
                }
                beta -= sum * sum;
                k5 = 0;
                while (k5 < npt) {
                    int n2 = k5;
                    vlag[n2] = vlag[n2] + sum * zmat[k5][j5];
                    ++k5;
                }
                ++j5;
            }
            double bsum = 0.0;
            double distsq = 0.0;
            int j6 = 0;
            while (j6 < n) {
                double sum2 = 0.0;
                int k6 = 0;
                while (k6 < npt) {
                    sum2 += bmat[k6][j6] * w[k6];
                    ++k6;
                }
                int jp = j6 + npt;
                bsum += sum2 * w[jp];
                int ip3 = npt;
                while (ip3 < ndim) {
                    sum2 += bmat[ip3][j6] * w[ip3];
                    ++ip3;
                }
                bsum += sum2 * w[jp];
                vlag[jp] = sum2;
                sum2 = xpt[knew][j6];
                distsq += sum2 * sum2;
                ++j6;
            }
            beta = 0.5 * distsq * distsq + beta - bsum;
            vlag[kopt] = vlag[kopt] + 1.0;
            denom = 0.0;
            double vlmxsq = 0.0;
            int k7 = 0;
            while (k7 < npt) {
                double vlagksq = vlag[k7];
                vlagksq *= vlagksq;
                if (ptsid[k7] != 0.0) {
                    double hdiag = 0.0;
                    int j7 = 0;
                    while (j7 < nptm) {
                        hdiag += zmat[k7][j7] * zmat[k7][j7];
                        ++j7;
                    }
                    double den = beta * hdiag + vlagksq;
                    if (den > denom) {
                        kold = k7;
                        denom = den;
                    }
                }
                vlmxsq = Math.max(vlmxsq, vlagksq);
                ++k7;
            }
            if (!(denom <= 0.01 * vlmxsq)) continue;
            w[ndim + knew] = -w[ndim + knew] - winc;
            gotoL120 = true;
        }
        int kpt = 0;
        while (kpt < npt) {
            double xp = 0.0;
            double xq = 0.0;
            if (!(ptsid[kpt] < 0.0)) {
                double f;
                if (nf >= maxfun) {
                    nf = -1;
                    break;
                }
                ih = 0;
                j = 0;
                while (j < n) {
                    w[j] = xpt[kpt][j];
                    xpt[kpt][j] = 0.0;
                    double temp6 = pq[kpt] * w[j];
                    int i2 = 0;
                    while (i2 <= j) {
                        hq[ih] = hq[ih] + temp6 * w[i2];
                        ++ih;
                        ++i2;
                    }
                    ++j;
                }
                pq[kpt] = 0.0;
                ip = (int)ptsid[kpt];
                int iq = (int)((double)np * ptsid[kpt] - (double)(ip * np));
                if (ip >= 0) {
                    xpt[kpt][ip] = xp = ptsaux[0][ip];
                }
                if (iq >= 0) {
                    xpt[kpt][iq] = xq = ptsaux[ip == 0 ? 1 : 0][iq];
                }
                double vquad = fbase;
                int ihp = 0;
                int ihq = 0;
                if (ip >= 0) {
                    ihp = (ip + ip * ip) / 2;
                    vquad += xp * (gopt[ip] + 0.5 * xp * hq[ihp - 1]);
                }
                if (iq >= 0) {
                    ihq = (iq + iq * iq) / 2;
                    vquad += xq * (gopt[iq] + 0.5 * xq * hq[ihq - 1]);
                    if (ip >= 0) {
                        int iw = Math.max(ihp, ihq) - Math.abs(ip - iq);
                        vquad += xp * xq * hq[iw - 1];
                    }
                }
                int k8 = 0;
                while (k8 < npt) {
                    double temp7 = 0.0;
                    if (ip >= 0) {
                        temp7 += xp * xpt[k8][ip];
                    }
                    if (iq >= 0) {
                        temp7 += xq * xpt[k8][iq];
                    }
                    vquad += 0.5 * pq[k8] * temp7 * temp7;
                    ++k8;
                }
                int i3 = 0;
                while (i3 < n) {
                    w[i3] = Math.min(Math.max(xl[i3], xbase[i3] + xpt[kpt][i3]), xu[i3]);
                    if (xpt[kpt][i3] == sl[i3]) {
                        w[i3] = xl[i3];
                    }
                    if (xpt[kpt][i3] == su[i3]) {
                        w[i3] = xu[i3];
                    }
                    ++i3;
                }
                ++nf;
                fval[kpt] = f = calfun.eval(w) * (double)mult;
                if (f < fval[kopt]) {
                    kopt = kpt;
                }
                double diff = f - vquad;
                int i4 = 0;
                while (i4 < n) {
                    gopt[i4] = gopt[i4] + diff * bmat[kpt][i4];
                    ++i4;
                }
                int k9 = 0;
                while (k9 < npt) {
                    double sum = 0.0;
                    int j8 = 0;
                    while (j8 < nptm) {
                        sum += zmat[k9][j8] * zmat[kpt][j8];
                        ++j8;
                    }
                    double temp8 = diff * sum;
                    if (ptsid[k9] < 0.0) {
                        pq[k9] = pq[k9] + temp8;
                    } else {
                        double val;
                        ip = (int)ptsid[k9];
                        iq = (int)((double)np * ptsid[k9] - (double)(ip * np));
                        ihq = (iq * iq + iq) / 2;
                        if (ip == 0) {
                            val = ptsaux[1][iq];
                            hq[ihq] = hq[ihq] + temp8 * val * val;
                        } else {
                            ihp = (ip * ip + ip) / 2;
                            val = ptsaux[0][ip];
                            hq[ihp] = hq[ihp] + temp8 * val * val;
                            if (iq >= 0) {
                                double val2 = ptsaux[0][iq];
                                hq[ihq] = hq[ihq] + temp8 * val2 * val2;
                                int iw = Math.max(ihp, ihq) - Math.abs(iq - ip);
                                hq[iw] = hq[iw] + temp8 * val * val2;
                            }
                        }
                    }
                    ++k9;
                }
                ptsid[kpt] = -1.0;
            }
            ++kpt;
        }
        return new int[]{nf, kopt};
    }

    private static final double[] altmov(double[][] xpt, double[] xopt, double[][] bmat, double[][] zmat, double[] sl, double[] su, int kopt, int knew, double adelt, double[] xnew, double[] xalt) {
        double cauchy;
        int n = xpt[0].length;
        int npt = xpt.length;
        double __const = 1.0 + Math.sqrt(2.0);
        double[] glag = new double[n];
        double[] hcol = new double[npt];
        double[] w = new double[2 * n];
        int k = 0;
        while (k < npt) {
            hcol[k] = 0.0;
            ++k;
        }
        int j = 0;
        while (j < npt - n - 1) {
            double temp = zmat[knew][j];
            int k2 = 0;
            while (k2 < npt) {
                hcol[k2] = hcol[k2] + temp * zmat[k2][j];
                ++k2;
            }
            ++j;
        }
        double alpha = hcol[knew];
        double ha = 0.5 * alpha;
        int i = 0;
        while (i < n) {
            glag[i] = bmat[knew][i];
            ++i;
        }
        int k3 = 0;
        while (k3 < npt) {
            double temp = 0.0;
            int j2 = 0;
            while (j2 < n) {
                temp += xpt[k3][j2] * xopt[j2];
                ++j2;
            }
            temp *= hcol[k3];
            int i2 = 0;
            while (i2 < n) {
                glag[i2] = glag[i2] + temp * xpt[k3][i2];
                ++i2;
            }
            ++k3;
        }
        double presav = 0.0;
        double stpsav = 0.0;
        int ksav = 0;
        int ibdsav = 0;
        int k4 = 0;
        while (k4 < npt) {
            if (k4 != kopt) {
                double predsq;
                double temp;
                double vlag;
                double dderiv = 0.0;
                double distsq = 0.0;
                int i3 = 0;
                while (i3 < n) {
                    double temp2 = xpt[k4][i3] - xopt[i3];
                    dderiv += glag[i3] * temp2;
                    distsq += temp2 * temp2;
                    ++i3;
                }
                double subd = adelt / Math.sqrt(distsq);
                double slbd = -subd;
                double sumin = Math.min(1.0, subd);
                int ilbd = 0;
                int iubd = 0;
                int i4 = 0;
                while (i4 < n) {
                    double temp3 = xpt[k4][i4] - xopt[i4];
                    if (temp3 > 0.0) {
                        if (slbd * temp3 < sl[i4] - xopt[i4]) {
                            slbd = (sl[i4] - xopt[i4]) / temp3;
                            ilbd = -i4 - 1;
                        }
                        if (subd * temp3 > su[i4] - xopt[i4]) {
                            subd = Math.max(sumin, (su[i4] - xopt[i4]) / temp3);
                            iubd = i4 + 1;
                        }
                    } else if (temp3 < 0.0) {
                        if (slbd * temp3 > su[i4] - xopt[i4]) {
                            slbd = (su[i4] - xopt[i4]) / temp3;
                            ilbd = i4 + 1;
                        }
                        if (subd * temp3 < sl[i4] - xopt[i4]) {
                            subd = Math.max(sumin, (sl[i4] - xopt[i4]) / temp3);
                            iubd = -i4 - 1;
                        }
                    }
                    ++i4;
                }
                double step = slbd;
                int isbd = ilbd;
                if (k4 == knew) {
                    double tempb;
                    double tempd;
                    double tempa;
                    double diff = dderiv - 1.0;
                    vlag = slbd * (dderiv - slbd * diff);
                    temp = subd * (dderiv - subd * diff);
                    if (Math.abs(temp) > Math.abs(vlag)) {
                        step = subd;
                        vlag = temp;
                        isbd = iubd;
                    }
                    if ((tempa = (tempd = 0.5 * dderiv) - diff * slbd) * (tempb = tempd - diff * subd) < 0.0 && Math.abs(temp = tempd * tempd / diff) > Math.abs(vlag)) {
                        step = tempd / diff;
                        vlag = temp;
                        isbd = 0;
                    }
                } else {
                    vlag = slbd * (1.0 - slbd);
                    temp = subd * (1.0 - subd);
                    if (Math.abs(temp) > Math.abs(vlag)) {
                        step = subd;
                        vlag = temp;
                        isbd = iubd;
                    }
                    if (subd > 0.5 && Math.abs(vlag) < 0.25) {
                        step = 0.5;
                        vlag = 0.25;
                        isbd = 0;
                    }
                    vlag *= dderiv;
                }
                if ((predsq = vlag * vlag * (vlag * vlag + ha * (temp = step * (1.0 - step) * distsq) * temp)) > presav) {
                    presav = predsq;
                    ksav = k4;
                    stpsav = step;
                    ibdsav = isbd;
                }
            }
            ++k4;
        }
        int i5 = 0;
        while (i5 < n) {
            double temp = xopt[i5] + stpsav * (xpt[ksav][i5] - xopt[i5]);
            xnew[i5] = Math.max(sl[i5], Math.min(su[i5], temp));
            ++i5;
        }
        if (ibdsav < 0) {
            xnew[-ibdsav - 1] = sl[-ibdsav - 1];
        } else if (ibdsav > 0) {
            xnew[ibdsav - 1] = su[ibdsav - 1];
        }
        double bigstp = adelt + adelt;
        boolean iflag = false;
        double csave = 0.0;
        while (true) {
            double temp;
            double wfixsq = 0.0;
            double ggfree = 0.0;
            int i6 = 0;
            while (i6 < n) {
                w[i6] = 0.0;
                double glagi = glag[i6];
                if (Math.min(xopt[i6] - sl[i6], glagi) > 0.0 || Math.max(xopt[i6] - su[i6], glagi) < 0.0) {
                    w[i6] = bigstp;
                    ggfree += glagi * glagi;
                }
                ++i6;
            }
            if (ggfree == 0.0) {
                return new double[]{alpha, 0.0};
            }
            double step = 0.0;
            while ((temp = adelt * adelt - wfixsq) > 0.0) {
                double wsqsav = wfixsq;
                step = Math.sqrt(temp / ggfree);
                ggfree = 0.0;
                int i7 = 0;
                while (i7 < n) {
                    if (w[i7] == bigstp) {
                        double wi;
                        temp = xopt[i7] - step * glag[i7];
                        if (temp <= sl[i7]) {
                            wi = w[i7] = sl[i7] - xopt[i7];
                            wfixsq += wi * wi;
                        } else if (temp >= su[i7]) {
                            wi = w[i7] = su[i7] - xopt[i7];
                            wfixsq += wi * wi;
                        } else {
                            wi = glag[i7];
                            ggfree += wi * wi;
                        }
                    }
                    ++i7;
                }
                if (!(wfixsq > wsqsav) || !(ggfree > 0.0)) break;
            }
            double gw = 0.0;
            int i8 = 0;
            while (i8 < n) {
                double glagi = glag[i8];
                if (w[i8] == bigstp) {
                    w[i8] = -step * glagi;
                    xalt[i8] = Math.max(sl[i8], Math.min(su[i8], xopt[i8] + w[i8]));
                } else {
                    xalt[i8] = w[i8] == 0.0 ? xopt[i8] : (glagi > 0.0 ? sl[i8] : su[i8]);
                }
                gw += glagi * w[i8];
                ++i8;
            }
            double curv = 0.0;
            int k5 = 0;
            while (k5 < npt) {
                temp = 0.0;
                int j3 = 0;
                while (j3 < n) {
                    temp += xpt[k5][j3] * w[j3];
                    ++j3;
                }
                curv += hcol[k5] * temp * temp;
                ++k5;
            }
            if (iflag) {
                curv = -curv;
            }
            if (curv > -gw && curv < -gw * __const) {
                double scale = -gw / curv;
                int i9 = 0;
                while (i9 < n) {
                    temp = xopt[i9] + scale * w[i9];
                    xalt[i9] = Math.max(sl[i9], Math.min(su[i9], temp));
                    ++i9;
                }
                cauchy = 0.5 * gw * scale;
                cauchy *= cauchy;
            } else {
                cauchy = gw + 0.5 * curv;
                cauchy *= cauchy;
            }
            if (iflag) break;
            int i10 = 0;
            while (i10 < n) {
                glag[i10] = -glag[i10];
                w[n + i10] = xalt[i10];
                ++i10;
            }
            csave = cauchy;
            iflag = true;
        }
        if (csave > cauchy) {
            int i11 = 0;
            while (i11 < n) {
                xalt[i11] = w[n + i11];
                ++i11;
            }
            cauchy = csave;
        }
        return new double[]{alpha, cauchy};
    }

    private static final double[] trsbox(double[][] xpt, double[] xopt, double[] gopt, double[] hq, double[] pq, double[] sl, double[] su, double delta, double[] xnew, double[] d, double[] gnew, double dsq, double crvmin) {
        double val;
        int n = xpt[0].length;
        int npt = xpt.length;
        int iterc = 0;
        int nact = 0;
        int[] xbdi = new int[n];
        double[] s = new double[n];
        double[] hs = new double[n];
        double[] hred = new double[n];
        int i = 0;
        while (i < n) {
            xbdi[i] = 0;
            if (xopt[i] <= sl[i]) {
                if (gopt[i] >= 0.0) {
                    xbdi[i] = -1;
                }
            } else if (xopt[i] >= su[i] && gopt[i] <= 0.0) {
                xbdi[i] = 1;
            }
            if (xbdi[i] != 0) {
                ++nact;
            }
            d[i] = 0.0;
            gnew[i] = gopt[i];
            ++i;
        }
        double delsq = delta * delta;
        double qred = 0.0;
        double beta = 0.0;
        double gredsq = 0.0;
        double dredsq = 0.0;
        double dredg = 0.0;
        double ggsav = 0.0;
        double stepsq = 0.0;
        double sredg = 0.0;
        double redsav = 0.0;
        double angbd = 1.0;
        int itermax = 0;
        int itcsav = 0;
        int label = 30;
        int xsav = 0;
        int iact = 0;
        crvmin = -1.0;
        boolean loop = true;
        while (loop) {
            switch (label) {
                case 30: {
                    stepsq = 0.0;
                    int i2 = 0;
                    while (i2 < n) {
                        s[i2] = xbdi[i2] != 0 ? 0.0 : (beta == 0.0 ? -gnew[i2] : beta * s[i2] - gnew[i2]);
                        val = s[i2];
                        stepsq += val * val;
                        ++i2;
                    }
                    if (stepsq == 0.0) {
                        loop = false;
                        break;
                    }
                    if (beta == 0.0) {
                        gredsq = stepsq;
                        itermax = iterc + n - nact;
                    }
                    if (gredsq * delsq <= qred * 1.0E-4 * qred) {
                        loop = false;
                        break;
                    }
                    label = 210;
                    break;
                }
                case 50: {
                    double resid = delsq;
                    double ds = 0.0;
                    double shs = 0.0;
                    int i3 = 0;
                    while (i3 < n) {
                        if (xbdi[i3] == 0) {
                            double di = d[i3];
                            double si = s[i3];
                            resid -= di * di;
                            ds += si * di;
                            shs += si * hs[i3];
                        }
                        ++i3;
                    }
                    if (resid <= 0.0) {
                        crvmin = 0.0;
                        label = 100;
                        break;
                    }
                    double temp = Math.sqrt(stepsq * resid + ds * ds);
                    double blen = ds < 0.0 ? (temp - ds) / stepsq : resid / (temp + ds);
                    double stplen = shs > 0.0 ? Math.min(blen, gredsq / shs) : blen;
                    iact = -1;
                    int i4 = 0;
                    while (i4 < n) {
                        if (s[i4] != 0.0) {
                            double xsum = xopt[i4] + d[i4];
                            double d2 = temp = s[i4] > 0.0 ? (su[i4] - xsum) / s[i4] : (sl[i4] - xsum) / s[i4];
                            if (temp < stplen) {
                                stplen = temp;
                                iact = i4;
                            }
                        }
                        ++i4;
                    }
                    double sdec = 0.0;
                    if (stplen > 0.0) {
                        ++iterc;
                        temp = shs / stepsq;
                        if (iact == -1 && temp > 0.0 && (crvmin = Math.min(crvmin, temp)) == -1.0) {
                            crvmin = temp;
                        }
                        ggsav = gredsq;
                        gredsq = 0.0;
                        int i5 = 0;
                        while (i5 < n) {
                            gnew[i5] = gnew[i5] + stplen * hs[i5];
                            if (xbdi[i5] == 0) {
                                double val2 = gnew[i5];
                                gredsq += val2 * val2;
                            }
                            d[i5] = d[i5] + stplen * s[i5];
                            ++i5;
                        }
                        sdec = Math.max(stplen * (ggsav - 0.5 * stplen * shs), 0.0);
                        qred += sdec;
                    }
                    if (iact >= 0) {
                        double val3;
                        ++nact;
                        xbdi[iact] = 1;
                        if (s[iact] < 0.0) {
                            xbdi[iact] = -1;
                        }
                        if ((delsq -= (val3 = d[iact]) * val3) <= 0.0) {
                            crvmin = 0.0;
                            label = 100;
                            break;
                        }
                        beta = 0.0;
                        label = 30;
                        break;
                    }
                    if (stplen < blen) {
                        if (iterc == itermax || sdec <= 0.01 * qred) {
                            loop = false;
                            break;
                        }
                        beta = gredsq / ggsav;
                        label = 30;
                        break;
                    }
                    crvmin = 0.0;
                    label = 100;
                    break;
                }
                case 100: {
                    if (nact >= n - 1) {
                        loop = false;
                        break;
                    }
                    gredsq = 0.0;
                    dredg = 0.0;
                    dredsq = 0.0;
                    int i6 = 0;
                    while (i6 < n) {
                        if (xbdi[i6] == 0) {
                            double di = d[i6];
                            double gi = gnew[i6];
                            dredsq += di * di;
                            dredg += di * gi;
                            gredsq += gi * gi;
                            s[i6] = di;
                        } else {
                            s[i6] = 0.0;
                        }
                        ++i6;
                    }
                    itcsav = iterc;
                    label = 210;
                    break;
                }
                case 120: {
                    ++iterc;
                    double temp = gredsq * dredsq - dredg * dredg;
                    if (temp <= qred * 1.0E-4 * qred) {
                        loop = false;
                        break;
                    }
                    temp = Math.sqrt(temp);
                    int i7 = 0;
                    while (i7 < n) {
                        s[i7] = xbdi[i7] == 0 ? (dredg * d[i7] - dredsq * gnew[i7]) / temp : 0.0;
                        ++i7;
                    }
                    sredg = -temp;
                    angbd = 1.0;
                    iact = -1;
                    label = 0;
                    i7 = 0;
                    while (i7 < n) {
                        if (xbdi[i7] == 0) {
                            double tempa = xopt[i7] + d[i7] - sl[i7];
                            double tempb = su[i7] - xopt[i7] - d[i7];
                            if (tempa <= 0.0) {
                                ++nact;
                                xbdi[i7] = -1;
                                label = 100;
                                break;
                            }
                            if (tempb <= 0.0) {
                                ++nact;
                                xbdi[i7] = 1;
                                label = 100;
                                break;
                            }
                            double di = d[i7];
                            double si = s[i7];
                            double ssq = di * di + si * si;
                            double val4 = xopt[i7] - sl[i7];
                            temp = ssq - val4 * val4;
                            if (temp > 0.0 && angbd * (temp = Math.sqrt(temp) - s[i7]) > tempa) {
                                angbd = tempa / temp;
                                iact = i7;
                                xsav = -1;
                            }
                            if ((temp = ssq - (val4 = su[i7] - xopt[i7]) * val4) > 0.0 && angbd * (temp = Math.sqrt(temp) + s[i7]) > tempb) {
                                angbd = tempb / temp;
                                iact = i7;
                                xsav = 1;
                            }
                        }
                        ++i7;
                    }
                    if (label != 0) break;
                    label = 210;
                    break;
                }
                case 150: {
                    double sth;
                    double dhs = 0.0;
                    double dhd = 0.0;
                    double shs = 0.0;
                    int i8 = 0;
                    while (i8 < n) {
                        if (xbdi[i8] == 0) {
                            shs += s[i8] * hs[i8];
                            dhs += d[i8] * hs[i8];
                            dhd += d[i8] * hred[i8];
                        }
                        ++i8;
                    }
                    redsav = 0.0;
                    double redmax = 0.0;
                    double rdprev = 0.0;
                    double rdnext = 0.0;
                    double angt = 0.0;
                    int isav = 0;
                    int iu = (int)(17.0 * angbd + 3.1);
                    int i9 = 1;
                    while (i9 <= iu) {
                        angt = angbd * (double)i9 / (double)iu;
                        sth = (angt + angt) / (1.0 + angt * angt);
                        double temp = shs + angt * (angt * dhd - dhs - dhs);
                        double rednew = sth * (angt * dredg - sredg - 0.5 * sth * temp);
                        if (rednew > redmax) {
                            redmax = rednew;
                            isav = i9;
                            rdprev = redsav;
                        } else if (i9 == isav + 1) {
                            rdnext = rednew;
                        }
                        redsav = rednew;
                        ++i9;
                    }
                    if (isav == 0) {
                        loop = false;
                        break;
                    }
                    if (isav < iu) {
                        double temp = (rdnext - rdprev) / (redmax + redmax - rdprev - rdnext);
                        angt = angbd * ((double)isav + 0.5 * temp) / (double)iu;
                    }
                    double cth = (1.0 - angt * angt) / (1.0 + angt * angt);
                    sth = (angt + angt) / (1.0 + angt * angt);
                    double temp = shs + angt * (angt * dhd - dhs - dhs);
                    double sdec = sth * (angt * dredg - sredg - 0.5 * sth * temp);
                    if (sdec <= 0.0) {
                        loop = false;
                        break;
                    }
                    gredsq = 0.0;
                    dredg = 0.0;
                    int i10 = 0;
                    while (i10 < n) {
                        gnew[i10] = gnew[i10] + (cth - 1.0) * hred[i10] + sth * hs[i10];
                        if (xbdi[i10] == 0) {
                            d[i10] = cth * d[i10] + sth * s[i10];
                            double val5 = gnew[i10];
                            dredg += d[i10] * val5;
                            gredsq += val5 * val5;
                        }
                        hred[i10] = cth * hred[i10] + sth * hs[i10];
                        ++i10;
                    }
                    qred += sdec;
                    if (iact >= 0 && isav == iu) {
                        ++nact;
                        xbdi[iact] = xsav;
                        label = 100;
                        break;
                    }
                    if (sdec > 0.01 * qred) {
                        label = 120;
                        break;
                    }
                    loop = false;
                    break;
                }
                case 210: {
                    int i11;
                    int ih = 0;
                    int j = 0;
                    while (j < n) {
                        hs[j] = 0.0;
                        i11 = 0;
                        while (i11 <= j) {
                            if (i11 < j) {
                                hs[j] = hs[j] + hq[ih] * s[i11];
                            }
                            hs[i11] = hs[i11] + hq[ih] * s[j];
                            ++ih;
                            ++i11;
                        }
                        ++j;
                    }
                    int k = 0;
                    while (k < npt) {
                        if (pq[k] != 0.0) {
                            double temp = 0.0;
                            int j2 = 0;
                            while (j2 < n) {
                                temp += xpt[k][j2] * s[j2];
                                ++j2;
                            }
                            temp *= pq[k];
                            i11 = 0;
                            while (i11 < n) {
                                hs[i11] = hs[i11] + temp * xpt[k][i11];
                                ++i11;
                            }
                        }
                        ++k;
                    }
                    if (crvmin != 0.0) {
                        label = 50;
                        break;
                    }
                    if (iterc > itcsav) {
                        label = 150;
                        break;
                    }
                    int i12 = 0;
                    while (i12 < n) {
                        hred[i12] = hs[i12];
                        ++i12;
                    }
                    label = 120;
                }
            }
        }
        dsq = 0.0;
        int i13 = 0;
        while (i13 < n) {
            xnew[i13] = Math.max(Math.min(xopt[i13] + d[i13], su[i13]), sl[i13]);
            if (xbdi[i13] == -1) {
                xnew[i13] = sl[i13];
            }
            if (xbdi[i13] == 1) {
                xnew[i13] = su[i13];
            }
            val = d[i13] = xnew[i13] - xopt[i13];
            dsq += val * val;
            ++i13;
        }
        return new double[]{dsq, crvmin};
    }

    public static void main(String[] args) {
        MultivariableFunction ifun = new MultivariableFunction(){

            public double eval(double ... x) {
                int n = x.length;
                double f = 0.0;
                int i = 3;
                while (i < n) {
                    int j = 1;
                    while (j < i - 1) {
                        double v1 = x[i - 1] - x[j - 1];
                        double v2 = x[i] - x[j];
                        f += 1.0 / Math.sqrt(Math.max(v1 * v1 + v2 * v2, 1.0E-6));
                        j += 2;
                    }
                    i += 2;
                }
                return f;
            }
        };
        double rhobeg = 0.1;
        double rhoend = 1.0E-6;
        int maxfun = 500000;
        int max_n = 80;
        int n = 10;
        System.out.println("rhobeg = " + rhobeg + ", rhoend = " + rhoend);
        do {
            int npt = n + 6;
            double[] xl = new double[n];
            double[] xu = new double[n];
            double[] x = new double[n];
            int i = 0;
            while (i < n) {
                xl[i] = -1.0;
                xu[i] = 1.0;
                ++i;
            }
            i = 0;
            while (i < n / 2) {
                double temp = (double)((i + 1) * 4) * Math.PI / (double)n;
                x[2 * i] = Math.cos(temp);
                x[2 * i + 1] = Math.sin(temp);
                ++i;
            }
            System.out.println("n = " + n + ", npt = " + npt);
            OptimizationResult result = Bobyqa.bobyqa(x, xl, xu, ifun, npt, rhobeg, rhoend, maxfun, true);
            System.out.println(result);
            npt = 2 * n + 1;
            System.out.println("n = " + n + ", npt = " + npt);
            result = Bobyqa.bobyqa(x, xl, xu, ifun, npt, rhobeg, rhoend, maxfun, true);
            System.out.println(result);
        } while ((n *= 2) <= max_n);
    }
}

