/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class ErrorCheckingPrintWriter
extends PrintWriter {
    private String path = "unknown";
    private final ThreadLocal<Boolean> nestedFlush = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public ErrorCheckingPrintWriter(Writer out) {
        super(out);
    }

    public ErrorCheckingPrintWriter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public ErrorCheckingPrintWriter(OutputStream out) {
        super(out);
    }

    public ErrorCheckingPrintWriter(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public ErrorCheckingPrintWriter(String fileName) throws FileNotFoundException {
        super(fileName);
        this.path = fileName;
    }

    public ErrorCheckingPrintWriter(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        super(fileName, csn);
        this.path = fileName;
    }

    public ErrorCheckingPrintWriter(File file) throws FileNotFoundException {
        super(file);
        this.path = file.getAbsolutePath();
    }

    public ErrorCheckingPrintWriter(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        super(file, csn);
        this.path = file.getAbsolutePath();
    }

    @Override
    public void flush() {
        if (this.nestedFlush.get().booleanValue()) {
            return;
        }
        try {
            this.nestedFlush.set(true);
            if (this.checkError()) {
                throw new RuntimeException("Exception writing file " + this.path);
            }
            super.flush();
        }
        finally {
            this.nestedFlush.set(false);
        }
    }

    @Override
    public void close() {
        if (this.checkError()) {
            throw new RuntimeException("Exception writing file " + this.path);
        }
        super.close();
    }

    public void setPath(String path) {
        this.path = path;
    }
}

