/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.junctionlibrary;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.Log;

public class JunctionSamUtils {
    private final Log log = Log.getInstance(JunctionSamUtils.class);
    private static JunctionSamUtils ourInstance = new JunctionSamUtils();
    public static final int MAX_RECORDS_IN_RAM = 500000;

    private JunctionSamUtils() {
    }

    public static JunctionSamUtils getInstance() {
        return ourInstance;
    }

    public String cleanReadName(String readName) {
        if (readName.endsWith("/1") || readName.endsWith("/2")) {
            readName = readName.substring(0, readName.length() - 2);
        }
        return readName;
    }

    public boolean testPairedRead(SAMRecord r1, SAMRecord r2) {
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.getSecondOfPairFlag() || r2.getFirstOfPairFlag()) {
            this.log.warn(new Object[]{r1.getReadName() + " passed as 2nd read of pair, should be the first"});
            return false;
        }
        if (r2.getFirstOfPairFlag()) {
            this.log.warn(new Object[]{r2.getReadName() + " passed as 1st read of pair, should be the second"});
            return false;
        }
        boolean result = this.testSameReadName(r1, r2);
        if (!result) {
            this.log.warn(new Object[]{"Read names not the same " + r1.getReadName() + " " + r2.getReadName()});
        }
        return result;
    }

    public boolean testReadsArePaired(SAMRecord r1, SAMRecord r2) {
        boolean f2;
        boolean f1 = r1.getFirstOfPairFlag() & r2.getSecondOfPairFlag();
        if (f1 | (f2 = r1.getSecondOfPairFlag() & r2.getFirstOfPairFlag())) {
            return this.testSameReadName(r1, r2);
        }
        return false;
    }

    public boolean testSameReadName(SAMRecord r1, SAMRecord r2) {
        String cleanReadNameTwo;
        if (r1 == null || r2 == null) {
            return false;
        }
        String cleanReadNameOne = this.cleanReadName(r1.getReadName());
        return cleanReadNameOne.equals(cleanReadNameTwo = this.cleanReadName(r2.getReadName()));
    }
}

