/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils;

import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IterableOnceIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public abstract class CountChangingIteratorWrapper<T>
extends IterableOnceIterator<T> {
    private final Iterator<T> underlyingIterator;
    private final Queue<T> outputQueue = new LinkedList<T>();

    protected CountChangingIteratorWrapper(Iterator<T> underlyingIterator) {
        this.underlyingIterator = underlyingIterator;
    }

    private void populateOutputQueue() {
        while (this.outputQueue.isEmpty() && this.underlyingIterator.hasNext()) {
            this.processRecord(this.underlyingIterator.next());
        }
    }

    protected abstract void processRecord(T var1);

    protected void queueRecordForOutput(T rec) {
        this.outputQueue.add(rec);
    }

    public boolean hasNext() {
        this.populateOutputQueue();
        return !this.outputQueue.isEmpty();
    }

    public T next() {
        this.populateOutputQueue();
        return this.outputQueue.remove();
    }

    public void close() throws IOException {
        CloserUtil.close(this.underlyingIterator);
        super.close();
    }
}

