/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.broadinstitute.dropseqrna.cmdline.DropSeq;
import org.broadinstitute.dropseqrna.utils.SamHeaderUtil;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;

@CommandLineProgramProperties(usage="Filters a BAM file by various qualities to produce a new subset of the BAM containing the reads of interest.", usageShort="Filters a BAM file by various qualities to produce a new subset of the BAM containing the reads of interest.", programGroup=DropSeq.class)
public class FilterBAM
extends CommandLineProgram {
    private final Log log = Log.getInstance(FilterBAM.class);
    @Option(shortName="I", doc="The input SAM or BAM file to analyze.")
    public File INPUT;
    @Option(shortName="O", doc="Output report")
    public File OUTPUT;
    @Option(doc="Minimum mapping quality to consider the read", optional=true)
    public Integer MINIMUM_MAPPING_QUALITY = null;
    @Option(doc="Should PCR duplicates be filtered?", optional=true)
    public boolean FILTER_PCR_DUPES = false;
    @Option(doc="Retain primary reads only", optional=true)
    public boolean RETAIN_ONLY_PRIMARY_READS = false;
    @Option(doc="Retain reads that have at least this many M bases total in the cigar string.  This sums all the M's in the cigar string.", optional=true)
    public Integer SUM_MATCHING_BASES = null;
    @Option(doc="Soft match reference names that have this string. If multiple matches are specified, they are OR'd together.This is the equivalent of a hard match with wrapped with .* on either side.", optional=true)
    public List<String> REF_SOFT_MATCHED_RETAINED = null;
    @Option(doc="Soft match and reject reference names that have this string.  If multiple matches are specified, they are OR'd together. This is the equivalent of a hard match with wrapped with .* on either side. ", optional=true)
    public List<String> REF_SOFT_MATCHED_REJECTED = null;
    @Option(doc="Exact match reference names that have this string.  If multiple matches are specified, they are OR'd together.For example, '1' would retain only references that were exactly '1'. This method accepts regular expressions.", optional=true)
    public List<String> REF_HARD_MATCHED_RETAINED = null;
    @Option(doc="Exact match and reject reference names that have this string.  If multiple matches are specified, they are OR'd together.This method accepts regular expressions.", optional=true)
    public List<String> REF_HARD_MATCHED_REJECTED = null;
    @Option(doc="Retain reads that have these tags set with any value.  Can be set multiple times", optional=true)
    public List<String> TAG_RETAIN = null;
    @Option(doc="If multiple TAG_RETAIN flags are set, should the result be the union of the filters, or the intersect?  [UNION/INTERSECT].", optional=true)
    public String TAG_RETAIN_COMBINE_FLAG = null;
    @Option(doc="Reject reads that have these tags set with any value.  Can be set multiple times.", optional=true)
    public List<String> TAG_REJECT = null;
    @Option(doc="If multiple TAG_REJECT flags are set, should the result be the union of the filters, or the intersect?  [UNION/INTERSECT].", optional=true)
    public String TAG_REJECT_COMBINE_FLAG = null;
    @Option(doc="Edit contig names so that a contig that starts with one of these prefixes has the prefix stripped.", optional=true)
    public List<String> STRIP_REF_PREFIX;
    @Option(doc="Edit sequence dictionary and remove any contig that has been filtered by reference name filtering. A read with mate alignment info in which mate is aligned to a contig that has been removed will be changed to have an unmapped mate.")
    public boolean DROP_REJECTED_REF = false;
    private static final String UNION = "UNION";
    private static final String INTERSECT = "INTERSECT";
    private Map<MatchTypes, List<Pattern>> patterns;

    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        this.buildPatterns();
        SamReader in = SamReaderFactory.makeDefault().open(this.INPUT);
        SAMFileHeader fileHeader = this.editSequenceDictionary(in.getFileHeader().clone());
        SamHeaderUtil.addPgRecord(fileHeader, this);
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMOrBAMWriter(fileHeader, true, this.OUTPUT);
        ProgressLogger progLog = new ProgressLogger(this.log);
        boolean sequencesRemoved = fileHeader.getSequenceDictionary().getSequences().size() != in.getFileHeader().getSequenceDictionary().getSequences().size();
        for (SAMRecord r : in) {
            progLog.record(r);
            if (this.filterRead(r)) continue;
            String sequenceName = this.stripReferencePrefix(r.getReferenceName());
            String mateSequenceName = null;
            if (r.getMateReferenceIndex() != -1) {
                mateSequenceName = this.stripReferencePrefix(r.getMateReferenceName());
            }
            if (sequencesRemoved || sequenceName != null) {
                if (sequenceName == null) {
                    sequenceName = r.getReferenceName();
                }
                r.setReferenceName(sequenceName);
            }
            if (r.getMateReferenceIndex() != -1 && (sequencesRemoved || mateSequenceName != null)) {
                if (mateSequenceName == null) {
                    mateSequenceName = r.getMateReferenceName();
                }
                if (fileHeader.getSequenceDictionary().getSequence(mateSequenceName) != null) {
                    r.setMateReferenceName(mateSequenceName);
                } else {
                    r.setMateUnmappedFlag(true);
                    r.setMateReferenceIndex(-1);
                    r.setMateAlignmentStart(0);
                }
            }
            out.addAlignment(r);
        }
        CloserUtil.close((Object)in);
        out.close();
        return 0;
    }

    private SAMFileHeader editSequenceDictionary(SAMFileHeader fileHeader) {
        if (this.DROP_REJECTED_REF || !this.STRIP_REF_PREFIX.isEmpty()) {
            ArrayList sequences = new ArrayList(fileHeader.getSequenceDictionary().getSequences());
            ListIterator<SAMSequenceRecord> it = sequences.listIterator();
            while (it.hasNext()) {
                SAMSequenceRecord sequence = (SAMSequenceRecord)it.next();
                if (this.DROP_REJECTED_REF && this.filterReference(sequence.getSequenceName())) {
                    it.remove();
                    continue;
                }
                String editedSequenceName = this.stripReferencePrefix(sequence.getSequenceName());
                if (editedSequenceName == null) continue;
                it.set(this.cloneWithNewName(sequence, editedSequenceName));
            }
            fileHeader.getSequenceDictionary().setSequences(sequences);
        }
        return fileHeader;
    }

    private SAMSequenceRecord cloneWithNewName(SAMSequenceRecord sequence, String editedSequenceName) {
        SAMSequenceRecord ret = new SAMSequenceRecord(editedSequenceName, sequence.getSequenceLength());
        for (Map.Entry entry : sequence.getAttributes()) {
            if (((String)entry.getKey()).equals("SN")) {
                ret.setAttribute("SN", editedSequenceName);
                continue;
            }
            ret.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        return ret;
    }

    private String stripReferencePrefix(String refName) {
        for (String prefix : this.STRIP_REF_PREFIX) {
            if (!refName.startsWith(prefix)) continue;
            return refName.substring(prefix.length());
        }
        return null;
    }

    void buildPatterns() {
        List<Pattern> p;
        this.patterns = new HashMap<MatchTypes, List<Pattern>>();
        if (this.REF_SOFT_MATCHED_RETAINED != null) {
            p = this.buildPatterns(this.REF_SOFT_MATCHED_RETAINED, true);
            this.patterns.put(MatchTypes.REF_SOFT_MATCHED_RETAINED, p);
        }
        if (this.REF_SOFT_MATCHED_REJECTED != null) {
            p = this.buildPatterns(this.REF_SOFT_MATCHED_REJECTED, true);
            this.patterns.put(MatchTypes.REF_SOFT_MATCHED_REJECTED, p);
        }
        if (this.REF_HARD_MATCHED_RETAINED != null) {
            p = this.buildPatterns(this.REF_HARD_MATCHED_RETAINED, false);
            this.patterns.put(MatchTypes.REF_HARD_MATCHED_RETAINED, p);
        }
        if (this.REF_HARD_MATCHED_REJECTED != null) {
            p = this.buildPatterns(this.REF_HARD_MATCHED_REJECTED, false);
            this.patterns.put(MatchTypes.REF_HARD_MATCHED_REJECTED, p);
        }
    }

    private List<Pattern> buildPatterns(List<String> matches, boolean soft) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        for (String s : matches) {
            Pattern pattern = soft ? Pattern.compile(".*" + s + ".*") : Pattern.compile(s);
            result.add(pattern);
        }
        return result;
    }

    public boolean filterRead(SAMRecord r) {
        if (this.rejectOnMapQuality(r)) {
            return true;
        }
        if (this.rejectPCRDuplicate(r)) {
            return true;
        }
        if (this.rejectNonPrimaryReads(r)) {
            return true;
        }
        if (this.rejectOnCigar(r)) {
            return true;
        }
        if (this.filterReference(r.getReferenceName())) {
            return true;
        }
        if (this.rejectOnTags(this.TAG_REJECT, r)) {
            return true;
        }
        return !this.acceptOnTags(this.TAG_RETAIN, r);
    }

    private boolean filterReference(String refName) {
        return this.rejectSoftMatch(refName) || this.rejectHardMatch(refName) || !this.acceptSoftMatch(refName) || !this.acceptHardMatch(refName);
    }

    boolean rejectOnCigar(SAMRecord r) {
        if (this.SUM_MATCHING_BASES == null) {
            return false;
        }
        Cigar c = r.getCigar();
        int count = 0;
        for (CigarElement ce : c.getCigarElements()) {
            if (ce.getOperator() != CigarOperator.M) continue;
            count += ce.getLength();
        }
        return count < this.SUM_MATCHING_BASES;
    }

    private boolean rejectOnMapQuality(SAMRecord r) {
        if (this.MINIMUM_MAPPING_QUALITY == null) {
            return false;
        }
        return r.getMappingQuality() < this.MINIMUM_MAPPING_QUALITY;
    }

    private boolean rejectPCRDuplicate(SAMRecord r) {
        return this.FILTER_PCR_DUPES && r.getDuplicateReadFlag();
    }

    boolean rejectNonPrimaryReads(SAMRecord r) {
        return this.RETAIN_ONLY_PRIMARY_READS && r.isSecondaryOrSupplementary();
    }

    private boolean rejectSoftMatch(String refName) {
        if (this.REF_SOFT_MATCHED_REJECTED == null || this.REF_SOFT_MATCHED_REJECTED.isEmpty()) {
            return false;
        }
        boolean hasMatch = this.matchReference(this.patterns.get((Object)MatchTypes.REF_SOFT_MATCHED_REJECTED), refName);
        return hasMatch;
    }

    private boolean rejectHardMatch(String refName) {
        if (this.REF_HARD_MATCHED_REJECTED == null || this.REF_HARD_MATCHED_REJECTED.isEmpty()) {
            return false;
        }
        boolean hasMatch = this.matchReference(this.patterns.get((Object)MatchTypes.REF_HARD_MATCHED_REJECTED), refName);
        return hasMatch;
    }

    private boolean acceptSoftMatch(String refName) {
        if (this.REF_SOFT_MATCHED_RETAINED == null || this.REF_SOFT_MATCHED_RETAINED.isEmpty()) {
            return true;
        }
        boolean hasMatch = this.matchReference(this.patterns.get((Object)MatchTypes.REF_SOFT_MATCHED_RETAINED), refName);
        return hasMatch;
    }

    private boolean acceptHardMatch(String refName) {
        if (this.REF_HARD_MATCHED_RETAINED == null || this.REF_HARD_MATCHED_RETAINED.isEmpty()) {
            return true;
        }
        boolean hasMatch = this.matchReference(this.patterns.get((Object)MatchTypes.REF_HARD_MATCHED_RETAINED), refName);
        return hasMatch;
    }

    boolean softMatchReference(List<String> matches, SAMRecord r) {
        String refName = r.getReferenceName();
        for (String match : matches) {
            if (!refName.matches(".*" + match + ".*")) continue;
            return true;
        }
        return false;
    }

    private boolean matchReference(List<Pattern> patterns, String refName) {
        for (Pattern p : patterns) {
            Matcher m = p.matcher(refName);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    boolean exactMatchReference(List<String> matches, SAMRecord r) {
        String refName = r.getReferenceName();
        for (String match : matches) {
            if (!refName.matches(match)) continue;
            return true;
        }
        return false;
    }

    boolean rejectOnTags(List<String> tags, SAMRecord r) {
        if (tags == null || tags.isEmpty()) {
            return false;
        }
        for (String tag : tags) {
            Object v = r.getAttribute(tag);
            if (v != null && this.TAG_REJECT_COMBINE_FLAG != null && this.TAG_REJECT_COMBINE_FLAG.equals(UNION)) {
                return true;
            }
            if (v == null && this.TAG_REJECT_COMBINE_FLAG != null && this.TAG_REJECT_COMBINE_FLAG.equals(INTERSECT)) {
                return false;
            }
            if (v == null || this.TAG_REJECT_COMBINE_FLAG != null) continue;
            return true;
        }
        return false;
    }

    private boolean acceptOnTags(List<String> tags, SAMRecord r) {
        if (tags == null || tags.isEmpty()) {
            return true;
        }
        for (String tag : tags) {
            Object v = r.getAttribute(tag);
            if (v != null && this.TAG_RETAIN_COMBINE_FLAG != null && this.TAG_RETAIN_COMBINE_FLAG.equals(UNION)) {
                return true;
            }
            if (v == null && this.TAG_RETAIN_COMBINE_FLAG != null && this.TAG_RETAIN_COMBINE_FLAG.equals(INTERSECT)) {
                return false;
            }
            if (v == null || this.TAG_RETAIN_COMBINE_FLAG != null) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        System.exit(new FilterBAM().instanceMain(args));
    }

    public static enum MatchTypes {
        REF_SOFT_MATCHED_RETAINED,
        REF_SOFT_MATCHED_REJECTED,
        REF_HARD_MATCHED_RETAINED,
        REF_HARD_MATCHED_REJECTED;

    }
}

