/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.operation.ooplace;

import org.la4j.Vector;
import org.la4j.Vectors;
import org.la4j.iterator.VectorIterator;
import org.la4j.operation.SymmetricVectorVectorOperation;
import org.la4j.vector.DenseVector;
import org.la4j.vector.SparseVector;
import org.la4j.vector.functor.VectorFunction;

public class OoPlaceInnerProduct
extends SymmetricVectorVectorOperation<Double> {
    @Override
    public Double apply(SparseVector a, SparseVector b) {
        VectorIterator these = a.nonZeroIterator();
        VectorIterator those = b.nonZeroIterator();
        return these.innerProduct(those);
    }

    @Override
    public Double applySymmetric(DenseVector a, SparseVector b) {
        return b.foldNonZero(Vectors.asSumFunctionAccumulator(0.0, this.dot(a)));
    }

    @Override
    public Double apply(DenseVector a, DenseVector b) {
        double result = 0.0;
        for (int i = 0; i < a.length(); ++i) {
            result += a.get(i) * b.get(i);
        }
        return result;
    }

    private VectorFunction dot(final Vector b) {
        return new VectorFunction(){

            @Override
            public double evaluate(int i, double value) {
                return b.get(i) * value;
            }
        };
    }

    @Override
    public void ensureApplicableTo(Vector a, Vector b) {
        if (a.length() != b.length()) {
            throw new IllegalArgumentException("Given vectors should have the same length: " + a.length() + " does not equal to " + b.length() + ".");
        }
    }
}

