/*
 * Decompiled with CFR 0.152.
 */
package org.la4j;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.la4j.LinearAlgebra;
import org.la4j.Matrix;
import org.la4j.matrix.MatrixFactory;
import org.la4j.matrix.dense.Basic1DMatrix;
import org.la4j.matrix.dense.Basic2DMatrix;
import org.la4j.matrix.functor.AdvancedMatrixPredicate;
import org.la4j.matrix.functor.MatrixAccumulator;
import org.la4j.matrix.functor.MatrixFunction;
import org.la4j.matrix.functor.MatrixPredicate;
import org.la4j.matrix.functor.MatrixProcedure;
import org.la4j.matrix.sparse.CCSMatrix;
import org.la4j.matrix.sparse.CRSMatrix;

public final class Matrices {
    public static final double EPS = LinearAlgebra.EPS;
    public static final int ROUND_FACTOR = LinearAlgebra.ROUND_FACTOR;
    public static final MatrixPredicate DIAGONAL_MATRIX = new MatrixPredicate(){

        @Override
        public boolean test(int rows, int columns) {
            return rows == columns;
        }

        @Override
        public boolean test(int i, int j, double value) {
            return i == j || Math.abs(value) < EPS;
        }
    };
    public static final MatrixPredicate IDENTITY_MATRIX = new MatrixPredicate(){

        @Override
        public boolean test(int rows, int columns) {
            return rows == columns;
        }

        @Override
        public boolean test(int i, int j, double value) {
            return i == j ? Math.abs(1.0 - value) < EPS : Math.abs(value) < EPS;
        }
    };
    public static final MatrixPredicate ZERO_MATRIX = new MatrixPredicate(){

        @Override
        public boolean test(int rows, int columns) {
            return true;
        }

        @Override
        public boolean test(int i, int j, double value) {
            return Math.abs(value) < EPS;
        }
    };
    public static final MatrixPredicate TRIDIAGONAL_MATRIX = new MatrixPredicate(){

        @Override
        public boolean test(int rows, int columns) {
            return rows == columns;
        }

        @Override
        public boolean test(int i, int j, double value) {
            return Math.abs(i - j) <= 1 || Math.abs(value) < EPS;
        }
    };
    public static final MatrixPredicate POSITIVE_MATRIX = new MatrixPredicate(){

        @Override
        public boolean test(int rows, int columns) {
            return true;
        }

        @Override
        public boolean test(int i, int j, double value) {
            return value > 0.0;
        }
    };
    public static final MatrixPredicate NEGATIVE_MATRIX = new MatrixPredicate(){

        @Override
        public boolean test(int rows, int columns) {
            return true;
        }

        @Override
        public boolean test(int i, int j, double value) {
            return value < 0.0;
        }
    };
    public static final MatrixPredicate LOWER_BIDIAGONAL_MATRIX = new MatrixPredicate(){

        @Override
        public boolean test(int rows, int columns) {
            return rows == columns;
        }

        @Override
        public boolean test(int i, int j, double value) {
            return i != j && i != j + 1 || Math.abs(value) < EPS;
        }
    };
    public static final MatrixPredicate UPPER_BIDIAGONAL_MATRIX = new MatrixPredicate(){

        @Override
        public boolean test(int rows, int columns) {
            return rows == columns;
        }

        @Override
        public boolean test(int i, int j, double value) {
            return i != j && i != j - 1 || Math.abs(value) < EPS;
        }
    };
    public static final MatrixPredicate LOWER_TRIANGULAR_MATRIX = new MatrixPredicate(){

        @Override
        public boolean test(int rows, int columns) {
            return rows == columns;
        }

        @Override
        public boolean test(int i, int j, double value) {
            return i <= j || Math.abs(value) < EPS;
        }
    };
    public static final MatrixPredicate UPPER_TRIANGULAR_MATRIX = new MatrixPredicate(){

        @Override
        public boolean test(int rows, int columns) {
            return rows == columns;
        }

        @Override
        public boolean test(int i, int j, double value) {
            return i >= j || Math.abs(value) < EPS;
        }
    };
    public static final AdvancedMatrixPredicate SYMMETRIC_MATRIX = new SymmetricMatrixPredicate();
    public static final AdvancedMatrixPredicate DIAGONALLY_DOMINANT_MATRIX = new DiagonallyDominantPredicate();
    public static final AdvancedMatrixPredicate POSITIVE_DEFINITE_MATRIX = new PositiveDefiniteMatrixPredicate();
    public static final MatrixFactory<Basic2DMatrix> BASIC_2D = new MatrixFactory<Basic2DMatrix>(){

        @Override
        public Basic2DMatrix apply(int rows, int columns) {
            return Basic2DMatrix.zero(rows, columns);
        }
    };
    public static final MatrixFactory<Basic1DMatrix> BASIC_1D = new MatrixFactory<Basic1DMatrix>(){

        @Override
        public Basic1DMatrix apply(int rows, int columns) {
            return Basic1DMatrix.zero(rows, columns);
        }
    };
    public static final MatrixFactory<Basic2DMatrix> DENSE = BASIC_2D;
    public static final MatrixFactory<CCSMatrix> CCS = new MatrixFactory<CCSMatrix>(){

        @Override
        public CCSMatrix apply(int rows, int columns) {
            return CCSMatrix.zero(rows, columns);
        }
    };
    public static final MatrixFactory<CRSMatrix> CRS = new MatrixFactory<CRSMatrix>(){

        @Override
        public CRSMatrix apply(int rows, int columns) {
            return CRSMatrix.zero(rows, columns);
        }
    };
    public static final MatrixFactory<CRSMatrix> SPARSE = CRS;
    public static final MatrixFactory<CRSMatrix> SPARSE_ROW_MAJOR = CRS;
    public static final MatrixFactory<CCSMatrix> SPARSE_COLUMN_MAJOR = CCS;
    public static final MatrixFactory[] CONVERTERS = new MatrixFactory[]{BASIC_2D, BASIC_1D, CRS, CCS};
    public static final MatrixFunction INC_FUNCTION = new MatrixFunction(){

        @Override
        public double evaluate(int i, int j, double value) {
            return value + 1.0;
        }
    };
    public static final MatrixFunction DEC_FUNCTION = new MatrixFunction(){

        @Override
        public double evaluate(int i, int j, double value) {
            return value - 1.0;
        }
    };
    public static final MatrixFunction INV_FUNCTION = new MatrixFunction(){

        @Override
        public double evaluate(int i, int j, double value) {
            return -value;
        }
    };

    public static MatrixFunction asConstFunction(final double arg) {
        return new MatrixFunction(){

            @Override
            public double evaluate(int i, int j, double value) {
                return arg;
            }
        };
    }

    public static MatrixFunction asPlusFunction(final double arg) {
        return new MatrixFunction(){

            @Override
            public double evaluate(int i, int j, double value) {
                return value + arg;
            }
        };
    }

    public static MatrixFunction asMinusFunction(final double arg) {
        return new MatrixFunction(){

            @Override
            public double evaluate(int i, int j, double value) {
                return value - arg;
            }
        };
    }

    public static MatrixFunction asMulFunction(final double arg) {
        return new MatrixFunction(){

            @Override
            public double evaluate(int i, int j, double value) {
                return value * arg;
            }
        };
    }

    public static MatrixFunction asDivFunction(final double arg) {
        return new MatrixFunction(){

            @Override
            public double evaluate(int i, int j, double value) {
                return value / arg;
            }
        };
    }

    public static MatrixFunction asModFunction(final double arg) {
        return new MatrixFunction(){

            @Override
            public double evaluate(int i, int j, double value) {
                return value % arg;
            }
        };
    }

    public static MatrixAccumulator mkMinAccumulator() {
        return new MatrixAccumulator(){
            private double result = Double.POSITIVE_INFINITY;

            @Override
            public void update(int i, int j, double value) {
                this.result = Math.min(this.result, value);
            }

            @Override
            public double accumulate() {
                double value = this.result;
                this.result = Double.POSITIVE_INFINITY;
                return value;
            }
        };
    }

    public static MatrixAccumulator mkMaxAccumulator() {
        return new MatrixAccumulator(){
            private double result = Double.NEGATIVE_INFINITY;

            @Override
            public void update(int i, int j, double value) {
                this.result = Math.max(this.result, value);
            }

            @Override
            public double accumulate() {
                double value = this.result;
                this.result = Double.NEGATIVE_INFINITY;
                return value;
            }
        };
    }

    public static MatrixAccumulator asSumAccumulator(final double neutral) {
        return new MatrixAccumulator(){
            private BigDecimal result;
            {
                this.result = new BigDecimal(neutral);
            }

            @Override
            public void update(int i, int j, double value) {
                this.result = this.result.add(new BigDecimal(value));
            }

            @Override
            public double accumulate() {
                double value = this.result.setScale(ROUND_FACTOR, RoundingMode.CEILING).doubleValue();
                this.result = new BigDecimal(neutral);
                return value;
            }
        };
    }

    public static MatrixAccumulator asProductAccumulator(final double neutral) {
        return new MatrixAccumulator(){
            private BigDecimal result;
            {
                this.result = new BigDecimal(neutral);
            }

            @Override
            public void update(int i, int j, double value) {
                this.result = this.result.multiply(new BigDecimal(value));
            }

            @Override
            public double accumulate() {
                double value = this.result.setScale(ROUND_FACTOR, RoundingMode.CEILING).doubleValue();
                this.result = new BigDecimal(neutral);
                return value;
            }
        };
    }

    public static MatrixAccumulator asSumFunctionAccumulator(final double neutral, final MatrixFunction function) {
        return new MatrixAccumulator(){
            private final MatrixAccumulator sumAccumulator;
            {
                this.sumAccumulator = Matrices.asSumAccumulator(neutral);
            }

            @Override
            public void update(int i, int j, double value) {
                this.sumAccumulator.update(i, j, function.evaluate(i, j, value));
            }

            @Override
            public double accumulate() {
                return this.sumAccumulator.accumulate();
            }
        };
    }

    public static MatrixAccumulator asProductFunctionAccumulator(final double neutral, final MatrixFunction function) {
        return new MatrixAccumulator(){
            private final MatrixAccumulator productAccumulator;
            {
                this.productAccumulator = Matrices.asProductAccumulator(neutral);
            }

            @Override
            public void update(int i, int j, double value) {
                this.productAccumulator.update(i, j, function.evaluate(i, j, value));
            }

            @Override
            public double accumulate() {
                return this.productAccumulator.accumulate();
            }
        };
    }

    public static MatrixProcedure asAccumulatorProcedure(final MatrixAccumulator accumulator) {
        return new MatrixProcedure(){

            @Override
            public void apply(int i, int j, double value) {
                accumulator.update(i, j, value);
            }
        };
    }

    private static class PositiveDefiniteMatrixPredicate
    implements AdvancedMatrixPredicate {
        private PositiveDefiniteMatrixPredicate() {
        }

        @Override
        public boolean test(Matrix matrix) {
            if (matrix.rows() != matrix.columns()) {
                return false;
            }
            int size = matrix.columns();
            for (int currentSize = 1; currentSize <= size; ++currentSize) {
                Matrix topLeftMatrix = matrix.sliceTopLeft(currentSize, currentSize);
                if (!(topLeftMatrix.determinant() < 0.0)) continue;
                return false;
            }
            return true;
        }
    }

    private static class DiagonallyDominantPredicate
    implements AdvancedMatrixPredicate {
        private DiagonallyDominantPredicate() {
        }

        @Override
        public boolean test(Matrix matrix) {
            if (matrix.rows() != matrix.columns()) {
                return false;
            }
            for (int i = 0; i < matrix.rows(); ++i) {
                double sum = 0.0;
                for (int j = 0; j < matrix.columns(); ++j) {
                    if (i == j) continue;
                    sum += Math.abs(matrix.get(i, j));
                }
                if (!(sum > Math.abs(matrix.get(i, i)) - EPS)) continue;
                return false;
            }
            return true;
        }
    }

    private static class SymmetricMatrixPredicate
    implements AdvancedMatrixPredicate {
        private SymmetricMatrixPredicate() {
        }

        @Override
        public boolean test(Matrix matrix) {
            if (matrix.rows() != matrix.columns()) {
                return false;
            }
            for (int i = 0; i < matrix.rows(); ++i) {
                for (int j = i + 1; j < matrix.columns(); ++j) {
                    double b;
                    double a = matrix.get(i, j);
                    double diff = Math.abs(a - (b = matrix.get(j, i)));
                    if (!(diff / Math.max(Math.abs(a), Math.abs(b)) > EPS)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

