/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.annotation;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.samtools.util.ProgressLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.dropseqrna.annotation.GTFRecord;
import org.broadinstitute.dropseqrna.annotation.GeneFromGTF;
import org.broadinstitute.dropseqrna.annotation.GeneFromGTFBuilder;
import picard.annotation.AnnotationException;
import picard.annotation.Gene;

public class EnhanceGTFRecords {
    private static final Log LOG = Log.getInstance(EnhanceGTFRecords.class);
    public static final String EXON_FEATURE_TYPE = "exon";
    public static final String INTRON_FEATURE_TYPE = "intron";
    public static final String CONSENSUS_INTRON_FEATURE_TYPE = "consensus_intron";
    public static final String GENE_FEATURE_TYPE = "gene";
    public static final String TRANSCRIPT_FEATURE_TYPE = "transcript";

    public List<GTFRecord> enhanceGTFRecords(Iterator<GTFRecord> records) {
        ProgressLogger progressLogger = new ProgressLogger(LOG, 100, "enhancing", "genes");
        ArrayList<GTFRecord> result = new ArrayList<GTFRecord>();
        GeneFromGTFBuilder geneBuilder = new GeneFromGTFBuilder(records);
        while (geneBuilder.hasNext()) {
            try {
                progressLogger.record(new SAMRecord[0]);
                GeneFromGTF gene = geneBuilder.next();
                progressLogger.record(gene.getName(), 0);
                LOG.debug(new Object[]{"Enhancing Gene [" + gene.getName() + "]"});
                result.addAll(this.enhanceGene(gene));
            }
            catch (AnnotationException e) {
                LOG.info(new Object[]{e.getMessage() + " -- skipping"});
            }
        }
        return result;
    }

    public List<GTFRecord> enhanceGene(GeneFromGTF g) {
        ArrayList<GTFRecord> result = new ArrayList<GTFRecord>();
        result.add(this.getGTFRecord(g));
        for (GeneFromGTF.TranscriptFromGTF t : g.getTranscripts()) {
            List<GTFRecord> records = this.enhanceTranscript(t);
            result.addAll(records);
        }
        this.addConsensusIntrons(result);
        return result;
    }

    private void addConsensusIntrons(List<GTFRecord> records) {
        OverlapDetector exons = new OverlapDetector(0, 0);
        for (GTFRecord record : records) {
            if (!record.getFeatureType().equals(EXON_FEATURE_TYPE)) continue;
            exons.addLhs((Object)record, (Locatable)record.getInterval());
        }
        ArrayList<GTFRecord> consensusIntrons = new ArrayList<GTFRecord>();
        for (GTFRecord record : records) {
            if (!record.getFeatureType().equals(INTRON_FEATURE_TYPE) || !exons.getOverlaps((Locatable)record.getInterval()).isEmpty()) continue;
            consensusIntrons.add(new GTFRecord(record.getChromosome(), record.getStart(), record.getEnd(), record.isNegativeStrand(), record.getGeneID(), record.getGeneName(), record.getTranscriptName(), record.getTranscriptID(), record.getTranscriptType(), CONSENSUS_INTRON_FEATURE_TYPE, record.getGeneVersion()));
        }
        records.addAll(consensusIntrons);
    }

    private GTFRecord getGTFRecord(GeneFromGTF g) {
        return new GTFRecord(g.getContig(), g.getStart(), g.getEnd(), g.isNegativeStrand(), g.getGeneID(), g.getName(), null, null, g.getTranscriptType(), GENE_FEATURE_TYPE, g.getGeneVersion());
    }

    private List<GTFRecord> enhanceTranscript(GeneFromGTF.TranscriptFromGTF t) {
        ArrayList<GTFRecord> result = new ArrayList<GTFRecord>();
        GeneFromGTF g = t.getGene();
        GTFRecord transcriptRecord = new GTFRecord(g.getContig(), t.codingStart, t.codingEnd, g.isNegativeStrand(), g.getGeneID(), g.getName(), t.getTranscriptName(), t.getTranscriptID(), t.getTranscriptType(), TRANSCRIPT_FEATURE_TYPE, g.getGeneVersion());
        result.add(transcriptRecord);
        List<Interval> introns = this.getIntronIntervals(this.getIntervals(t.exons));
        List<GTFRecord> intronR = this.getGTFRecordsFromIntronIntervals(introns, t);
        result.addAll(intronR);
        List<GTFRecord> exons = this.getGTFRecordsFromExons(t);
        result.addAll(exons);
        return result;
    }

    private List<GTFRecord> getGTFRecordsFromExons(GeneFromGTF.TranscriptFromGTF t) {
        ArrayList<GTFRecord> result = new ArrayList<GTFRecord>();
        GeneFromGTF g = t.getGene();
        for (Gene.Transcript.Exon e : t.exons) {
            GTFRecord exonRecord = new GTFRecord(g.getContig(), e.start, e.end, g.isNegativeStrand(), g.getGeneID(), g.getName(), t.getTranscriptName(), t.getTranscriptID(), t.getTranscriptType(), EXON_FEATURE_TYPE, g.getGeneVersion());
            result.add(exonRecord);
        }
        return result;
    }

    private List<GTFRecord> getGTFRecordsFromIntronIntervals(List<Interval> introns, GeneFromGTF.TranscriptFromGTF t) {
        ArrayList<GTFRecord> result = new ArrayList<GTFRecord>();
        GeneFromGTF g = t.getGene();
        for (Interval i : introns) {
            GTFRecord intronRecord = new GTFRecord(g.getContig(), i.getStart(), i.getEnd(), g.isNegativeStrand(), g.getGeneID(), g.getName(), t.getTranscriptName(), t.getTranscriptID(), t.getTranscriptType(), INTRON_FEATURE_TYPE, g.getGeneVersion());
            result.add(intronRecord);
        }
        return result;
    }

    List<Interval> getIntronIntervals(List<Interval> exons) {
        if (exons.size() == 1) {
            return new ArrayList<Interval>(0);
        }
        ArrayList<Interval> result = new ArrayList<Interval>(exons.size() - 1);
        for (int i = 0; i < exons.size() - 1; ++i) {
            int s = exons.get(i).getEnd() + 1;
            int e = exons.get(i + 1).getStart() - 1;
            Interval intron = new Interval(null, s, e);
            result.add(intron);
        }
        return result;
    }

    List<Interval> getIntervals(Gene.Transcript.Exon[] exons) {
        ArrayList<Interval> result = new ArrayList<Interval>();
        for (Gene.Transcript.Exon e : exons) {
            result.add(new Interval(null, e.start, e.end));
        }
        return result;
    }
}

