/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.annotation;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.broadinstitute.dropseqrna.annotation.GTFParser;
import org.broadinstitute.dropseqrna.annotation.GTFRecord;
import org.broadinstitute.dropseqrna.annotation.GeneFromGTF;
import org.broadinstitute.dropseqrna.annotation.GeneFromGTFBuilder;
import org.broadinstitute.dropseqrna.utils.DropSeqSamUtil;
import org.broadinstitute.dropseqrna.utils.FilteredIterator;
import picard.annotation.AnnotationException;

public class GTFReader {
    private static final Log LOG = Log.getInstance(GTFReader.class);
    private final File gtfFlatFile;
    private final SAMSequenceDictionary sequenceDictionary;
    private final Set<String> skippedChromosomeTranscriptDescription = new HashSet<String>();
    private final Set<String> unrecognizedSequences = new HashSet<String>();

    public GTFReader(File gtfFlatFile, SAMSequenceDictionary sequenceDictionary) {
        this.gtfFlatFile = gtfFlatFile;
        this.sequenceDictionary = sequenceDictionary;
    }

    public GTFReader(File gtfFlatFile, File sequenceDictionary) {
        this(gtfFlatFile, DropSeqSamUtil.loadSequenceDictionary(sequenceDictionary));
    }

    static OverlapDetector<GeneFromGTF> load(File refFlatFile, SAMSequenceDictionary sequenceDictionary) {
        return new GTFReader(refFlatFile, sequenceDictionary).load();
    }

    public OverlapDetector<GeneFromGTF> load() {
        FilteringGTFParser parser = new FilteringGTFParser(this.gtfFlatFile);
        GeneFromGTFBuilder geneBuilder = new GeneFromGTFBuilder((Iterator<GTFRecord>)((Object)parser));
        CloserUtil.close((Object)((Object)parser));
        OverlapDetector overlapDetector = new OverlapDetector(0, 0);
        int longestInterval = 0;
        int numIntervalsOver1MB = 0;
        while (geneBuilder.hasNext()) {
            try {
                GeneFromGTF gene = geneBuilder.next();
                overlapDetector.addLhs((Object)gene, (Locatable)gene);
                if (gene.length() > longestInterval) {
                    longestInterval = gene.length();
                }
                if (gene.length() <= 1000000) continue;
                ++numIntervalsOver1MB;
            }
            catch (AnnotationException e) {
                LOG.info(new Object[]{e.getMessage() + " -- skipping"});
            }
        }
        LOG.debug(new Object[]{"Longest gene: " + longestInterval + "; number of genes > 1MB: " + numIntervalsOver1MB});
        LOG.debug(new Object[]{"Total number of genes loaded [" + overlapDetector.getAll().size() + "]"});
        return overlapDetector;
    }

    public Set<String> getUnrecognizedSequences() {
        return this.unrecognizedSequences;
    }

    private boolean isSequenceRecognized(String sequence) {
        return this.sequenceDictionary.getSequence(sequence) != null;
    }

    private class FilteringGTFParser
    extends FilteredIterator<GTFRecord> {
        private FilteringGTFParser(File gtf) {
            super(new GTFParser(gtf, ValidationStringency.STRICT));
        }

        @Override
        public boolean filterOut(GTFRecord rec) {
            if (!GTFReader.this.isSequenceRecognized(rec.getChromosome())) {
                GTFReader.this.unrecognizedSequences.add(rec.getChromosome());
                String transcriptDescription = rec.getGeneName() + ":" + rec.getTranscriptName();
                if (GTFReader.this.skippedChromosomeTranscriptDescription.add(transcriptDescription + "\t" + rec.getChromosome())) {
                    LOG.debug(new Object[]{"Skipping " + transcriptDescription + " due to unrecognized sequence " + rec.getChromosome()});
                }
                return true;
            }
            return false;
        }
    }
}

