/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils;

import htsjdk.samtools.metrics.MetricBase;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.dropseqrna.utils.Bases;

public class BaseDistributionMetric
extends MetricBase {
    private Map<Character, Integer> map = new HashMap<Character, Integer>();

    public BaseDistributionMetric() {
        this.map.put(Bases.A.getBase(), 0);
        this.map.put(Bases.C.getBase(), 0);
        this.map.put(Bases.G.getBase(), 0);
        this.map.put(Bases.T.getBase(), 0);
        this.map.put(Bases.N.getBase(), 0);
    }

    void addBase(Character base) {
        int count = this.map.get(base);
        this.map.put(base, ++count);
    }

    public int getCount(Character base) {
        return this.map.get(base);
    }

    public int getTotalCount() {
        int count = 0;
        for (Bases b : Bases.values()) {
            char bb = b.getBase().charValue();
            count += this.map.get(Character.valueOf(bb)).intValue();
        }
        return count;
    }

    public String toString() {
        return this.map.toString();
    }
}

