/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ProgressLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.broadinstitute.dropseqrna.cmdline.DropSeq;
import org.broadinstitute.dropseqrna.utils.BaseRange;
import org.broadinstitute.dropseqrna.utils.CustomBAMIterators;
import org.broadinstitute.dropseqrna.utils.OutputWriterUtil;
import org.broadinstitute.dropseqrna.utils.SamHeaderUtil;
import org.broadinstitute.dropseqrna.utils.readpairs.ReadPair;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;

@CommandLineProgramProperties(usage="Adds a BAM tag to every read of the defined range of bases of the sequence of the 1st or 2nd read.  Reads must be paired for this program to run.", usageShort="Moves specified bases of each read pair into a tag", programGroup=DropSeq.class)
public class TagBamWithReadSequenceExtended
extends CommandLineProgram {
    private final Log log = Log.getInstance(TagBamWithReadSequenceExtended.class);
    @Option(shortName="I", doc="The input SAM or BAM file to analyze.")
    public File INPUT;
    @Option(shortName="O", doc="Output bam")
    public File OUTPUT;
    @Option(doc="Summary of barcode base quality", optional=true)
    public File SUMMARY;
    @Option(doc="Base range to extract, seperated by a dash.  IE: 1-4.  Can extract multiple ranges by seperating them by a colon.  For example 1-4:17-22 extracts the first 4 bases, then the 17-22 bases, and glues the sequence together into a single sequence for a tag.")
    public String BASE_RANGE;
    @Option(doc="The sequence can be from the first or second read [1/2].  ")
    public Integer BARCODED_READ;
    @Option(doc="Add the tag to the sequence the read came from? If false, the read that does not have the barcode gets the tag.  If true, set the tag on the barcoded read.")
    public Boolean TAG_BARCODED_READ = false;
    @Option(doc="Discard the read the sequence came from?.  If this is true, then the remaining read is marked as unpaired.  If the read is unpaired, then you can't discard a read.")
    public Boolean DISCARD_READ = false;
    @Option(doc="Should the bases selected for the tag be hard clipped from the read?  BE VERY CAREFUL WITH THIS FEATURE, FOR EXPERTS ONLY.  NOT NEEDED FOR STANDARD DROPSEQ DATA PROCESSING.Don't use on aligned data, does NOT change cigar strings")
    public Boolean HARD_CLIP_BASES = false;
    @Option(doc="Minimum base quality required for barcode")
    public Integer BASE_QUALITY = 10;
    @Option(doc="Number of bases below minimum base quality to fail the barcode.")
    public Integer NUM_BASES_BELOW_QUALITY = 1;
    @Option(doc="Barcode tag.  This is typically X plus one more capitalized alpha.  For example, 'XS', which is the default.")
    public String TAG_NAME = "XS";
    private String TAG_QUALITY = "XQ";
    private FailedBaseMetric metric = null;

    protected int doWork() {
        if (this.TAG_BARCODED_READ.booleanValue() && this.DISCARD_READ.booleanValue()) {
            this.log.error(new Object[]{"If TAG_BARCODED_READ=true and DISCARD_READ=true, you're throwing away the tag with the read. Stopping"});
            System.exit(1);
        }
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SamReader inputSam = SamReaderFactory.makeDefault().open(this.INPUT);
        SAMFileHeader h = inputSam.getFileHeader();
        PeekableIterator iter = new PeekableIterator(CustomBAMIterators.getQuerynameSortedRecords(inputSam));
        SamHeaderUtil.addPgRecord(h, this);
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(h, true, this.OUTPUT);
        List<BaseRange> baseRanges = BaseRange.parseBaseRange(this.BASE_RANGE);
        this.metric = new FailedBaseMetric(BaseRange.getTotalRangeSize(this.BASE_RANGE));
        ProgressLogger progress = new ProgressLogger(this.log);
        while (iter.hasNext()) {
            SAMRecord r1 = (SAMRecord)iter.next();
            SAMRecord r2 = (SAMRecord)iter.peek();
            boolean sameName = false;
            if (r2 != null) {
                sameName = r1.getReadName().equals(r2.getReadName());
            }
            if (!sameName) {
                this.processSingleRead(r1, baseRanges, writer, this.HARD_CLIP_BASES);
                continue;
            }
            ReadPair p = new ReadPair(r1, r2);
            if (!p.testProperlyPaired()) {
                this.log.error(new Object[]{"Reads not properly paired! R1: " + r1.getReadName() + " R2: " + r2.getReadName()});
                System.exit(1);
            }
            r2 = (SAMRecord)iter.next();
            r1 = p.getRead1();
            r2 = p.getRead2();
            if (this.BARCODED_READ == 1) {
                this.processReadPair(r1, r2, baseRanges, writer, this.DISCARD_READ);
            }
            if (this.BARCODED_READ == 2) {
                this.processReadPair(r2, r1, baseRanges, writer, this.DISCARD_READ);
            }
            progress.record(r1);
            progress.record(r2);
        }
        writer.close();
        if (this.SUMMARY != null) {
            this.writeOutput(this.metric, this.SUMMARY);
        }
        CloserUtil.close((Object)inputSam);
        CloserUtil.close((Object)iter);
        return 0;
    }

    void processSingleRead(SAMRecord barcodedRead, List<BaseRange> baseRanges, SAMFileWriter writer, boolean hardClipBases) {
        int numBadBases = this.scoreBaseQuality(barcodedRead, baseRanges);
        String seq = barcodedRead.getReadString();
        seq = BaseRange.getSequenceForBaseRange(baseRanges, seq);
        if (numBadBases >= this.NUM_BASES_BELOW_QUALITY) {
            Object o = barcodedRead.getAttribute(this.TAG_QUALITY);
            if (o != null) {
                int oldNumBadBases = (Integer)o;
                numBadBases += oldNumBadBases;
            }
            barcodedRead.setAttribute(this.TAG_QUALITY, (Object)numBadBases);
        }
        barcodedRead.setAttribute(this.TAG_NAME, (Object)seq);
        SAMRecord result = barcodedRead;
        if (hardClipBases) {
            result = TagBamWithReadSequenceExtended.hardClipBasesFromRead(barcodedRead, baseRanges);
        }
        writer.addAlignment(result);
    }

    static SAMRecord hardClipBasesFromRead(SAMRecord r, List<BaseRange> baseRanges) {
        int readLength = r.getReadLength();
        List<BaseRange> basesToKeep = BaseRange.invert(baseRanges, readLength);
        byte[] newSequence = BaseRange.getBytesForBaseRange(basesToKeep, r.getReadBases());
        byte[] newBaseQualities = BaseRange.getBytesForBaseRange(basesToKeep, r.getBaseQualities());
        r.setReadBases(newSequence);
        r.setBaseQualities(newBaseQualities);
        return r;
    }

    private SAMRecord setTagsOnRead(SAMRecord r, int numBadBases, String seq) {
        if (numBadBases >= this.NUM_BASES_BELOW_QUALITY) {
            Object o = r.getAttribute(this.TAG_QUALITY);
            if (o != null) {
                int oldNumBadBases = (Integer)o;
                numBadBases += oldNumBadBases;
            }
            r.setAttribute(this.TAG_QUALITY, (Object)numBadBases);
        }
        r.setAttribute(this.TAG_NAME, (Object)seq);
        return r;
    }

    void processReadPair(SAMRecord barcodedRead, SAMRecord otherRead, List<BaseRange> baseRanges, SAMFileWriter writer, boolean discardRead) {
        int numBadBases = this.scoreBaseQuality(barcodedRead, baseRanges);
        String seq = barcodedRead.getReadString();
        seq = BaseRange.getSequenceForBaseRange(baseRanges, seq);
        if (this.TAG_BARCODED_READ.booleanValue()) {
            this.setTagsOnRead(barcodedRead, numBadBases, seq);
        } else {
            this.setTagsOnRead(otherRead, numBadBases, seq);
        }
        if (discardRead) {
            int flag = otherRead.getFlags();
            if (otherRead.getMateUnmappedFlag()) {
                flag -= 8;
            }
            if (otherRead.getMateNegativeStrandFlag()) {
                flag -= 32;
            }
            if (otherRead.getReadPairedFlag()) {
                --flag;
            }
            if (otherRead.getFirstOfPairFlag()) {
                flag -= 64;
            }
            if (otherRead.getSecondOfPairFlag()) {
                flag -= 128;
            }
            otherRead.setFlags(flag);
        } else {
            writer.addAlignment(barcodedRead);
        }
        writer.addAlignment(otherRead);
    }

    private int scoreBaseQuality(SAMRecord barcodedRead, List<BaseRange> baseRanges) {
        int numBasesBelowQuality = 0;
        byte[] qual = barcodedRead.getBaseQualities();
        char[] seq = barcodedRead.getReadString().toUpperCase().toCharArray();
        for (BaseRange b : baseRanges) {
            for (int i = b.getStart() - 1; i < b.getEnd(); ++i) {
                byte q = qual[i];
                char s = seq[i];
                if (q >= this.BASE_QUALITY && s != 'N') continue;
                ++numBasesBelowQuality;
            }
        }
        this.metric.addFailedBase(numBasesBelowQuality);
        return numBasesBelowQuality;
    }

    private void writeOutput(FailedBaseMetric result, File output) {
        BufferedWriter writer = OutputWriterUtil.getWriter(output);
        Object[] header = new String[]{"num_failed_bases", "num_barcodes"};
        String h = StringUtils.join((Object[])header, (String)"\t");
        OutputWriterUtil.writeResult(h, writer);
        for (int i = 0; i < result.getLength(); ++i) {
            int count = result.getNumFailedBases(i);
            Object[] l = new String[]{i + "", count + ""};
            String line = StringUtils.join((Object[])l, (String)"\t");
            OutputWriterUtil.writeResult(line, writer);
        }
        OutputWriterUtil.closeWriter(writer);
    }

    public static void main(String[] args) {
        System.exit(new TagBamWithReadSequenceExtended().instanceMain(args));
    }

    private class FailedBaseMetric {
        List<Integer> data = null;

        public FailedBaseMetric(Integer length) {
            this.data = new ArrayList<Integer>(length + 1);
            for (int i = 0; i <= length; ++i) {
                this.data.add(new Integer(0));
            }
        }

        public void addFailedBase(int numBasesFailed) {
            Integer i;
            Integer n = i = this.data.get(numBasesFailed);
            Integer n2 = i = Integer.valueOf(i + 1);
            this.data.set(numBasesFailed, i);
        }

        public int getNumFailedBases(int position) {
            return this.data.get(position);
        }

        public int getLength() {
            return this.data.size();
        }
    }
}

