/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.editdistance;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.dropseqrna.cmdline.DropSeq;
import org.broadinstitute.dropseqrna.utils.FilteredIterator;
import org.broadinstitute.dropseqrna.utils.GroupingIterator;
import org.broadinstitute.dropseqrna.utils.MultiComparator;
import org.broadinstitute.dropseqrna.utils.ObjectCounter;
import org.broadinstitute.dropseqrna.utils.PeekableGroupingIterator;
import org.broadinstitute.dropseqrna.utils.StringTagComparator;
import org.broadinstitute.dropseqrna.utils.editdistance.CollapseBarcodeThreaded;
import org.broadinstitute.dropseqrna.utils.editdistance.MapBarcodesByEditDistance;
import org.broadinstitute.dropseqrna.utils.readiterators.MapQualityFilteredIterator;
import org.broadinstitute.dropseqrna.utils.readiterators.MissingTagFilteringIterator;
import org.broadinstitute.dropseqrna.utils.readiterators.SamRecordSortingIteratorFactory;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;

@CommandLineProgramProperties(usage="Collapse set of barcodes that all share the same BAM tags.  For example, collapse all UMIs that have the same cell, gene, and gene strand tags.  This would be equivilent to collapsing the UMIs in DGE.", usageShort="Collapse barcodes in the context of one or more tags.)", programGroup=DropSeq.class)
public class CollapseTagWithContext
extends CommandLineProgram {
    private static final Log log = Log.getInstance(CollapseTagWithContext.class);
    @Option(shortName="I", doc="The input SAM or BAM file to analyze.  Must be coordinate sorted. ", optional=false)
    public File INPUT;
    @Option(doc="Collapse tags that are within <EDIT_DISTANCE>, and have the same CONTEXT_TAGS.  For example, if your context tags were cell and gene, you could collapse UMI tags.", optional=false)
    public String COLLAPSE_TAG;
    @Option(doc="Group reads by these read tags.  Collapse the COLLAPSE_TAG values that have the same CONTEXT_TAGS values.  Reads with unset CONTEXT_TAGS that will be grouped together and loaded into memory together.  This can cause a large amount of memory usage if you pick a lot of tags that are all mostly not set.", minElements=1)
    public List<String> CONTEXT_TAGS;
    @Option(doc="The output tag for the newly collapsed tag values")
    public String OUT_TAG;
    @Option(shortName="O", doc="Output BAM file with the new collapsed tag.", optional=false)
    public File OUTPUT;
    @Option(doc="The edit distance to collapse tags")
    public Integer EDIT_DISTANCE = 1;
    @Option(doc="Should indels be considered in edit distance calculations?  Doing this correctly is far slower than a simple edit distance test, but gives a more complete result.")
    public boolean FIND_INDELS = false;
    @Option(doc="Read quality filter.  Filters all reads lower than this mapping quality.  Defaults to 10.  Set to 0 to not filter reads by map quality.")
    public Integer READ_MQ = 10;
    @Option(doc="Number of threads to use.  Defaults to 1.")
    public int NUM_THREADS = 1;
    private CollapseBarcodeThreaded cbt = null;
    private int threadedBlockSize = 20000;
    private MapBarcodesByEditDistance med;

    protected int doWorkOld() {
        this.med = new MapBarcodesByEditDistance(false, this.NUM_THREADS, 0);
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SamReader reader = SamReaderFactory.makeDefault().open(this.INPUT);
        SAMFileWriter writer = this.getWriter(reader);
        GroupingIterator<SAMRecord> groupingIter = this.orderReadsByTags(reader, this.COLLAPSE_TAG, this.CONTEXT_TAGS, this.READ_MQ);
        Iterator iter = groupingIter.iterator();
        ProgressLogger pl = new ProgressLogger(log);
        log.info(new Object[]{"Collapsing tag and writing results"});
        FilteredIterator<SAMRecord> mapFilter = this.getMapFilteringIterator(this.READ_MQ);
        FilteredIterator<SAMRecord> tagFilter = this.getMissingTagIterator(this.COLLAPSE_TAG, this.CONTEXT_TAGS);
        int maxNumInformativeReadsInMemory = 0;
        while (iter.hasNext()) {
            boolean verbose = false;
            HashSet allRecs = new HashSet((Collection)iter.next());
            Set<SAMRecord> informativeRecs = allRecs.stream().filter(x -> !mapFilter.filterOut((SAMRecord)x)).filter(x -> !tagFilter.filterOut((SAMRecord)x)).collect(Collectors.toSet());
            if (informativeRecs.size() > maxNumInformativeReadsInMemory) {
                maxNumInformativeReadsInMemory = informativeRecs.size();
                if (maxNumInformativeReadsInMemory >= 1000) {
                    log.info(new Object[]{"Max informative reads in memory [" + maxNumInformativeReadsInMemory + "]"});
                }
                verbose = true;
            }
            allRecs.removeAll(informativeRecs);
            List<SAMRecord> result = this.processRecordList(informativeRecs, this.COLLAPSE_TAG, this.OUT_TAG, this.FIND_INDELS, this.EDIT_DISTANCE, verbose);
            result.stream().forEach(arg_0 -> ((SAMFileWriter)writer).addAlignment(arg_0));
            pl.record((SAMRecord[])result.stream().toArray(SAMRecord[]::new));
            allRecs.stream().forEach(arg_0 -> ((SAMFileWriter)writer).addAlignment(arg_0));
            pl.record((SAMRecord[])allRecs.stream().toArray(SAMRecord[]::new));
        }
        log.info(new Object[]{"Re-sorting output BAM in genomic order."});
        CloserUtil.close(groupingIter);
        CloserUtil.close((Object)reader);
        writer.close();
        log.info(new Object[]{"DONE"});
        return 0;
    }

    protected int doWork() {
        this.med = new MapBarcodesByEditDistance(false, this.NUM_THREADS, 0);
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SamReader reader = SamReaderFactory.makeDefault().open(this.INPUT);
        SAMFileWriter writer = this.getWriter(reader);
        PeekableGroupingIterator<SAMRecord> groupingIter = this.orderReadsByTagsPeekable(reader, this.COLLAPSE_TAG, this.CONTEXT_TAGS, this.READ_MQ);
        ProgressLogger pl = new ProgressLogger(log);
        log.info(new Object[]{"Collapsing tag and writing results"});
        FilteredIterator<SAMRecord> mapFilter = this.getMapFilteringIterator(this.READ_MQ);
        FilteredIterator<SAMRecord> tagFilter = this.getMissingTagIterator(this.COLLAPSE_TAG, this.CONTEXT_TAGS);
        int maxNumInformativeReadsInMemory = 1000;
        while (groupingIter.hasNext()) {
            SAMRecord r = groupingIter.next();
            List<SAMRecord> informativeRecs = new ArrayList<SAMRecord>();
            informativeRecs = this.getInformativeRead(r, informativeRecs, this.COLLAPSE_TAG, this.OUT_TAG, mapFilter, tagFilter, writer, pl);
            while (groupingIter.hasNextInGroup()) {
                r = groupingIter.next();
                informativeRecs = this.getInformativeRead(r, informativeRecs, this.COLLAPSE_TAG, this.OUT_TAG, mapFilter, tagFilter, writer, pl);
            }
            boolean verbose = false;
            if (informativeRecs.size() > maxNumInformativeReadsInMemory) {
                maxNumInformativeReadsInMemory = informativeRecs.size();
                log.info(new Object[]{"Max informative reads in memory [" + maxNumInformativeReadsInMemory + "]"});
                verbose = true;
            }
            List<SAMRecord> result = this.processRecordList(informativeRecs, this.COLLAPSE_TAG, this.OUT_TAG, this.FIND_INDELS, this.EDIT_DISTANCE, verbose);
            result.stream().forEach(arg_0 -> ((SAMFileWriter)writer).addAlignment(arg_0));
        }
        log.info(new Object[]{"Re-sorting output BAM in genomic order."});
        CloserUtil.close(groupingIter);
        CloserUtil.close((Object)reader);
        writer.close();
        log.info(new Object[]{"DONE"});
        return 0;
    }

    private List<SAMRecord> getInformativeRead(SAMRecord r, List<SAMRecord> informativeReads, String collapseTag, String outTag, FilteredIterator<SAMRecord> mapFilter, FilteredIterator<SAMRecord> tagFilter, SAMFileWriter writer, ProgressLogger pl) {
        boolean informative;
        pl.record(r);
        boolean bl = informative = !mapFilter.filterOut(r) && !tagFilter.filterOut(r);
        if (!informative) {
            String v = r.getStringAttribute(collapseTag);
            if (v != null) {
                r.setAttribute(outTag, (Object)v);
            }
            writer.addAlignment(r);
        } else {
            informativeReads.add(r);
        }
        return informativeReads;
    }

    private List<SAMRecord> processRecordList(Collection<SAMRecord> informativeRecs, String collapseTag, String outTag, boolean findIndels, int editDistance, boolean verbose) {
        List<String> barcodes = informativeRecs.stream().map(x -> x.getStringAttribute(collapseTag)).collect(Collectors.toList());
        Map<String, String> collapseMap = this.collapseBarcodes(barcodes, findIndels, editDistance, verbose);
        ArrayList<SAMRecord> result = new ArrayList<SAMRecord>();
        for (SAMRecord r : informativeRecs) {
            String tagValue = r.getStringAttribute(collapseTag);
            if (tagValue != null) {
                if (collapseMap.containsKey(tagValue)) {
                    tagValue = collapseMap.get(tagValue);
                }
                r.setAttribute(outTag, (Object)tagValue);
            }
            result.add(r);
        }
        return result;
    }

    private SAMFileWriter getWriter(SamReader reader) {
        SAMFileHeader header = reader.getFileHeader();
        String context = StringUtil.join((String)" ", this.CONTEXT_TAGS);
        header.addComment("Edit distance collapsed tag " + this.COLLAPSE_TAG + " to new tag " + this.OUT_TAG + " with edit distance " + this.EDIT_DISTANCE + "using indels=" + this.FIND_INDELS + " in the context of tags [" + context + "]");
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(header, false, this.OUTPUT);
        return writer;
    }

    private Map<String, String> collapseBarcodes(List<String> barcodes, boolean findIndels, int editDistance, boolean verbose) {
        ObjectCounter<String> barcodeCounts = new ObjectCounter<String>();
        barcodes.stream().forEach(x -> barcodeCounts.increment((String)x));
        if (verbose) {
            log.info(new Object[]{"Collapsing [" + barcodeCounts.getSize() + "] barcodes."});
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, List<String>> r = this.med.collapseBarcodes(barcodeCounts, findIndels, editDistance);
        for (String key : r.keySet()) {
            for (String value : r.get(key)) {
                result.put(value, key);
            }
        }
        return result;
    }

    private GroupingIterator<SAMRecord> orderReadsByTags(SamReader reader, String collapseTag, List<String> contextTag, int mapQuality) {
        StringTagComparator[] comparators = (StringTagComparator[])contextTag.stream().map(x -> new StringTagComparator((String)x)).toArray(StringTagComparator[]::new);
        MultiComparator<SAMRecord> multiComparator = new MultiComparator<SAMRecord>(comparators);
        CloseableIterator<SAMRecord> sortedIter = SamRecordSortingIteratorFactory.create(reader.getFileHeader(), (Iterator<SAMRecord>)reader.iterator(), multiComparator, new ProgressLogger(log));
        GroupingIterator<SAMRecord> groupedIterator = new GroupingIterator<SAMRecord>((Iterator<SAMRecord>)sortedIter, (Comparator<SAMRecord>)multiComparator);
        return groupedIterator;
    }

    private PeekableGroupingIterator<SAMRecord> orderReadsByTagsPeekable(SamReader reader, String collapseTag, List<String> contextTag, int mapQuality) {
        StringTagComparator[] comparators = (StringTagComparator[])contextTag.stream().map(x -> new StringTagComparator((String)x)).toArray(StringTagComparator[]::new);
        MultiComparator<SAMRecord> multiComparator = new MultiComparator<SAMRecord>(comparators);
        CloseableIterator<SAMRecord> sortedIter = SamRecordSortingIteratorFactory.create(reader.getFileHeader(), (Iterator<SAMRecord>)reader.iterator(), multiComparator, new ProgressLogger(log));
        PeekableGroupingIterator<SAMRecord> groupedIterator = new PeekableGroupingIterator<SAMRecord>((Iterator<SAMRecord>)sortedIter, (Comparator<SAMRecord>)multiComparator);
        return groupedIterator;
    }

    private boolean testReadInformative(SAMRecord r, FilteredIterator<SAMRecord> mapFilter, FilteredIterator<SAMRecord> tagFilter) {
        return !mapFilter.filterOut(r) && !tagFilter.filterOut(r);
    }

    private FilteredIterator<SAMRecord> getMapFilteringIterator(int mapQuality) {
        MapQualityFilteredIterator mapFilteringIterator = new MapQualityFilteredIterator(Collections.emptyIterator(), mapQuality, false);
        return mapFilteringIterator;
    }

    private FilteredIterator<SAMRecord> getMissingTagIterator(String collapseTag, List<String> contextTag) {
        ArrayList<String> allTags = new ArrayList<String>(contextTag);
        allTags.add(collapseTag);
        String[] tagArray = (String[])allTags.stream().toArray(String[]::new);
        MissingTagFilteringIterator missingTagIterator = new MissingTagFilteringIterator(Collections.emptyIterator(), tagArray);
        return missingTagIterator;
    }

    public static void main(String[] args) {
        System.exit(new CollapseTagWithContext().instanceMain(args));
    }
}

