/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.readiterators;

import htsjdk.samtools.SAMRecord;
import java.util.Iterator;
import org.broadinstitute.dropseqrna.barnyard.Utils;
import org.broadinstitute.dropseqrna.utils.FilteredIterator;

public class GeneStrandFilteringIterator
extends FilteredIterator<SAMRecord> {
    private final String strandTag;

    protected GeneStrandFilteringIterator(Iterator<SAMRecord> underlyingIterator, String strandTag) {
        super(underlyingIterator);
        this.strandTag = strandTag;
    }

    @Override
    public boolean filterOut(SAMRecord rec) {
        String geneStrand = rec.getStringAttribute(this.strandTag);
        if (geneStrand == null) {
            return false;
        }
        String[] strands = geneStrand.split(",");
        String readStrandString = Utils.strandToString(!rec.getReadNegativeStrandFlag());
        for (String s : strands) {
            if (s.equals(readStrandString)) continue;
            return true;
        }
        return false;
    }
}

