/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.readiterators;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.ProgressLogger;
import java.util.Comparator;
import java.util.Iterator;
import org.broadinstitute.dropseqrna.utils.SortingIteratorFactory;

public class SamRecordSortingIteratorFactory {
    public static CloseableIterator<SAMRecord> create(SAMFileHeader header, Iterator<SAMRecord> underlyingIterator, Comparator<SAMRecord> comparator, final ProgressLogger progressLogger) {
        SortingIteratorFactory.ProgressCallback<SAMRecord> progressCallback = progressLogger != null ? new SortingIteratorFactory.ProgressCallback<SAMRecord>(){

            @Override
            public void logProgress(SAMRecord record) {
                progressLogger.record(record);
            }
        } : null;
        return SortingIteratorFactory.create(SAMRecord.class, underlyingIterator, comparator, new BAMRecordCodec(header), SAMFileWriterImpl.getDefaultMaxRecordsInRam(), progressCallback);
    }
}

