/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.barnyard;

import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.dropseqrna.TranscriptomeException;
import picard.util.BasicInputParser;

public class ParseBarcodeFile {
    public static List<String> readCellBarcodeFile(File input) {
        IOUtil.assertFileIsReadable((File)input);
        ArrayList<String> result = new ArrayList<String>();
        BasicInputParser parser = new BasicInputParser(false, 1, new File[]{input});
        while (parser.hasNext()) {
            String[] line = (String[])parser.next();
            result.add(line[0]);
        }
        parser.close();
        return result;
    }

    public static Map<String, Set<String>> readCellClusterFile(File input) {
        String[] header;
        IOUtil.assertFileIsReadable((File)input);
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        BasicInputParser parser = new BasicInputParser(false, 2, new File[]{input});
        if (!(!parser.hasNext() || (header = (String[])parser.next())[0].equals("CLUSTER") && header[1].equals("BARCODE"))) {
            throw new TranscriptomeException("The expected header for a cluster file is CLUSTER    BARCODE (tab separaterd)");
        }
        while (parser.hasNext()) {
            String[] line = (String[])parser.next();
            String cluster = line[0];
            String barcode = line[1];
            HashSet<String> c = (HashSet<String>)result.get(cluster);
            if (c == null) {
                c = new HashSet<String>();
            }
            c.add(barcode);
            result.put(cluster, c);
        }
        return result;
    }
}

