/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.barnyard.digitalexpression;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.broadinstitute.dropseqrna.barnyard.digitalexpression.DgeHeaderCommand;
import org.broadinstitute.dropseqrna.barnyard.digitalexpression.DgeHeaderLibrary;

public class DgeHeader {
    public static String CURRENT_VERSION = "1.1";
    private String version = CURRENT_VERSION;
    private ExpressionFormat expressionFormat = ExpressionFormat.raw;
    private LinkedHashMap<String, DgeHeaderLibrary> libraries = new LinkedHashMap();
    private ArrayList<DgeHeaderCommand> commands = new ArrayList();

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ExpressionFormat getExpressionFormat() {
        return this.expressionFormat;
    }

    public void setExpressionFormat(ExpressionFormat expressionFormat) {
        this.expressionFormat = expressionFormat;
    }

    public DgeHeaderLibrary addLibrary(DgeHeaderLibrary library) {
        return this.libraries.put(library.getPrefix(), library);
    }

    public DgeHeaderLibrary getLibrary(String prefix) {
        return this.libraries.get(prefix);
    }

    public DgeHeaderLibrary getLibrary(int i) {
        if (this.libraries.size() <= i) {
            throw new IllegalArgumentException("Requested library " + i + " but there are only " + this.libraries.size() + " libraries in DgeHeader");
        }
        Iterator<DgeHeaderLibrary> it = this.libraries.values().iterator();
        while (i-- > 0) {
            it.next();
        }
        return it.next();
    }

    public DgeHeaderLibrary removeLibrary(String prefix) {
        return (DgeHeaderLibrary)this.libraries.remove(prefix);
    }

    public DgeHeaderLibrary removeLibrary(int i) {
        if (this.libraries.size() <= i) {
            throw new IllegalArgumentException("Requested library " + i + " but there are only " + this.libraries.size() + " libraries in DgeHeader");
        }
        Iterator<DgeHeaderLibrary> it = this.libraries.values().iterator();
        while (i-- > 0) {
            it.next();
        }
        DgeHeaderLibrary ret = it.next();
        it.remove();
        return ret;
    }

    public int getNumLibraries() {
        return this.libraries.size();
    }

    public Iterator<String> iterateLibraries() {
        return this.libraries.keySet().iterator();
    }

    public void addCommand(DgeHeaderCommand command) {
        this.commands.add(command);
    }

    public void addCommand(String maybeNullCommandLine) {
        if (maybeNullCommandLine != null) {
            this.addCommand(new DgeHeaderCommand(maybeNullCommandLine));
        }
    }

    public DgeHeaderCommand getCommand(int i) {
        return this.commands.get(i);
    }

    public DgeHeaderCommand removeCommand(int i) {
        return this.commands.remove(i);
    }

    public int getNumCommands() {
        return this.commands.size();
    }

    public Iterator<DgeHeaderCommand> iterateCommands() {
        return this.commands.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DgeHeader dgeHeader = (DgeHeader)o;
        if (this.version != null ? !this.version.equals(dgeHeader.version) : dgeHeader.version != null) {
            return false;
        }
        if (this.expressionFormat != dgeHeader.expressionFormat) {
            return false;
        }
        return this.libraries.equals(dgeHeader.libraries);
    }

    public int hashCode() {
        int result = this.version != null ? this.version.hashCode() : 0;
        result = 31 * result + (this.expressionFormat != null ? this.expressionFormat.hashCode() : 0);
        result = 31 * result + this.libraries.hashCode();
        return result;
    }

    public static enum ExpressionFormat {
        raw,
        log10,
        log10_normalized,
        unknown;

    }
}

