/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.annotation;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.OverlapDetector;
import java.io.File;
import java.io.PrintStream;
import org.broadinstitute.dropseqrna.annotation.GeneAnnotationReader;
import org.broadinstitute.dropseqrna.annotation.RefFlatRecord;
import org.broadinstitute.dropseqrna.cmdline.MetaData;
import org.broadinstitute.dropseqrna.utils.io.ErrorCheckingPrintStream;
import picard.annotation.Gene;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;

@CommandLineProgramProperties(usage="If you really want to have refFlat files instead of GTF files, then this is for you.  Pretty handy for Picard tools that accept refFlat instead of GTF files.", usageShort="Convert various annotations formats to RefFlat", programGroup=MetaData.class)
public class ConvertToRefFlat
extends CommandLineProgram {
    @Option(doc="The annotations set to use to label the read.  This can be a GTF or a refFlat file.")
    public File ANNOTATIONS_FILE;
    @Option(shortName="SD", doc="The reference sequence dictionary.  Only chromosomes found in this file AND the annotations file will be retained.")
    public File SEQUENCE_DICTIONARY;
    @Option(shortName="O", doc="The output refFlat file")
    public File OUTPUT;

    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.ANNOTATIONS_FILE);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        OverlapDetector<Gene> od = GeneAnnotationReader.loadAnnotationsFile(this.ANNOTATIONS_FILE, this.SEQUENCE_DICTIONARY);
        ErrorCheckingPrintStream out = new ErrorCheckingPrintStream(IOUtil.openFileForWriting((File)this.OUTPUT));
        for (Gene g : od.getAll()) {
            for (Gene.Transcript t : g) {
                RefFlatRecord r = this.convertTranscript(t);
                out.println(r.toString());
            }
        }
        ((PrintStream)out).close();
        return 0;
    }

    RefFlatRecord convertTranscript(Gene.Transcript t) {
        Gene g = t.getGene();
        RefFlatRecord r = new RefFlatRecord(g.getName(), t.name, g.getContig(), g.isNegativeStrand(), t.transcriptionStart, t.transcriptionEnd, t.codingStart, t.codingEnd);
        for (Gene.Transcript.Exon e : t.exons) {
            r.addExonStart(e.start);
            r.addExonEnd(e.end);
        }
        return r;
    }

    public static void main(String[] args) {
        System.exit(new ConvertToRefFlat().instanceMain(args));
    }
}

